/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class ProjectLayout {
    private final String module;
    private final EnumSet<Language> languages;

    protected ProjectLayout(String module, Language ... languages) {
        this.module = module;
        this.languages = languages.length == 0 ? EnumSet.of(Language.JAVA) : EnumSet.of(languages[0], languages);
    }

    public EnumSet<Language> getLanguages() {
        return this.languages;
    }

    protected List<AnalyzerConfig.Path> path(String[] packs, String ... paths) {
        ArrayList<AnalyzerConfig.Path> res = new ArrayList<AnalyzerConfig.Path>();
        for (String path : paths) {
            String normPath = this.path(path);
            if (packs.length == 0) {
                res.add(new AnalyzerConfig.Path(normPath, ""));
                continue;
            }
            for (String pack : packs) {
                String normPack = pack.replace('.', '/');
                res.add(new AnalyzerConfig.Path(normPath, normPack));
            }
        }
        return res;
    }

    private String path(String relative) {
        if (this.module == null || this.module.length() == 0 || this.runningInModuleDir()) {
            return relative;
        }
        return this.module.endsWith("/") ? this.module + relative : this.module + "/" + relative;
    }

    private boolean runningInModuleDir() {
        return new File("").getAbsoluteFile().getName().equals(this.module);
    }

    public static class Gradle
    extends ProjectLayout {
        public Gradle(String module, Language ... languages) {
            super(module, languages);
        }

        public AnalyzerConfig main(String ... packages) {
            return new AnalyzerConfig(this.getLanguages(), this.path(packages, "src/main/$language/"), this.path(packages, "build/classes/main/", "build/classes/$language/main/", "out/production/classes"));
        }

        public AnalyzerConfig test(String ... packages) {
            return new AnalyzerConfig(this.getLanguages(), this.path(packages, "src/test/$language/"), this.path(packages, "build/classes/test/", "build/classes/$language/test/", "out/test/classes"));
        }

        public AnalyzerConfig mainAndTest(String ... packages) {
            return this.main(packages).and(this.test(packages));
        }
    }

    public static class Maven
    extends ProjectLayout {
        public Maven(String module, Language ... languages) {
            super(module, languages);
        }

        public AnalyzerConfig main(String ... packages) {
            return new AnalyzerConfig(this.getLanguages(), this.path(packages, "src/main/$language/"), this.path(packages, "target/classes/"));
        }

        public AnalyzerConfig test(String ... packages) {
            return new AnalyzerConfig(this.getLanguages(), this.path(packages, "src/test/$language/"), this.path(packages, "target/test-classes/"));
        }

        public AnalyzerConfig mainAndTest(String ... packages) {
            return this.main(packages).and(this.test(packages));
        }
    }
}

