/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.Action;
import guru.nidi.codeassert.config.ActionResult;
import guru.nidi.codeassert.config.Location;
import guru.nidi.codeassert.config.LocationMatcher;
import guru.nidi.codeassert.config.ValuedLocation;
import java.util.Arrays;

public class Minima
implements Action<ValuedLocation> {
    private final LocationMatcher locationMatcher;
    private final String pack;
    private final String clazz;
    private final int[] values;

    Minima(Location loc, String pack, String clazz, int ... values) {
        this.locationMatcher = loc == null ? null : new LocationMatcher(loc);
        this.pack = pack;
        this.clazz = clazz;
        for (int value : values) {
            if (value >= 0 && value <= 100) continue;
            throw new IllegalArgumentException("Invalid value " + value);
        }
        this.values = values;
    }

    public int getValueCount() {
        return this.values.length;
    }

    @Override
    public ActionResult accept(ValuedLocation valLoc) {
        int i;
        int quality = this.matchLocation(valLoc);
        if (quality == 0) {
            return ActionResult.undecided(this);
        }
        for (i = 0; i < valLoc.values.length; ++i) {
            valLoc.appliedLimits[i] = i < this.values.length ? (double)this.values[i] : -1.0;
        }
        for (i = 0; i < valLoc.values.length; ++i) {
            if (!(valLoc.values[i] < valLoc.appliedLimits[i])) continue;
            return ActionResult.accept(this, quality);
        }
        return ActionResult.reject(this, quality);
    }

    private int matchLocation(ValuedLocation valLoc) {
        if (this.locationMatcher == null) {
            int packMatch = this.wildcardMatches(this.pack, valLoc.pack);
            int clazzMatch = this.wildcardMatches(this.clazz, valLoc.clazz);
            if (packMatch == 0 || clazzMatch == 0) {
                return 0;
            }
            return packMatch + clazzMatch;
        }
        if (!this.locationMatcher.matchesPackageClass(valLoc.pack, valLoc.clazz)) {
            return 0;
        }
        return this.locationMatcher.specificity();
    }

    private int wildcardMatches(String pattern, String value) {
        if (pattern.equals(value)) {
            return 3;
        }
        if (this.complexWildcardMatches(pattern, value)) {
            return 2;
        }
        if ("*".equals(pattern) && value.length() > 0) {
            return 1;
        }
        return 0;
    }

    private boolean complexWildcardMatches(String pattern, String value) {
        if (pattern.length() <= 1) {
            return false;
        }
        boolean startWild = pattern.startsWith("*") && value.endsWith(pattern.substring(1));
        boolean endWild = pattern.endsWith("*") && value.startsWith(pattern.substring(0, pattern.length() - 1));
        return startWild || endWild;
    }

    public String toString() {
        return "    minima for " + this.pack + "." + this.clazz + ": " + Arrays.toString(this.values);
    }
}

