/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.Language;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Location
implements Comparable<Location> {
    private static final Pattern CLASS_START = Pattern.compile("(^|\\.)[*+]?[A-Z]");
    final Language language;
    final String pack;
    final String clazz;
    final String method;

    private Location(Language language, String pack, String clazz, String method) {
        Location.checkPattern(pack);
        Location.checkPattern(clazz);
        Location.checkPattern(method);
        this.language = language;
        this.pack = pack;
        this.clazz = clazz;
        this.method = method;
    }

    public static Location all() {
        return new Location(null, "", "", "");
    }

    public static Location ofLanguage(Language language) {
        return new Location(language, "", "", "");
    }

    public static Location ofPackage(String pack) {
        Location.checkPattern(pack);
        return new Location(null, pack, "", "");
    }

    public static Location ofClass(Class<?> clazz) {
        return Location.of(clazz.getName());
    }

    public static Location ofClass(String clazz) {
        Location.checkPattern(clazz);
        return new Location(null, "", clazz, "");
    }

    public static Location ofMethod(String method) {
        Location.checkPattern(method);
        return new Location(null, "", "", method);
    }

    public static Location of(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Empty pattern");
        }
        int colon = pattern.indexOf(58);
        return colon < 0 ? Location.of(null, pattern) : Location.of(Language.valueOf(pattern.substring(0, colon).toUpperCase(Locale.ENGLISH)), pattern.substring(colon + 1));
    }

    private static Location of(Language language, String rest) {
        int hash = rest.indexOf(35);
        return hash < 0 ? Location.of(language, "", rest) : Location.of(language, rest.substring(hash + 1), rest.substring(0, hash));
    }

    private static Location of(Language language, String method, String rest) {
        int slash = rest.indexOf(47);
        if (slash >= 0) {
            return new Location(language, rest.substring(0, slash), rest.substring(slash + 1), method);
        }
        Matcher matcher = CLASS_START.matcher(rest);
        if (matcher.find()) {
            String clazz = rest.substring(matcher.start() + matcher.group(1).length());
            return new Location(language, rest.substring(0, matcher.start()), clazz, method);
        }
        return new Location(language, rest, "", method);
    }

    public Location andLanguage(Language language) {
        return new Location(language, this.pack, this.clazz, this.method);
    }

    public Location andPackage(String pack) {
        return new Location(this.language, pack, this.clazz, this.method);
    }

    public Location andClass(String clazz) {
        return new Location(this.language, this.pack, clazz, this.method);
    }

    public Location andMethod(String method) {
        return new Location(this.language, this.pack, this.clazz, method);
    }

    public String getPattern() {
        boolean noPackEndDot = this.pack.endsWith("*") || this.pack.endsWith("+") || this.pack.length() == 0;
        return (this.language == null ? "" : (Object)((Object)this.language) + ":") + (noPackEndDot || this.clazz.length() == 0 ? this.pack : this.pack + ".") + this.clazz + (this.method.length() == 0 ? "" : "#" + this.method);
    }

    private static void checkPattern(String pattern) {
        if ("**".equals(pattern) || "+*".equals(pattern) || "*+".equals(pattern) || "++".equals(pattern)) {
            throw new IllegalArgumentException("Wildcard " + pattern + " is illegal");
        }
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) != '*' && pattern.charAt(i) != '+' || i == 0 || i == pattern.length() - 1) continue;
            throw new IllegalArgumentException("Wildcards must be at begin or end of a pattern");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (this.language != location.language) {
            return false;
        }
        if (!this.pack.equals(location.pack)) {
            return false;
        }
        if (!this.clazz.equals(location.clazz)) {
            return false;
        }
        return this.method.equals(location.method);
    }

    public int hashCode() {
        int result = this.language != null ? this.language.hashCode() : 0;
        result = 31 * result + this.pack.hashCode();
        result = 31 * result + this.clazz.hashCode();
        result = 31 * result + this.method.hashCode();
        return result;
    }

    public String toString() {
        return this.getPattern();
    }

    @Override
    public int compareTo(Location o) {
        return this.getPattern().compareTo(o.getPattern());
    }
}

