/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.Action;

public class ActionResult {
    final boolean accept;
    final Action<?> action;
    final int quality;

    public ActionResult(boolean accept, Action<?> action, int quality) {
        this.accept = accept;
        this.action = action;
        this.quality = quality;
    }

    public static ActionResult accept(Action<?> action, int quality) {
        return new ActionResult(true, action, quality);
    }

    public static ActionResult reject(Action<?> action, int quality) {
        return new ActionResult(false, action, quality);
    }

    public static ActionResult undecided(Action<?> action) {
        return new ActionResult(false, action, 0);
    }

    public static ActionResult acceptIfTrue(boolean accept, Action<?> action, int quality) {
        return accept ? ActionResult.accept(action, quality) : ActionResult.undecided(action);
    }

    public static ActionResult rejectIfFalse(boolean accept, Action<?> action, int quality) {
        return accept ? ActionResult.undecided(action) : ActionResult.reject(action, quality);
    }

    public boolean isUndecided() {
        return this.quality == 0;
    }

    public ActionResult orMoreQuality(ActionResult result) {
        return this.quality >= result.quality ? this : result;
    }
}

