/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.gui;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import guru.nidi.codeassert.model.JavaClass;
import guru.nidi.codeassert.model.JavaPackage;
import java.io.IOException;
import java.util.Map;

public class JavaClassSerializer
extends StdSerializer<JavaClass> {
    protected JavaClassSerializer(Class<JavaClass> t) {
        super(t);
    }

    public void serialize(JavaClass value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("name", value.getName());
        gen.writeStringField("package", value.getPackage().getName());
        gen.writeNumberField("size", value.getTotalSize());
        gen.writeArrayFieldStart("usePackages");
        for (JavaPackage javaPackage : value.usedPackages()) {
            gen.writeString(javaPackage.getName());
        }
        gen.writeEndArray();
        gen.writeObjectFieldStart("useClasses");
        for (Map.Entry entry : value.usedClassCounts().entrySet()) {
            gen.writeNumberField(((JavaClass)entry.getKey()).getName(), ((Integer)entry.getValue()).intValue());
        }
        gen.writeEndObject();
        gen.writeEndObject();
    }
}

