/*
 * Decompiled with CFR 0.152.
 */
package gui.ava.html.image.generator;

import gui.ava.html.image.util.FormatNameUtil;
import gui.ava.html.image.util.SynchronousHTMLEditorKit;
import gui.ava.html.link.LinkHarvester;
import gui.ava.html.link.LinkInfo;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;

public class HtmlImageGenerator {
    private JEditorPane editorPane = this.createJEditorPane();
    static final Dimension DEFAULT_SIZE = new Dimension(800, 800);

    public ComponentOrientation getOrientation() {
        return this.editorPane.getComponentOrientation();
    }

    public void setOrientation(ComponentOrientation orientation) {
        this.editorPane.setComponentOrientation(orientation);
    }

    public Dimension getSize() {
        return this.editorPane.getSize();
    }

    public void setSize(Dimension dimension) {
        this.editorPane.setSize(dimension);
    }

    public void loadUrl(URL url) {
        try {
            this.editorPane.setPage(url);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception while loading %s", url), e);
        }
    }

    public void loadUrl(String url) {
        try {
            this.editorPane.setPage(url);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception while loading %s", url), e);
        }
    }

    public void loadHtml(String html) {
        this.editorPane.setText(html);
        this.onDocumentLoad();
    }

    public String getLinksMapMarkup(String mapName) {
        StringBuilder markup = new StringBuilder();
        markup.append("<map name=\"").append(mapName).append("\">\n");
        for (LinkInfo link : this.getLinks()) {
            List<Rectangle> bounds = link.getBounds();
            for (Rectangle bound : bounds) {
                int x1 = (int)bound.getX();
                int y1 = (int)bound.getY();
                int x2 = (int)((double)x1 + bound.getWidth());
                int y2 = (int)((double)y1 + bound.getHeight());
                markup.append(String.format("<area coords=\"%s,%s,%s,%s\" shape=\"rect\"", x1, y1, x2, y2));
                for (Map.Entry<String, String> entry : link.getAttributes().entrySet()) {
                    String attName = entry.getKey();
                    String value = entry.getValue();
                    markup.append(" ").append(attName).append("=\"").append(value.replace("\"", "&quot;")).append("\"");
                }
                markup.append(">\n");
            }
        }
        markup.append("</map>\n");
        return markup.toString();
    }

    public List<LinkInfo> getLinks() {
        LinkHarvester harvester = new LinkHarvester(this.editorPane);
        return harvester.getLinks();
    }

    public void saveAsHtmlWithMap(String file, String imageUrl) {
        this.saveAsHtmlWithMap(new File(file), imageUrl);
    }

    public void saveAsHtmlWithMap(File file, String imageUrl) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
            writer.append("<html>\n<head></head>\n");
            writer.append("<body style=\"margin: 0; padding: 0; text-align: center;\">\n");
            String htmlMap = this.getLinksMapMarkup("map");
            writer.write(htmlMap);
            writer.append("<img border=\"0\" usemap=\"#map\" src=\"");
            writer.append(imageUrl);
            writer.append("\"/>\n");
            writer.append("</body>\n</html>");
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception while saving '%s' html file", file), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public void saveAsImage(String file) {
        this.saveAsImage(new File(file));
    }

    public void saveAsImage(File file) {
        BufferedImage img = this.getBufferedImage();
        try {
            String formatName = FormatNameUtil.formatForFilename(file.getName());
            ImageIO.write((RenderedImage)img, formatName, file);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception while saving '%s' image", file), e);
        }
    }

    protected void onDocumentLoad() {
    }

    public Dimension getDefaultSize() {
        return DEFAULT_SIZE;
    }

    public BufferedImage getBufferedImage() {
        Dimension prefSize = this.editorPane.getPreferredSize();
        BufferedImage img = new BufferedImage(prefSize.width, this.editorPane.getPreferredSize().height, 2);
        Graphics graphics = img.getGraphics();
        this.editorPane.setSize(prefSize);
        this.editorPane.paint(graphics);
        return img;
    }

    protected JEditorPane createJEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setSize(this.getDefaultSize());
        editorPane.setEditable(false);
        SynchronousHTMLEditorKit kit = new SynchronousHTMLEditorKit();
        editorPane.setEditorKitForContentType("text/html", kit);
        editorPane.setContentType("text/html");
        editorPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("page")) {
                    HtmlImageGenerator.this.onDocumentLoad();
                }
            }
        });
        return editorPane;
    }
}

