/*
 * U.java
 *
 * Created on July 3, 2004, 12:50 AM
 */

package findstruct;
import java.util.*;
import java.text.*;

/**
<p>This is a class whose static methods provide a set of useful utilities for 
  the rest of the DBWeb package.</p>
<p>The first set of utilities splits strings into lists or arrays of substrings 
  at each occurrence of a separator character.</p>
<p>The second converts strings into formats that can be safely displayed in HTML 
  or manipulated in SQL expressions.</p>
<p>The third defines common formats for displaying and parsing dates at day, month 
  and year granularities and in the format used to communicate dates to SQL.</p>
 * @author  psz
 */
public class U {
    
    /** Creates a new instance of U, but should never be useful. */
    public U() {
    }
    
    /**
     *Splits a String s into substrings wherever the single-character String c
     *appears. C itself is discarded, and the substrings are trim'd.  For example,
     * split("foo, bar, baz",",") ==> {"foo", "bar", "baz"}
     *
     *@param s String to be split
     *@param c String where splits are to occur
     *@return String[] holding the resulting Strings
     */
    public static String[] split(String s, String c) {
        if (c.length()==1 && !Character.isJavaIdentifierPart(c.charAt(0))) {
            c = "\\" + c;
        }
        String[] res=s.split(c);
        for (int i=0; i<res.length; i++) {
            res[i]=res[i].trim();
        }
        return res;
    }
  
    /**
     *Concatenates its List of String inputs with spaces between elements into
     *a single string.
     *@param l List of inputs
     *@return String holding the result.
     */
    public static String concatenate(List l) {
        return concatenate(l, " ");
    }
     /**
     *Concatenates its List of String inputs with sep between elements into
     *a single string.
     *@param l List of inputs
     *@param sep String to separate input elements in the output.
     *@return String holding the result.
     */
   
    public static String concatenate(List l, String sep) {
        StringBuffer sb = new StringBuffer();
        if (l!=null) {
            String s = "";
            Iterator it = l.iterator();
            while(it.hasNext()) {
                sb.append(s);
                sb.append(it.next());
                s = sep;
            }
        }
        return sb.toString();
    }
     /**
     *Concatenates its String[] inputs with spaces between elements into
     *a single string.
     *@param l String[] of inputs
     *@return String holding the result.
     */
   
    public static String concatenate(String[] l) {
        return concatenate(l," ");
    }
     /**
     *Concatenates its String[] inputs with sep between elements into
     *a single string.
     *@param l String[] of inputs
     *@param sep String to separate input elements in the output.
     *@return String holding the result.
     */
   
    public static String concatenate(String[] l, String sep) {
        StringBuffer sb = new StringBuffer();
        String s = "";
        for (int i=0; i<l.length; i++) {
            sb.append(s);
            sb.append(l[i]);
            s = sep;
        }
        return sb.toString();
    }
    
    /**
     *Tests to see if its input String is null or the empty string.
     *@param s String to be tested
     *@return Boolean true if null or the empty string, false otherwise.
     */
    public static boolean isNull(String s) {
        return (s == null) || s.equals("");
    }
    
    /**
     *Tests to see if its input String is not null and not the empty string.
     *@param s String to be tested
     *@return Boolean false if null or the empty string, true otherwise.
     */
    
    public static boolean isNotNull(String s) {
        return !isNull(s);
    }

    /**
     * Encodes characters that are interpreted specially by HTML into
     * their HTML equivalents.  
     * Transformations: < to &lt;, > to &gt;, etc.
     * @param s String to be encoded
     * @return String holding encoded value
     */

    public static String HTMLEncode(String s) {
	StringBuffer st = new StringBuffer();
	for (int i = 0; i < s.length(); i++) {
	    boolean copy = true;
	    char ch = s.charAt(i);
	    for (int j = 0; j < c.length ; j++) {
		if (c[j]==ch) {
		    st.append(expansion[j]);
		    copy = false;
		    break;
		}
	    }
	    if (copy) st.append(ch);
	}
	return st.toString();
    }

    private static final char c[] = { '<', '>', '&', '\"'};
    private static final String expansion[] = {"&lt;", "&gt;", "&amp;", "&quot;"};
    /**
     *Encodes a String into one appropriate for sending to SQL.  Essentially,
     *this just means doubling single-quotes and surrounding the entire string
     *in single-quotes.
     *@param s String to be encoded
     *@return String holding the encoded version
     */
    public static String SQLEncode(String s) {
        StringBuffer st = new StringBuffer("'");
            for (int i = 0; i < s.length(); i++) {
                char ch = s.charAt(i);
                if (ch == '\'') st.append('\'');
                st.append(s.charAt(i));
            }
        st.append("'");
        return st.toString();
    }

    /**
     * DateFormats for simple forms of dates we often find useful:
     * 12/25/1975, Sep. 1993, 1942, 1975-12-25.
     */
    /** DateFormat for simple dates such as 12/25/1975.
     */

    public static final SimpleDateFormat mdyDateFormat
	= new SimpleDateFormat("MM/dd/yyyy");

    /** DateFormat for simple dates such as Dec 1975.
     */

    public static final SimpleDateFormat myDateFormat
	= new SimpleDateFormat("MMM yyyy");

    /** DateFormat for simple dates such as 12/25/1975.
     */

    public static final SimpleDateFormat yDateFormat
	= new SimpleDateFormat("yyyy");

    /** DateFormat for simple dates in the form communicated to SQL,
     * such as 1975-12-25.
     */

    public static final SimpleDateFormat sqlDateFormat
	= new SimpleDateFormat("yyyy-MM-dd");

    static {
	mdyDateFormat.setLenient(false);
	myDateFormat.setLenient(false);
	yDateFormat.setLenient(false);
	sqlDateFormat.setLenient(false);
    }
    

    /**
     * parseDate returns a date in it normal Java numeric
     * format by parsing the String stored under key in one of the forms 
     * 12/25/1975, Jan 1975, or 1975.
     *@param s String holding the date
     *@return java.util.Date or null if it could not be parsed.
     */
    
    public static java.util.Date parseDate(String s) {
        if (isNull(s)) return null;
        java.util.Date d = null;
        try {
	    d = sqlDateFormat.parse(s);
	} 
        catch (ParseException e) {
            try {
                d = mdyDateFormat.parse(s);
	    } 
            catch (ParseException e1) {
                try {
		    d = myDateFormat.parse(s);
		} 
                catch (ParseException e2) {
                    try{
                        d = yDateFormat.parse(s);
                    } 
                    catch (ParseException e3) {}
                }
	    }
	}
        return d;
    }
    /** Formats a String holding a representation of a date into the form
     *appropriate to use in SQL statements.
    */
    public static String toDSql(String val) {
        if (isNull(val)) return "";
	java.util.Date d = parseDate(val);
	if (d==null) return "";
	return new java.sql.Date(d.getTime()).toString();
    }
    
    /** Formats a String holding a representation of a date into the form
     * 12/25/1975.
    */
    public static String toDmdy(String val) {
        if (isNull(val)) return "";
	java.util.Date d = parseDate(val);
	if (d==null) return "";
	return mdyDateFormat.format(d);
    }
    
    /** Formats a String holding a representation of a date into the form
     * Dec 1975.
    */
    public static String toDmy(String val) {
        if (isNull(val)) return "";
	java.util.Date d = parseDate(val);
	if (d==null) return "";
	return myDateFormat.format(d);
    }
    
    /** Formats a String holding a representation of a date into the form
     * 1075.
    */
    public static String toDy(String val) {
        if (val == null || val.equals("")) return "";
	java.util.Date d = parseDate(val);
	if (d==null) return "";
	return yDateFormat.format(d);
    }
    
    /** Formats today's date into the form
     *appropriate to use in SQL statements.
    */
    public static String todaySql() {
        java.util.Date d = new java.util.Date();
        return new java.sql.Date(d.getTime()).toString();
    }
    /** Capitalizes the first letter of a string.
     *@param s String input
     *@return String with the capitalized first letter.
     */
    public static String toCapitalized(String s) {
        if (s==null || s.length()<1) return s;
        return s.substring(0,1).toUpperCase() + s.substring(1);
    }

}
