/*
 * TextReader.java
 *
 * Created on April 9, 2005, 12:22 PM
 */

package findstruct;
import java.io.*;
import java.util.*;

/**Convenience class to support reading of lines or blocks of text from a
 *buffered file reader.  A block of text ends with a line of all white space
 *or the end of the file.
 *
 * @author psz
 */
public class TextReader {
    
    BufferedReader r;
    
    /** Creates a new instance of TextReader */
    public TextReader(File f) throws FileNotFoundException {
        r = new BufferedReader(new FileReader(f));
    }
    
    public String readLine() throws IOException {
        return r.readLine();
    }
    
    public DParagraph readParagraph() throws IOException {
        return new DParagraph(readBlock());
    }
    
    public String readBlock() throws IOException {
        StringBuffer block = new StringBuffer();
        String line;
        while ((line = r.readLine())!=null) {
            line = line.trim();
            if (line.equals("")) break;
            block.append(line);
            block.append("\n");
        }
        return (block.length()==0) ? null : block.toString();
    }
}
