/*
 * MakeIndex.java
 *
 * Created on December 8, 2005, 12:16 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package findstruct;

/**Creates an index of structural information about the input file.  This can then
 *be used to find structure and annotations in that file efficiently, without
 *modifying the file itself.  This is an alternative to parsing the original file into
 *an XML-encoded representation of its content, which is done by StructModel's process
 *method.  As is the case with the XML-encoded version, we don't want to consider text
 *that has been used to determine the structure of the file to be part of its content.
 *Therefore, we provide methods to iterate through the content of the file by word or
 *sentence or paragraph, where we guarantee that no such component is interrupted by
 *structure markers.  E.g., "Unremarkable history PHYSICAL EXAMINATION: alert and
 *oriented." would yield two sentences even though there is no period ending the first,
 *because it is interrupted by a marker for structure.
 *
 *In addition, we support a query for any location of the input asking for all its
 *annotations.  The "structure" annotation returns a DocStruct that shows the hierarchic
 *structure at that location.  Further annotations may be made on individual words,
 *sentences, paragraphs, or ranges of the input text.
 *
 * @author psz
 */
public class MakeIndex {
    
    /** Creates a new instance of MakeIndex */
    public MakeIndex() {
    }
    
}
