/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.validate;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.validate.IReporter;

public class DefaultReporter
implements IReporter {
    protected final String OWNER_KEY = "owner";
    protected final String VALIDATION_SEVERITY_KEY = "validationSeverity";
    protected final String OLD_VALIDATOR_ID = "com.ibm.etools.validate.wsdl.vfp.WSDLValidator".intern();
    protected final String OLD_OWNER_ID = "wsdlvalidator";
    protected final String PROBLEMMARKER = "com.ibm.etools.validation.problemmarker";
    protected String ownerId;

    public DefaultReporter(String ownerId) {
        this.ownerId = ownerId;
    }

    protected IMarker addMessage(IResource resource, String message, int line, int column, int severity, String markerType) {
        try {
            IMarker marker = resource.createMarker(markerType);
            String[] attNames = new String[5];
            Object[] attValues = new Object[5];
            attNames[0] = "owner";
            attValues[0] = this.ownerId;
            attNames[1] = "lineNumber";
            attValues[1] = new Integer(line);
            attNames[2] = "severity";
            attValues[2] = new Integer(severity);
            attNames[3] = "message";
            attValues[3] = message;
            attNames[4] = "validationSeverity";
            attValues[4] = new Integer(severity);
            marker.setAttributes(attNames, attValues);
            return marker;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void removeAllMessages(IResource resource) {
        try {
            IMarker[] markers = resource.findMarkers(null, true, 0);
            IMarker[] deleteMarkers = new IMarker[markers.length];
            int deleteindex = 0;
            int i = markers.length - 1;
            while (i >= 0) {
                IMarker marker = markers[i];
                Object owner = marker.getAttribute("owner");
                if (owner != null && owner instanceof String && (owner.equals(this.ownerId) || owner.equals(this.OLD_VALIDATOR_ID) || owner.equals("wsdlvalidator"))) {
                    deleteMarkers[deleteindex++] = markers[i];
                }
                --i;
            }
            if (deleteindex > 0) {
                IMarker[] todelete = new IMarker[deleteindex];
                System.arraycopy(deleteMarkers, 0, todelete, 0, deleteindex);
                resource.getWorkspace().deleteMarkers(todelete);
            }
        }
        catch (CoreException coreException) {}
    }

    public IMarker addErrorMessage(IResource resource, String message, int line, int column) {
        return this.addErrorMessage(resource, message, line, column, "org.eclipse.core.resources.problemmarker");
    }

    public IMarker addErrorMessage(IResource resource, String message, int line, int column, String markerType) {
        return this.addMessage(resource, message, line, column, 2, markerType);
    }

    public IMarker addWarningMessage(IResource resource, String message, int line, int column) {
        return this.addWarningMessage(resource, message, line, column, "org.eclipse.core.resources.problemmarker");
    }

    public IMarker addWarningMessage(IResource resource, String message, int line, int column, String markerType) {
        return this.addMessage(resource, message, line, column, 1, markerType);
    }

    public String getValidatorID() {
        return this.ownerId;
    }
}

