/*
 * Copyright 2002-2005 Uwyn bvba/sprl <info[remove] at uwyn dot com>
 * Distributed under the terms of the GNU Lesser General Public
 * License, v2.1 or later
 *
 * $Id: in_co_daffodil_db_jdbc_DaffodilDBDriver.java 1322 2005-02-14 11:16:07Z gbevin $
 */
package com.uwyn.drone.modules.seenmanagement.databasedrivers;

import com.uwyn.drone.modules.seenmanagement.SeenData;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.Update;

public class in_co_daffodil_db_jdbc_DaffodilDBDriver extends generic
{
	public in_co_daffodil_db_jdbc_DaffodilDBDriver(Datasource datasource)
	{
		super(datasource);

		mGetSeen = (Select)new Select(getDatasource())
			.from("seen")
			.whereParameter("botname", "=")
			.whereParameterAnd("channel", "=")
			.whereParameterAnd("servername", "=")
			.whereParameterAnd("lcase(nickname)", "nickname", "=");

		mUpdateSeen = (Update)new Update(getDatasource())
			.table("seen")
			.fieldsParameters(SeenData.class)
			.whereParameter("botname", "=")
			.whereParameterAnd("channel", "=")
			.whereParameterAnd("servername", "=")
			.whereParameterAnd("lcase(nickname)", "currentnickname", "=");
	}
}
