/*
 * Copyright 2002-2005 Uwyn bvba/sprl <info[remove] at uwyn dot com>
 * Distributed under the terms of the GNU Lesser General Public
 * License, v2.1 or later
 *
 * $Id: org_postgresql_Driver.java 1178 2005-01-05 20:38:38Z gbevin $
 */
package com.uwyn.drone.modules.faqmanagement.databasedrivers;

import com.uwyn.rife.database.queries.*;

import com.uwyn.drone.core.Bot;
import com.uwyn.drone.modules.exceptions.FaqManagerException;
import com.uwyn.drone.modules.faqmanagement.DatabaseFaqs;
import com.uwyn.drone.modules.faqmanagement.FaqData;
import com.uwyn.rife.database.Datasource;

public class generic extends DatabaseFaqs
{
	protected CreateSequence	mCreateSequenceFaq = null;
	protected CreateTable		mCreateTableFaq = null;
	protected SequenceValue		mGetFaqId = null;
	protected Insert			mAddFaq = null;
	protected Update			mEditFaq = null;
	protected Select			mGetFaq = null;
	protected Select			mGetFaqById = null;
	protected Select			mGetRandomFaqIds = null;
	protected Update			mSetRandom = null;
	protected Delete			mRemoveFaq = null;
	protected DropSequence		mDropSequenceFaq = null;
	protected DropTable			mDropTableFaq = null;
	
	public generic(Datasource datasource)
	{
		super(datasource);

		mCreateSequenceFaq = new CreateSequence(getDatasource())
			.name("SEQ_FAQ");

		mCreateTableFaq = new CreateTable(getDatasource())
			.table("faq")
			.columns(FaqData.class)
			.column("botname", String.class, 30, CreateTable.NOTNULL)
			.primaryKey("FAQ_PK", "id")
			.unique("FAQ_KEY_UQ", new String[] {"botname", "lowcasekey"})
			.unique("FAQ_NAME_UQ", new String[] {"botname", "name"});

		mGetFaqId = new SequenceValue(getDatasource())
			.name("SEQ_FAQ")
			.next();

		mAddFaq = new Insert(getDatasource())
			.into("faq")
			.fieldsParameters(FaqData.class)
			.fieldParameter("botname");

		mEditFaq = (Update)new Update(getDatasource())
			.table("faq")
			.fieldsParametersExcluded(FaqData.class, new String[] {"id"})
			.whereParameter("id", "=");

		mGetFaq = (Select)new Select(getDatasource())
			.from("faq")
			.field("*")
			.whereParameter("botname", "=")
			.whereParameterAnd("lowcasekey", "=");

		mGetFaqById = (Select)new Select(getDatasource())
			.from("faq")
			.field("*")
			.whereParameter("id", "=");

		mGetRandomFaqIds = (Select)new Select(getDatasource())
			.from("faq")
			.field("id")
			.where("random", "=", true)
			.whereParameterAnd("botname", "=");

		mSetRandom = (Update)new Update(getDatasource())
			.table("faq")
			.fieldParameter("random")
			.whereParameter("botname", "=")
			.whereParameterAnd("lowcasekey", "=");

		mRemoveFaq = (Delete)new Delete(getDatasource())
			.from("faq")
			.whereParameter("botname", "=")
			.whereParameterAnd("lowcasekey", "=");

		mDropSequenceFaq = new DropSequence(getDatasource())
			.name("SEQ_FAQ");

		mDropTableFaq = new DropTable(getDatasource())
			.table("faq");
	}
	
	public boolean install()
	throws FaqManagerException
	{
		return _install(mCreateSequenceFaq, mCreateTableFaq);
	}

	public int addFaq(Bot bot, FaqData faqData)
	throws FaqManagerException
	{
		return _addFaq(mGetFaqId, mAddFaq, bot, faqData);
	}

	public boolean editFaq(FaqData faqData)
	throws FaqManagerException
	{
		return _editFaq(mEditFaq, faqData);
	}
	
	public FaqData getFaq(Bot bot, String name)
	throws FaqManagerException
	{
		return _getFaq(mGetFaq, bot, name);
	}
	
	public FaqData getFaqById(int id)
	throws FaqManagerException
	{
		return _getFaqById(mGetFaqById, id);
	}
	
	public FaqData getRandomFaq(Bot bot)
	throws FaqManagerException
	{
		return _getRandomFaq(mGetRandomFaqIds, bot);
	}
	
	public boolean setRandom(Bot bot, String name, boolean state)
	throws FaqManagerException
	{
		return _setRandom(mSetRandom, bot, name, state);
	}
	
	public boolean removeFaq(Bot bot, String name)
	throws FaqManagerException
	{
		return _removeFaq(mRemoveFaq, bot, name);
	}

	public boolean remove()
	throws FaqManagerException
	{
		return _remove(mDropSequenceFaq, mDropTableFaq);
	}
}
