/*
 * Copyright 2002-2005 Uwyn bvba/sprl <info[remove] at uwyn dot com>
 * Distributed under the terms of the GNU Lesser General Public
 * License, v2.1 or later
 *
 * $Id: BotList.java 1584 2005-03-13 09:31:31Z gbevin $
 */
package com.uwyn.drone.webui.elements.pub;

import com.uwyn.drone.core.*;
import com.uwyn.rife.tools.*;
import java.util.*;

import com.uwyn.rife.engine.Element;
import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.template.Template;

public class BotList extends Element
{
	private Template	mTemplate = null;
	
	static Bot validateBotName(ArrayList errors, String botname)
	{
		if (null == botname)
		{
			errors.add(new ValidationError.MANDATORY("botname"));
		}
		else if (!BotFactory.contains(botname))
		{
			errors.add(new ValidationError.INVALID("botname"));
		}
		else
		{
			return BotFactory.get(botname);
		}
		
		return null;
	}
	
	public void processElement()
	{
		mTemplate = getHtmlTemplate("drone.pub.bot_list");

		// output the bot list and the possible actions
		generateBotsList();
		
		print(mTemplate);
	}
	
	private void generateBotsList()
	{
		Collection	bots = BotsRunner.getRepInstance().getBots();
		Iterator	bots_it = bots.iterator();
		Bot			bot = null;
		while (bots_it.hasNext())
		{
			bot = (Bot)bots_it.next();
			
			mTemplate.setValue("botname", encodeHtml(bot.getName()));
			mTemplate.setValue("connected_nick", encodeHtml(bot.getConnectedNick()));
			mTemplate.setValue("nicks", encodeHtml(bot.getNick()+", "+bot.getAltNick()));
			
			HashMap		server_channels = new HashMap();
			String		server_name = null;
			ArrayList	channel_names = null;
			
			Iterator	joined_channels_it = bot.getJoinedChannels().iterator();
			Channel		channel = null;
			while (joined_channels_it.hasNext())
			{
				channel = (Channel)joined_channels_it.next();
				
				server_name = channel.getServer().getServerName();
				channel_names = (ArrayList)server_channels.get(server_name);
				if (null == channel_names)
				{
					channel_names = new ArrayList();
					server_channels.put(server_name, channel_names);
				}
				channel_names.add(channel.getName());
			}
			
			SortListComparables sort = new SortListComparables();
			mTemplate.removeValue("servers");
			
			Iterator	server_channels_it = server_channels.keySet().iterator();
			String		server = null;
			while (server_channels_it.hasNext())
			{
				server = (String)server_channels_it.next();
				
				mTemplate.setValue("server", encodeHtml(server));
				
				channel_names = (ArrayList)server_channels.get(server);
				
				sort.sort(channel_names);
				mTemplate.removeValue("channels");
				
				Iterator	channel_names_it = channel_names.iterator();
				String		channel_name = null;
				while (channel_names_it.hasNext())
				{
					channel_name = (String)channel_names_it.next();
					setExitQuery(mTemplate, "show_channel_log", "/"+StringUtils.encodeUrl(bot.getName())+"/"+StringUtils.encodeUrl(channel_name.substring(1)));
					
					mTemplate.setValue("channel", encodeHtml(channel_name));
					mTemplate.appendBlock("channels", "channel");
				}
				
				mTemplate.appendBlock("servers", "server");
			}
			
			mTemplate.appendBlock("bots", "bot");
		}
	}
}

