/*
 * Copyright 2002-2005 Uwyn bvba/sprl <info[remove] at uwyn dot com>
 * Distributed under the terms of the GNU Lesser General Public
 * License, v2.1 or later
 *
 * $Id: Remove.java 1178 2005-01-05 20:38:38Z gbevin $
 */
package com.uwyn.drone.webui.elements.admin.modules.seen;

import com.uwyn.drone.modules.exceptions.SeenManagerException;
import com.uwyn.drone.modules.seenmanagement.DatabaseSeen;
import com.uwyn.drone.modules.seenmanagement.DatabaseSeenFactory;
import com.uwyn.rife.engine.Element;
import com.uwyn.rife.site.ValidationBuilderXhtml;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.tools.ExceptionUtils;
import java.util.logging.Logger;

public class Remove extends Element
{
	private Template mTemplate = null;
	
	public void initialize()
	{
		mTemplate = getHtmlTemplate("drone.admin.modules.seen.remove");
	}
	
	public void processElement()
	{
		print(mTemplate);
	}
	
	public void doConfirm()
	{
		DatabaseSeen	database_seen = DatabaseSeenFactory.get();
		try
		{
			database_seen.remove();
			mTemplate.setBlock("authenticated_content", "removed_content");
		}
		catch (SeenManagerException e)
		{
			ValidationBuilderXhtml builder = new ValidationBuilderXhtml();
			builder.setFallbackErrorArea(mTemplate, e.getCause().getMessage());
			Logger.getLogger("com.uwyn.drone.webui").severe(ExceptionUtils.getExceptionStackTrace(e));
		}

		print(mTemplate);
	}
}

