/*
 * Copyright 2002-2005 Uwyn bvba/sprl <info[remove] at uwyn dot com>
 * Distributed under the terms of the GNU Lesser General Public
 * License, v2.1 or later
 *
 * $Id: Install.java 1178 2005-01-05 20:38:38Z gbevin $
 */
package com.uwyn.drone.webui.elements.admin.modules.faq;

import com.uwyn.drone.modules.exceptions.FaqManagerException;
import com.uwyn.drone.modules.faqmanagement.DatabaseFaqs;
import com.uwyn.drone.modules.faqmanagement.DatabaseFaqsFactory;
import com.uwyn.rife.engine.Element;
import com.uwyn.rife.site.ValidationBuilderXhtml;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.tools.ExceptionUtils;
import java.util.logging.Logger;

public class Install extends Element
{
	private Template mTemplate = null;
	
	public void initialize()
	{
		mTemplate = getHtmlTemplate("drone.admin.modules.faq.install");
	}
	
	public void processElement()
	{
		print(mTemplate);
	}
	
	public void doConfirm()
	{
		DatabaseFaqs	database_faq = DatabaseFaqsFactory.get();
		try
		{
			database_faq.install();
			mTemplate.setBlock("authenticated_content", "installed_content");
		}
		catch (FaqManagerException e)
		{
			ValidationBuilderXhtml builder = new ValidationBuilderXhtml();
			builder.setFallbackErrorArea(mTemplate, e.getCause().getMessage());
			Logger.getLogger("com.uwyn.drone.webui").severe(ExceptionUtils.getExceptionStackTrace(e));
		}
		
		print(mTemplate);
	}
}

