#!/bin/sh
# Copyright 2003 Geert Bevin <gbevin@uwyn.com>
# Distributed under the terms of the GNU General Public License, v2 or later
# $Id: drone.sh 1322 2005-02-14 11:16:07Z gbevin $

PROGDIR="`dirname $0`"
case "${PROGDIR}" in
	[^/]*)
		export PROGDIR="`pwd`/${PROGDIR}"
		;;
esac
export PROGDIR="$PROGDIR/.."
JETTY=$(ls -d $PROGDIR/jetty*)
mkdir -p "$JETTY/logs"
export JETTY_CONSOLE="$JETTY/logs/out.log"
export JETTY_HOME="$JETTY"
cd $JETTY_HOME
java -classpath "$PROGDIR/config:$JETTY_HOME/lib/javax.servlet.jar:$JETTY_HOME/lib/org.mortbay.jetty.jar:$PROGDIR/lib/lucene-1.5-rc1-dev.jar:$PROGDIR/lib/lucene-analyzers-cvs-20041213.jar:$PROGDIR/lib/lucene-highlighter-cvs-20041208.jar:$PROGDIR/lib/mysql-connector-java-3.0.14-production-bin.jar:$PROGDIR/lib/postgres-jdbc-7.4-214-jdbc3.jar:$PROGDIR/lib/rife-1.0rc1.jar:$PROGDIR/lib/rife-search-0.1.jar:$PROGDIR/build/dist/drone-1.2.jar" -Djetty.home="$JETTY_HOME" -Drife.webapp.path=../src:../build/dist:../lib org.mortbay.jetty.Server "$JETTY_HOME/etc/jetty.xml"
