/*
 * Decompiled with CFR 0.152.
 */
package pnuts.ext;

import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.util.BSFEngineImpl;
import pnuts.ext.CachedPnutsImpl;
import pnuts.lang.Context;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsImpl;
import pnuts.lang.Runtime;

public class PnutsBSFEngine
extends BSFEngineImpl {
    private Context context;
    private Package pkg = new Package();

    public PnutsBSFEngine() {
        this.context = new Context(this.pkg);
        this.context.setPnutsImpl((PnutsImpl)new CachedPnutsImpl());
    }

    public Object eval(String source, int lineNo, int columnNo, Object script) throws BSFException {
        try {
            return Pnuts.eval((String)((String)script), (Context)this.context);
        }
        catch (PnutsException e) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, e.getMessage(), e.getThrowable());
        }
    }

    public Object call(Object object, String method, Object[] args) throws BSFException {
        try {
            if (object == null) {
                return PnutsFunction.call((String)method, (Object[])args, (Context)this.context);
            }
            return Runtime.callMethod((Context)this.context, object.getClass(), (String)method, (Object[])args, null, (Object)object);
        }
        catch (PnutsException e) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, e.getMessage(), e.getThrowable());
        }
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.pkg.set(bean.name.intern(), bean.bean, this.context);
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.pkg.clear(bean.name.intern(), this.context);
    }
}

