/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.bsf;

import java.util.Vector;
import org.ablaf.common.ISourcePosition;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.jruby.Ruby;
import org.jruby.exceptions.BreakJump;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ReturnJump;
import org.jruby.exceptions.ThrowJump;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyEngine
extends BSFEngineImpl {
    private Ruby ruby;

    public Object apply(String file, int line, int col, Object funcBody, Vector paramNames, Vector args) {
        ISourcePosition oldPosition = this.ruby.getPosition();
        this.ruby.setPosition(file, line);
        StringBuffer sb = new StringBuffer(((String)funcBody).length() + 100);
        sb.append("def __jruby_bsf_anonymous (");
        int paramLength = paramNames.size();
        int i = 0;
        while (i < paramLength) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(paramNames.elementAt(i));
            ++i;
        }
        sb.append(") \n");
        sb.append(funcBody);
        sb.append("\nend\n");
        this.ruby.evalScript(sb.toString(), null);
        IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby((Ruby)this.ruby, (Object[])args.toArray());
        Object result = JavaUtil.convertRubyToJava((Ruby)this.ruby, (IRubyObject)this.ruby.getTopSelf().callMethod("__jruby_bsf_anonymous", rubyArgs));
        this.ruby.setPosition(oldPosition);
        return result;
    }

    public Object eval(String file, int line, int col, Object expr) throws BSFException {
        ISourcePosition oldPosition = this.ruby.getPosition();
        this.ruby.setPosition(file, line);
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Object result = this.ruby.evalScript((String)expr, clazz);
            this.ruby.setPosition(oldPosition);
            return result;
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public void exec(String file, int line, int col, Object expr) throws BSFException {
        try {
            Class<?> clazz;
            ISourcePosition oldPosition = this.ruby.getPosition();
            this.ruby.setPosition(file, line);
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.ruby.evalScript((String)expr, clazz);
            this.ruby.setPosition(oldPosition);
        }
        catch (Exception excptn) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "Exception", (Throwable)excptn);
        }
    }

    public Object call(Object recv, String method, Object[] args) throws BSFException {
        try {
            Class<?> clazz;
            IRubyObject rubyRecv = recv != null ? JavaUtil.convertJavaToRuby((Ruby)this.ruby, (Object)recv) : this.ruby.getTopSelf();
            IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby((Ruby)this.ruby, (Object[])args);
            IRubyObject result = rubyRecv.callMethod(method, rubyArgs);
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return JavaUtil.convertRubyToJava((Ruby)this.ruby, (IRubyObject)result, clazz);
        }
        catch (Exception excptn) {
            JRubyEngine.printException(this.ruby, excptn);
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, excptn.getMessage(), (Throwable)excptn);
        }
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.ruby = Ruby.getDefaultInstance();
        int size = declaredBeans.size();
        int i = 0;
        while (i < size) {
            BSFDeclaredBean bean = (BSFDeclaredBean)declaredBeans.elementAt(i);
            this.ruby.defineVariable((GlobalVariable)new BeanGlobalVariable(this.ruby, bean));
            ++i;
        }
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.ruby.defineVariable((GlobalVariable)new BeanGlobalVariable(this.ruby, bean));
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.ruby.undefineGlobalVar(GlobalVariable.variableName((String)bean.name));
    }

    public void handleException(BSFException bsfExcptn) {
        JRubyEngine.printException(this.ruby, (Exception)bsfExcptn.getTargetException());
    }

    public void terminate() {
        this.ruby.dispose();
    }

    private static void printException(Ruby ruby, Exception exception) {
        if (exception instanceof RaiseException) {
            ruby.printError(((RaiseException)exception).getException());
        } else if (exception instanceof ThrowJump) {
            ruby.printError(((ThrowJump)exception).getNameError());
        } else if (exception instanceof BreakJump) {
            ruby.getErrorStream().println("break without block.");
        } else if (exception instanceof ReturnJump) {
            ruby.getErrorStream().println("return without block.");
        }
    }

    private static class BeanGlobalVariable
    extends GlobalVariable {
        private BSFDeclaredBean bean;

        public BeanGlobalVariable(Ruby ruby, BSFDeclaredBean bean) {
            super(ruby, GlobalVariable.variableName((String)bean.name), null);
            this.bean = bean;
        }

        public IRubyObject get() {
            return JavaUtil.convertJavaToRuby((Ruby)this.ruby, (Object)this.bean.bean);
        }

        public IRubyObject set(IRubyObject value) {
            this.bean.bean = JavaUtil.convertRubyToJava((Ruby)this.ruby, (IRubyObject)value, (Class)this.bean.type);
            return value;
        }

        static /* synthetic */ Ruby access$Lorg$jruby$runtime$GlobalVariable$1(BeanGlobalVariable beanGlobalVariable) {
            return beanGlobalVariable.ruby;
        }

        static /* synthetic */ void access$Sorg$jruby$runtime$GlobalVariable$1(BeanGlobalVariable beanGlobalVariable, Ruby ruby) {
            beanGlobalVariable.ruby = ruby;
        }
    }
}

