/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.jython;

import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class JythonEngine
extends BSFEngineImpl {
    PythonInterpreter interp;

    public Object call(Object object, String method, Object[] args) throws BSFException {
        PyObject[] pyargs = Py.EmptyObjects;
        if (args != null) {
            pyargs = new PyObject[args.length];
            int i = 0;
            while (i < pyargs.length) {
                pyargs[i] = Py.java2py((Object)args[i]);
                ++i;
            }
        }
        if (object != null) {
            PyObject o = Py.java2py((Object)object);
            return this.unwrap(o.invoke(method, pyargs));
        }
        PyObject m = this.interp.get(method);
        if (m == null) {
            m = this.interp.eval(method);
        }
        if (m != null) {
            return this.unwrap(m.__call__(pyargs));
        }
        return null;
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.interp.set(bean.name, bean.bean);
    }

    public Object eval(String source, int lineNo, int columnNo, Object script) throws BSFException {
        try {
            Object result = this.interp.eval(script.toString());
            if (result != null && result instanceof PyJavaInstance) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                result = ((PyJavaInstance)result).__tojava__(clazz);
            }
            return result;
        }
        catch (PyException e) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "exception from Jython: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void exec(String source, int lineNo, int columnNo, Object script) throws BSFException {
        try {
            this.interp.exec(script.toString());
        }
        catch (PyException e) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "exception from Jython: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.interp = new PythonInterpreter();
        this.interp.set("bsf", (Object)new BSFFunctions(mgr, (BSFEngine)this));
        int size = declaredBeans.size();
        int i = 0;
        while (i < size) {
            this.declareBean((BSFDeclaredBean)declaredBeans.elementAt(i));
            ++i;
        }
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.interp.set(bean.name, null);
    }

    public Object unwrap(PyObject result) {
        if (result != null) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Object ret = result.__tojava__(clazz);
            if (ret != Py.NoConversion) {
                return ret;
            }
        }
        return result;
    }
}

