/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.xml;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.rep.BlockingParticipant;
import com.uwyn.rife.rep.Rep;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.xml.ExceptionErrorRedirector;
import com.uwyn.rife.xml.XmlEntityResolver;
import com.uwyn.rife.xml.XmlErrorRedirector;
import com.uwyn.rife.xml.XmlInputSource;
import com.uwyn.rife.xml.exceptions.FatalParsingErrorsException;
import com.uwyn.rife.xml.exceptions.ParserCreationErrorException;
import com.uwyn.rife.xml.exceptions.ParserExecutionErrorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Xml2Data
extends DefaultHandler {
    private boolean mDisableValidation = false;
    private boolean mEnableValidation = false;
    private XmlEntityResolver mEntityResolver = null;
    private XmlErrorRedirector mErrorRedirector = null;
    private String mXmlPath = null;
    private ResourceFinder mResourceFinder = null;

    public void disableValidation(boolean activation) {
        this.mDisableValidation = activation;
        if (activation) {
            this.mEnableValidation = false;
        }
    }

    public void enableValidation(boolean activation) {
        this.mEnableValidation = activation;
        if (activation) {
            this.mDisableValidation = false;
        }
    }

    @Override
    public void warning(SAXParseException e) {
        this.mErrorRedirector.warning(e);
    }

    @Override
    public void error(SAXParseException e) {
        this.mErrorRedirector.error(e);
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.mErrorRedirector.fatalError(e);
    }

    protected String getXmlPath() {
        return this.mXmlPath;
    }

    protected ResourceFinder getResourceFinder() {
        return this.mResourceFinder;
    }

    protected XmlErrorRedirector getErrorRedirector() {
        return this.mErrorRedirector;
    }

    protected XmlErrorRedirector createErrorRedirector() {
        return new ExceptionErrorRedirector(this);
    }

    public synchronized void processXml(String xmlPath) {
        this.processXml(xmlPath, ResourceFinderClasspath.getInstance());
    }

    public synchronized void processXml(String xmlPath, ResourceFinder resourceFinder) {
        if (xmlPath == null) {
            throw new IllegalArgumentException("xmlPath can't be null.");
        }
        if (xmlPath.length() == 0) {
            throw new IllegalArgumentException("xmlPath can't be empty.");
        }
        if (resourceFinder == null) {
            throw new IllegalArgumentException("resourceFinder can't be null.");
        }
        XmlInputSource inputsource = new XmlInputSource(xmlPath, resourceFinder);
        this.mXmlPath = xmlPath;
        this.mResourceFinder = resourceFinder;
        this.mEntityResolver = new XmlEntityResolver(resourceFinder);
        this.mErrorRedirector = this.createErrorRedirector();
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            try {
                reader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            }
            catch (SAXException e2) {
                throw new ParserCreationErrorException(xmlPath, e2);
            }
        }
        reader.setContentHandler(this);
        reader.setEntityResolver(this.mEntityResolver);
        reader.setErrorHandler(this.mErrorRedirector);
        try {
            if (this.mEnableValidation || !this.mDisableValidation && (!Config.hasRepInstance() || !((BlockingParticipant)Rep.getParticipant("ParticipantConfig")).isFinished() || RifeConfig.Xml.getXmlValidation())) {
                reader.setFeature("http://xml.org/sax/features/validation", true);
            } else {
                reader.setFeature("http://xml.org/sax/features/validation", false);
            }
        }
        catch (SAXException e) {
            Logger.getLogger("com.uwyn.rife.xml").warning(new StringBuffer().append(new StringBuffer().append("The parser '").append(reader.getClass().getName()).toString()).append("' doesn't support validation.").toString());
        }
        try {
            reader.parse(inputsource);
        }
        catch (SAXException e) {
            if (e.getException() != null && e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new ParserExecutionErrorException(xmlPath, e);
        }
        catch (IOException e) {
            throw new ParserExecutionErrorException(xmlPath, e);
        }
        if (this.mErrorRedirector.hasWarnings()) {
            Logger.getLogger("com.uwyn.rife.xml").warning(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The following XML warnings occured during the parsing of ").append(xmlPath).toString()).append("'.\n").toString()).append(StringUtils.join(this.formatExceptions(this.mErrorRedirector.getWarnings()), "\n")).toString());
        }
        if (this.mErrorRedirector.hasErrors()) {
            Logger.getLogger("com.uwyn.rife.xml").severe(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The following XML errors occured during the parsing of ").append(xmlPath).toString()).append("'.\n").toString()).append(StringUtils.join(this.formatExceptions(this.mErrorRedirector.getErrors()), "\n")).toString());
        }
        if (this.mErrorRedirector.hasFatalErrors()) {
            throw new FatalParsingErrorsException(xmlPath, this.formatExceptions(this.mErrorRedirector.getFatalErrors()));
        }
    }

    private Collection<String> formatExceptions(Collection<SAXParseException> exceptions) {
        if (exceptions == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (SAXParseException e : exceptions) {
            StringBuffer formatted;
            StringBuffer stringBuffer = formatted = new StringBuffer();
            synchronized (stringBuffer) {
                if (e.getSystemId() != null) {
                    formatted.append(e.getSystemId());
                }
                if (e.getPublicId() != null) {
                    if (formatted.length() > 0) {
                        formatted.append(", ");
                    }
                    formatted.append(e.getPublicId());
                }
                if (e.getLineNumber() >= 0) {
                    if (formatted.length() > 0) {
                        formatted.append(", ");
                    }
                    formatted.append("line ");
                    formatted.append(e.getLineNumber());
                }
                if (e.getColumnNumber() >= 0) {
                    if (formatted.length() > 0) {
                        formatted.append(", ");
                    }
                    formatted.append("col ");
                    formatted.append(e.getColumnNumber());
                }
                if (formatted.length() > 0) {
                    formatted.append(" : ");
                }
                formatted.append(e.getMessage());
                result.add(formatted.toString());
            }
        }
        return result;
    }
}

