/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.tools.UniqueID;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;

public abstract class UniqueIDGenerator {
    private static final String ALGORITHM = "MD5";
    private static Random mRandom = new Random(System.currentTimeMillis());

    public static UniqueID generate() {
        String seed = null;
        try {
            seed = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            seed = "localhost/127.0.0.1";
        }
        return UniqueIDGenerator.generate(seed);
    }

    public static UniqueID generate(String seed) {
        seed = seed + new Date().toString();
        seed = seed + new Long(mRandom.nextLong()).toString();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(seed.getBytes());
        UniqueID uid = new UniqueID(md.digest());
        return uid;
    }
}

