/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.tools.Base64;
import com.uwyn.rife.tools.exceptions.DeserializationErrorException;
import com.uwyn.rife.tools.exceptions.SerializationErrorException;
import com.uwyn.rife.tools.exceptions.SerializationUtilsErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerializationUtils {
    public static <TargetType extends Serializable> TargetType deserializeFromString(String value) throws SerializationUtilsErrorException {
        if (value == null) {
            return null;
        }
        byte[] value_bytes_decoded = Base64.decode(value);
        if (value_bytes_decoded == null) {
            throw new DeserializationErrorException(null);
        }
        ByteArrayInputStream bytes_is = new ByteArrayInputStream(value_bytes_decoded);
        GZIPInputStream gzip_is = null;
        ObjectInputStream object_is = null;
        try {
            gzip_is = new GZIPInputStream(bytes_is);
            object_is = new ObjectInputStream(gzip_is);
            return (TargetType)((Serializable)object_is.readObject());
        }
        catch (IOException e) {
            throw new DeserializationErrorException(e);
        }
        catch (ClassNotFoundException e) {
            throw new DeserializationErrorException(e);
        }
    }

    public static String serializeToString(Serializable value) throws SerializationUtilsErrorException {
        if (value == null) {
            throw new IllegalArgumentException("value can't be null.");
        }
        ByteArrayOutputStream byte_os = new ByteArrayOutputStream();
        GZIPOutputStream gzip_os = null;
        ObjectOutputStream object_os = null;
        try {
            gzip_os = new GZIPOutputStream(byte_os);
            object_os = new ObjectOutputStream(gzip_os);
            object_os.writeObject(value);
            object_os.flush();
            gzip_os.flush();
            gzip_os.finish();
        }
        catch (IOException e) {
            throw new SerializationErrorException(value, (Throwable)e);
        }
        byte[] value_bytes_decoded = byte_os.toByteArray();
        return Base64.encodeToString(value_bytes_decoded, false);
    }
}

