/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.tools.ReloadingBundle;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Localization {
    public static final Pattern URL_PATTERN = Pattern.compile("(?:\\s*(\\w+):((?!//)[^,]+)\\s*)|(?:\\s*([^,]+)\\s*)");
    private static HashMap<String, ResourceBundle> mResourceBundlesOpened = new HashMap();
    private static HashMap<String, Long> mResourceBundleModificationTimes = new HashMap();

    public static String extractLocalizedUrl(String url) {
        if (url == null) {
            return null;
        }
        if (-1 == url.indexOf(":")) {
            return url;
        }
        Matcher matcher = URL_PATTERN.matcher(url);
        String localized_url = null;
        String default_lang = RifeConfig.Tools.getDefaultLanguage();
        String fallback_url = null;
        String group_lang = null;
        String group_url = null;
        String group_fallback = null;
        while (matcher.find()) {
            if (3 != matcher.groupCount()) continue;
            group_lang = matcher.group(1);
            group_url = matcher.group(2);
            group_fallback = matcher.group(3);
            if (group_fallback != null) {
                fallback_url = group_fallback;
                continue;
            }
            if (group_lang == null || group_url == null || default_lang == null || !default_lang.equals(group_lang)) continue;
            localized_url = group_url;
            break;
        }
        if (localized_url == null) {
            localized_url = fallback_url == null ? null : fallback_url;
        }
        return localized_url;
    }

    public static char getChar(String key) {
        return Localization.getChar(null, key, null, null);
    }

    public static char getChar(String key, String language) {
        return Localization.getChar(null, key, language, null);
    }

    public static char getChar(String key, String language, String country) {
        return Localization.getString(null, key, null, language, country).charAt(0);
    }

    public static char getChar(String basename, String key, String language, String country) {
        return Localization.getString(basename, key, null, language, country).charAt(0);
    }

    public static String getString(String key) {
        return Localization.getString(null, key, null, null, null);
    }

    public static String getString(String key, Object[] parameters) {
        return Localization.getString(null, key, parameters, null, null);
    }

    public static String getString(String key, String language) {
        return Localization.getString(null, key, null, language, null);
    }

    public static String getString(String key, Object[] parameters, String language) {
        return Localization.getString(null, key, parameters, language, null);
    }

    public static String getString(String key, String language, String country) {
        return Localization.getString(null, key, null, language, country);
    }

    public static String getString(String key, Object[] parameters, String language, String country) {
        return Localization.getString(null, key, parameters, language, country);
    }

    public static String getString(String basename, String key, String language, String country) {
        return Localization.getString(basename, key, null, language, country);
    }

    public static String getString(String basename, String key, Object[] parameters, String language, String country) {
        ResourceBundle resource_bundle = Localization.getResourceBundle(basename, language, country);
        if (resource_bundle != null) {
            String result = null;
            if (parameters == null) {
                try {
                    result = resource_bundle.getString(key);
                }
                catch (MissingResourceException e) {
                    return key;
                }
            }
            String pattern_string = null;
            try {
                pattern_string = resource_bundle.getString(key);
            }
            catch (MissingResourceException e) {
                return key;
            }
            MessageFormat formatter = null;
            formatter = new MessageFormat(pattern_string);
            Locale locale = resource_bundle.getLocale();
            if (locale != null) {
                formatter.setLocale(locale);
            }
            result = formatter.format(parameters);
            return result;
        }
        return key;
    }

    public static Locale getLocale() {
        return Localization.getLocale(null, null);
    }

    public static Locale getLocale(String language) {
        return Localization.getLocale(language, null);
    }

    public static Locale getLocale(String language, String country) {
        if (language == null) {
            language = RifeConfig.Tools.getDefaultLanguage();
        }
        if (country == null) {
            country = RifeConfig.Tools.getDefaultCountry();
        }
        Locale locale = null;
        if (language != null) {
            locale = country == null ? new Locale(language) : new Locale(language, country);
        }
        return locale;
    }

    public static ResourceBundle getResourceBundle(String basename) {
        return Localization.getResourceBundle(basename, null, null);
    }

    public static ResourceBundle getResourceBundle(String basename, String language) {
        return Localization.getResourceBundle(basename, language, null);
    }

    public static ResourceBundle getResourceBundle(String basename, String language, String country) {
        Locale locale;
        ResourceBundle result;
        if (basename == null) {
            basename = RifeConfig.Tools.getDefaultResourceBundle();
        }
        if ((result = Localization.getResourceBundle(basename, locale = Localization.getLocale(language, country))) == null) {
            result = Localization.getResourceBundle(basename, Locale.ENGLISH);
        }
        return result;
    }

    public static ResourceBundle getResourceBundle(String basename, Locale locale) {
        ResourceBundle result;
        block9: {
            result = null;
            if (locale == null) break block9;
            String resource_bundle_id = basename + "_" + locale.getLanguage();
            if (locale.getCountry().length() > 0) {
                resource_bundle_id = resource_bundle_id + ("_" + locale.getCountry());
            }
            try {
                if (!RifeConfig.Tools.getResourcebundleAutoReload()) {
                    result = ResourceBundle.getBundle(basename, locale);
                    break block9;
                }
                String name = resource_bundle_id + ".properties";
                URL resource = ResourceFinderClasspath.getInstance().getResource(name);
                if (resource == null) break block9;
                long modification_time = -1;
                try {
                    modification_time = ResourceFinderClasspath.getInstance().getModificationTime(resource);
                }
                catch (ResourceFinderErrorException e) {
                    // empty catch block
                }
                Long previous_modification = mResourceBundleModificationTimes.get(resource_bundle_id);
                if (previous_modification != null && modification_time <= previous_modification) {
                    result = mResourceBundlesOpened.get(resource_bundle_id);
                    break block9;
                }
                try {
                    result = new ReloadingBundle(resource);
                    mResourceBundleModificationTimes.put(resource_bundle_id, new Long(modification_time));
                    mResourceBundlesOpened.put(resource_bundle_id, result);
                }
                catch (IOException e) {
                    result = null;
                }
            }
            catch (MissingResourceException e) {
                result = null;
            }
        }
        return result;
    }
}

