/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.tools.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.Cookie;

public abstract class HttpUtils {
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String HEADER_COOKIE = "Cookie";
    private static final String HEADER_CONTENTTYPE = "Content-Type";
    private static final String HEADER_CONTENTLENGTH = "Content-Length";
    private static final String HEADER_SETCOOKIE = "Set-Cookie";
    private static final String CONTENTTYPE_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CHARSET = "; charset=";

    static /* synthetic */ String access$L1000000() {
        return METHOD_GET;
    }

    static /* synthetic */ void access$S1000000(String string) {
        METHOD_GET = string;
    }

    static /* synthetic */ String access$L1000001() {
        return METHOD_POST;
    }

    static /* synthetic */ void access$S1000001(String string) {
        METHOD_POST = string;
    }

    static /* synthetic */ String access$L1000002() {
        return HEADER_COOKIE;
    }

    static /* synthetic */ void access$S1000002(String string) {
        HEADER_COOKIE = string;
    }

    static /* synthetic */ String access$L1000003() {
        return HEADER_CONTENTTYPE;
    }

    static /* synthetic */ void access$S1000003(String string) {
        HEADER_CONTENTTYPE = string;
    }

    static /* synthetic */ String access$L1000004() {
        return HEADER_CONTENTLENGTH;
    }

    static /* synthetic */ void access$S1000004(String string) {
        HEADER_CONTENTLENGTH = string;
    }

    static /* synthetic */ String access$L1000005() {
        return HEADER_SETCOOKIE;
    }

    static /* synthetic */ void access$S1000005(String string) {
        HEADER_SETCOOKIE = string;
    }

    static /* synthetic */ String access$L1000006() {
        return CONTENTTYPE_FORM_URLENCODED;
    }

    static /* synthetic */ void access$S1000006(String string) {
        CONTENTTYPE_FORM_URLENCODED = string;
    }

    public static String getConnectionContent(HttpURLConnection connection) throws IOException {
        int charset_index;
        InputStream input = null;
        try {
            input = connection.getInputStream();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        Map<String, List<String>> header_fields = connection.getHeaderFields();
        List<String> content_encoding = header_fields.get("Content-Encoding");
        if (content_encoding != null && content_encoding.contains("gzip")) {
            input = new GZIPInputStream(input);
        }
        String charset = StringUtils.ENCODING_ISO_8859_1;
        String content_type = connection.getContentType();
        if (content_type != null && (charset_index = content_type.indexOf(CHARSET)) != -1) {
            charset = content_type.substring(charset_index + CHARSET.length());
        }
        BufferedInputStream buffered_input = new BufferedInputStream(input);
        ByteArrayOutputStream byte_output = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            byte_output.write(buffer, 0, count);
        } while (-1 != (count = buffered_input.read(buffer, 0, buffer.length)));
        byte[] bytes = byte_output.toByteArray();
        String content = new String(bytes, charset);
        return content;
    }

    public static Page retrievePage(String absoluteUrl) throws IOException {
        return new Request(absoluteUrl).retrieve();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Page {
        private Request mRequest = null;
        private String mContent = null;
        private int mResponseCode = -1;
        private String mResponseMessage = null;
        private Map<String, List<String>> mHeaders = null;

        Page(Request request, String content, Map<String, List<String>> headers, int responseCode, String responseMessage) {
            this.mRequest = request;
            this.mContent = content;
            this.mHeaders = new HashMap<String, List<String>>(headers);
            this.mResponseCode = responseCode;
            this.mResponseMessage = responseMessage;
        }

        public String getContent() {
            return this.mContent;
        }

        public Map<String, List<String>> getHeaders() {
            return this.mHeaders;
        }

        public List<String> getHeader(String name) {
            return this.mHeaders.get(name);
        }

        public String getHeaderField(String name) {
            List<String> header = this.getHeader(name);
            if (header == null) {
                return null;
            }
            return header.get(0);
        }

        public int getResponseCode() {
            return this.mResponseCode;
        }

        public String getResponseMessage() {
            return this.mResponseMessage;
        }

        public String getContentType() {
            return this.getHeaderField(HttpUtils.HEADER_CONTENTTYPE);
        }

        public boolean checkReceivedCookies(Cookie[] cookies) {
            if (!this.getHeaders().containsKey(HttpUtils.HEADER_SETCOOKIE)) {
                return false;
            }
            HashSet<Cookie> matched_cookies = new HashSet<Cookie>();
            List<String> received_cookies = null;
            received_cookies = this.getHeaders().get(HttpUtils.HEADER_SETCOOKIE);
            Cookie[] cookieArray = cookies;
            int n = 0;
            while (n < cookieArray.length) {
                Cookie cookie = cookieArray[n];
                if (!received_cookies.contains(new StringBuffer().append(new StringBuffer().append(cookie.getName()).append("=").toString()).append(cookie.getValue()).toString())) {
                    return false;
                }
                if (matched_cookies.contains(cookie)) {
                    return false;
                }
                matched_cookies.add(cookie);
                ++n;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request {
        private String mUrl = null;
        private String mMethod = null;
        private Map<String, String> mHeaders = null;
        private StringBuffer mQueryParams = null;
        private StringBuffer mPostParams = null;

        public Request(String absoluteUrl) {
            if (absoluteUrl == null) {
                absoluteUrl = "";
            }
            this.mUrl = absoluteUrl;
        }

        public Request method(String method) {
            this.mMethod = method;
            return this;
        }

        public Request queryParams(String[][] queryParams) {
            if (queryParams != null) {
                if (this.mQueryParams == null) {
                    this.mQueryParams = new StringBuffer();
                }
                this.params(this.mQueryParams, queryParams);
            }
            return this;
        }

        public Request queryParams(Map<String, String[]> queryParams) {
            if (queryParams != null) {
                if (this.mQueryParams == null) {
                    this.mQueryParams = new StringBuffer();
                }
                this.params(this.mQueryParams, queryParams);
            }
            return this;
        }

        public Request queryParam(String key, String value) {
            if (this.mQueryParams == null) {
                this.mQueryParams = new StringBuffer();
            }
            StringBuffer stringBuffer = this.mQueryParams;
            synchronized (stringBuffer) {
                this.param(this.mQueryParams, key, value);
            }
            return this;
        }

        public Request postParams(String[][] postParams) {
            if (postParams != null) {
                if (this.mPostParams == null) {
                    this.mPostParams = new StringBuffer();
                }
                this.params(this.mPostParams, postParams);
            }
            return this;
        }

        public Request postParams(Map<String, String[]> postParams) {
            if (postParams != null) {
                if (this.mPostParams == null) {
                    this.mPostParams = new StringBuffer();
                }
                this.params(this.mPostParams, postParams);
            }
            return this;
        }

        public Request postParam(String key, String value) {
            if (this.mPostParams == null) {
                this.mPostParams = new StringBuffer();
            }
            StringBuffer stringBuffer = this.mPostParams;
            synchronized (stringBuffer) {
                this.param(this.mPostParams, key, value);
            }
            return this;
        }

        private void param(StringBuffer store, String key, String value) {
            if (key != null && value != null) {
                if (store.length() > 0) {
                    store.append("&");
                }
                store.append(StringUtils.encodeUrl(key));
                store.append("=");
                store.append(StringUtils.encodeUrl(value));
            }
        }

        private void params(StringBuffer store, String[][] params) {
            StringBuffer stringBuffer = store;
            synchronized (stringBuffer) {
                String[][] stringArray = params;
                int n = 0;
                while (n < stringArray.length) {
                    String[] param = stringArray[n];
                    int i = 1;
                    while (i <= param.length) {
                        this.param(this.mQueryParams, param[0], param[i]);
                        ++i;
                    }
                    ++n;
                }
            }
        }

        private void params(StringBuffer store, Map<String, String[]> params) {
            StringBuffer stringBuffer = store;
            synchronized (stringBuffer) {
                for (Map.Entry param_entry : (Collection)params.entrySet()) {
                    String[] stringArray = (String[])param_entry.getValue();
                    int n = 0;
                    while (n < stringArray.length) {
                        String value = stringArray[n];
                        this.param(store, (String)param_entry.getKey(), value);
                        ++n;
                    }
                }
            }
        }

        public Request headers(String[][] headers) {
            if (headers != null) {
                if (this.mHeaders == null) {
                    this.mHeaders = new LinkedHashMap<String, String>();
                }
                LinkedHashMap header_list_map = new LinkedHashMap();
                String[][] stringArray = headers;
                int n = 0;
                while (n < stringArray.length) {
                    String[] header = stringArray[n];
                    if (header[0] != null && header[1] != null) {
                        ArrayList<String> header_values = (ArrayList<String>)header_list_map.get(header[0]);
                        if (header_values == null) {
                            header_values = new ArrayList<String>();
                            header_list_map.put(header[0], header_values);
                        }
                        boolean first = true;
                        String[] stringArray2 = header;
                        int n2 = 0;
                        while (n2 < stringArray2.length) {
                            String header_value = stringArray2[n2];
                            if (first) {
                                first = false;
                            } else {
                                header_values.add(header_value);
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
                List headers_values = null;
                for (String headers_name : (Collection)header_list_map.keySet()) {
                    headers_values = (List)header_list_map.get(headers_name);
                    this.mHeaders.put(headers_name, StringUtils.join(headers_values, ","));
                }
            }
            return this;
        }

        public Request headers(Map<String, String> headers) {
            if (headers != null) {
                if (this.mHeaders == null) {
                    this.mHeaders = new LinkedHashMap<String, String>();
                }
                this.mHeaders.putAll(headers);
            }
            return this;
        }

        public Request header(String name, String content) {
            if (name != null && content != null) {
                if (this.mHeaders == null) {
                    this.mHeaders = new LinkedHashMap<String, String>();
                }
                this.mHeaders.put(name, content);
            }
            return this;
        }

        public Request cookie(String name, String value) {
            StringBuffer cookie_header;
            String current_cookie_header = null;
            if (this.mHeaders != null) {
                current_cookie_header = this.mHeaders.get(HttpUtils.HEADER_COOKIE);
            }
            if (current_cookie_header == null) {
                current_cookie_header = "$Version=\"1\"";
            }
            StringBuffer stringBuffer = cookie_header = new StringBuffer(current_cookie_header);
            synchronized (stringBuffer) {
                cookie_header.append("; ");
                cookie_header.append(name);
                cookie_header.append("=\"");
                cookie_header.append(value);
                cookie_header.append("\"");
                this.header(HttpUtils.HEADER_COOKIE, cookie_header.toString());
                return this;
            }
        }

        public Page retrieve() throws IOException {
            Page page = null;
            URL url = null;
            HttpURLConnection connection = null;
            try {
                if (this.mQueryParams != null && this.mQueryParams.length() > 0) {
                    StringBuffer buffer = new StringBuffer(this.mUrl);
                    StringBuffer stringBuffer = buffer;
                    synchronized (stringBuffer) {
                        if (-1 == this.mUrl.indexOf("?")) {
                            buffer.append("?");
                        } else {
                            buffer.append("&");
                        }
                        buffer.append(this.mQueryParams.toString());
                        this.mUrl = buffer.toString();
                    }
                }
                url = new URL(this.mUrl);
                if (this.mMethod == null) {
                    if (this.mPostParams != null) {
                        this.mMethod = HttpUtils.METHOD_POST;
                        if (this.mHeaders == null || !this.mHeaders.containsKey(HttpUtils.HEADER_CONTENTTYPE)) {
                            this.header(HttpUtils.HEADER_CONTENTTYPE, HttpUtils.CONTENTTYPE_FORM_URLENCODED);
                        }
                    } else {
                        this.mMethod = HttpUtils.METHOD_GET;
                    }
                }
                if (this.mPostParams != null) {
                    this.header(HttpUtils.HEADER_CONTENTLENGTH, String.valueOf(this.mPostParams.length()));
                }
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod(this.mMethod);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(true);
                if (this.mHeaders != null) {
                    for (String headers_name : (Collection)this.mHeaders.keySet()) {
                        connection.setRequestProperty(headers_name, this.mHeaders.get(headers_name));
                    }
                }
                if (this.mPostParams != null) {
                    DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                    out.writeBytes(this.mPostParams.toString());
                    out.flush();
                    out.close();
                }
                page = new Page(this, HttpUtils.getConnectionContent(connection), connection.getHeaderFields(), connection.getResponseCode(), connection.getResponseMessage());
                connection.disconnect();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return page;
        }
    }
}

