/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUtils {
    public static ArrayList<String> getFileList(File file) {
        return FileUtils.getFileList(file, null, null, true);
    }

    public static ArrayList<String> getFileList(File file, Pattern included, Pattern excluded) {
        return FileUtils.getFileList(file, new Pattern[]{included}, new Pattern[]{excluded}, true);
    }

    public static ArrayList<String> getFileList(File file, Pattern[] included, Pattern[] excluded) {
        return FileUtils.getFileList(file, included, excluded, true);
    }

    private static ArrayList<String> getFileList(File file, Pattern[] included, Pattern[] excluded, boolean root) {
        if (file == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> filelist = new ArrayList<String>();
        if (file.isDirectory()) {
            String[] list = file.list();
            if (list != null) {
                String[] stringArray = list;
                int n = 0;
                while (n < stringArray.length) {
                    String list_entry = stringArray[n];
                    File next_file = new File(new StringBuffer().append(new StringBuffer().append(file.getAbsolutePath()).append(File.separator).toString()).append(list_entry).toString());
                    ArrayList<String> dir = FileUtils.getFileList(next_file, included, excluded, false);
                    for (String file_name : (Collection)dir) {
                        if (root) {
                            if (!StringUtils.filter(file_name, included, excluded)) {
                                continue;
                            }
                        } else {
                            file_name = new StringBuffer().append(new StringBuffer().append(file.getName()).append(File.separator).toString()).append(file_name).toString();
                        }
                        int filelist_size = filelist.size();
                        int j = 0;
                        while (j < filelist_size) {
                            if (filelist.get(j).compareTo(file_name) > 0) {
                                filelist.add(j, file_name);
                                break;
                            }
                            ++j;
                        }
                        if (filelist.size() != filelist_size) continue;
                        filelist.add(file_name);
                    }
                    ++n;
                }
            }
        } else if (file.isFile()) {
            String file_name = file.getName();
            if (root) {
                if (StringUtils.filter(file_name, included, excluded)) {
                    filelist.add(file_name);
                }
            } else {
                filelist.add(file_name);
            }
        }
        return filelist;
    }

    public static void moveFile(File source, File target) throws FileUtilsErrorException {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("target can't be null.");
        }
        if (!source.exists()) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("The source file '").append(source.getAbsolutePath()).toString()).append("' does not exist.").toString());
        }
        FileUtils.copy(source, target);
        FileUtils.deleteFile(source);
    }

    public static void moveDirectory(File source, File target) throws FileUtilsErrorException {
        String[] filelist;
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("target can't be null.");
        }
        if (!source.exists()) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("The source directory '").append(source.getAbsolutePath()).toString()).append("' does not exist.").toString());
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        String[] stringArray = filelist = source.list();
        int n = 0;
        while (n < stringArray.length) {
            String filelist_element = stringArray[n];
            File current_file = new File(new StringBuffer().append(new StringBuffer().append(source.getAbsolutePath()).append(File.separator).toString()).append(filelist_element).toString());
            File target_file = new File(new StringBuffer().append(new StringBuffer().append(target.getAbsolutePath()).append(File.separator).toString()).append(filelist_element).toString());
            if (current_file.isDirectory()) {
                FileUtils.moveDirectory(current_file, target_file);
            } else {
                FileUtils.moveFile(current_file, target_file);
            }
            ++n;
        }
        FileUtils.deleteFile(source);
    }

    public static void deleteDirectory(File source) throws FileUtilsErrorException {
        String[] filelist;
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (!source.exists()) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("The directory '").append(source.getAbsolutePath()).toString()).append("' does not exist").toString());
        }
        String[] stringArray = filelist = source.list();
        int n = 0;
        while (n < stringArray.length) {
            String filelist_element = stringArray[n];
            File current_file = new File(new StringBuffer().append(new StringBuffer().append(source.getAbsolutePath()).append(File.separator).toString()).append(filelist_element).toString());
            if (current_file.isDirectory()) {
                FileUtils.deleteDirectory(current_file);
            } else {
                FileUtils.deleteFile(current_file);
            }
            ++n;
        }
        FileUtils.deleteFile(source);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws FileUtilsErrorException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream can't be null.");
        }
        try {
            byte[] buffer = new byte[1024];
            int return_value = -1;
            return_value = inputStream.read(buffer);
            while (-1 != return_value) {
                outputStream.write(buffer, 0, return_value);
                return_value = inputStream.read(buffer);
            }
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error during the copying of streams.", e);
        }
    }

    public static void copy(InputStream inputStream, File target) throws FileUtilsErrorException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("target can't be null.");
        }
        try {
            FileOutputStream file_output_stream = new FileOutputStream(target);
            FileUtils.copy(inputStream, (OutputStream)file_output_stream);
            file_output_stream.close();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while copying an input stream to file '").append(target.getAbsolutePath()).toString()).append("'.").toString(), e);
        }
    }

    public static void copy(File source, OutputStream outputStream) throws FileUtilsErrorException {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream can't be null.");
        }
        try {
            FileInputStream file_input_stream = new FileInputStream(source);
            FileUtils.copy((InputStream)file_input_stream, outputStream);
            file_input_stream.close();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while copying file '").append(source.getAbsolutePath()).toString()).append("' to an output stream.").toString(), e);
        }
    }

    public static void copy(File source, File target) throws FileUtilsErrorException {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("target can't be null.");
        }
        try {
            FileInputStream file_input_stream = new FileInputStream(source);
            FileOutputStream file_output_stream = new FileOutputStream(target);
            FileUtils.copy((InputStream)file_input_stream, (OutputStream)file_output_stream);
            file_output_stream.close();
            file_input_stream.close();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Error while copying file '").append(source.getAbsolutePath()).toString()).append("' to file '").toString()).append(target.getAbsolutePath()).toString()).append("'.").toString(), e);
        }
    }

    public static ByteArrayOutputStream readStream(InputStream inputStream) throws FileUtilsErrorException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        try {
            byte[] buffer = new byte[1024];
            int return_value = -1;
            ByteArrayOutputStream output_stream = new ByteArrayOutputStream(buffer.length);
            return_value = inputStream.read(buffer);
            while (-1 != return_value) {
                output_stream.write(buffer, 0, return_value);
                return_value = inputStream.read(buffer);
            }
            output_stream.close();
            inputStream.close();
            return output_stream;
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while reading the complete contents of an input stream.", e);
        }
    }

    public static String readString(InputStream inputStream) throws FileUtilsErrorException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        return FileUtils.readStream(inputStream).toString();
    }

    public static String readString(Reader reader) throws FileUtilsErrorException {
        if (reader == null) {
            throw new IllegalArgumentException("reader can't be null.");
        }
        try {
            char[] buffer = new char[1024];
            StringBuffer result = new StringBuffer();
            int size = reader.read(buffer);
            while (size != -1) {
                result.append(buffer, 0, size);
                size = reader.read(buffer);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while reading the complete contents of an reader.", e);
        }
    }

    public static String readString(InputStream inputStream, String encoding) throws FileUtilsErrorException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        try {
            return FileUtils.readStream(inputStream).toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Encoding '").append(encoding).toString()).append("' is not supported.").toString(), e);
        }
    }

    public static byte[] readBytes(InputStream inputStream) throws FileUtilsErrorException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        return FileUtils.readStream(inputStream).toByteArray();
    }

    public static String readString(URL source) throws FileUtilsErrorException {
        return FileUtils.readString(source, null);
    }

    public static String readString(URL source, String encoding) throws FileUtilsErrorException {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        try {
            InputStream input_stream = source.openStream();
            String content = null;
            content = encoding == null ? FileUtils.readString(input_stream) : FileUtils.readString(input_stream, encoding);
            input_stream.close();
            return content;
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while reading url '").append(source.toString()).toString()).append(".").toString(), e);
        }
    }

    public static byte[] readBytes(URL source) throws FileUtilsErrorException {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        try {
            InputStream input_stream = source.openStream();
            byte[] content = FileUtils.readBytes(input_stream);
            input_stream.close();
            return content;
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while reading url '").append(source.toString()).toString()).append(".").toString(), e);
        }
    }

    public static String readString(File source) throws FileUtilsErrorException {
        return FileUtils.readString(source, null);
    }

    public static String readString(File source, String encoding) throws FileUtilsErrorException {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        try {
            FileInputStream file_input_stream = new FileInputStream(source);
            String content = null;
            content = encoding == null ? FileUtils.readString(file_input_stream) : FileUtils.readString(file_input_stream, encoding);
            file_input_stream.close();
            return content;
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while reading url '").append(source.getAbsolutePath()).toString()).append(".").toString(), e);
        }
    }

    public static byte[] readBytes(File source) throws FileUtilsErrorException {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        try {
            FileInputStream file_input_stream = new FileInputStream(source);
            byte[] content = FileUtils.readBytes(file_input_stream);
            file_input_stream.close();
            return content;
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while reading url '").append(source.getAbsolutePath()).toString()).append(".").toString(), e);
        }
    }

    public static void writeBytes(byte[] content, File destination) throws FileUtilsErrorException {
        if (content == null) {
            throw new IllegalArgumentException("content can't be null.");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination can't be null.");
        }
        try {
            FileOutputStream file_output_stream = new FileOutputStream(destination);
            file_output_stream.write(content);
            file_output_stream.flush();
            file_output_stream.close();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while write a string to '").append(destination.getAbsolutePath()).toString()).append(".").toString(), e);
        }
    }

    public static void writeString(String content, File destination) throws FileUtilsErrorException {
        if (content == null) {
            throw new IllegalArgumentException("content can't be null.");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination can't be null.");
        }
        try {
            FileWriter file_writer = null;
            file_writer = new FileWriter(destination);
            file_writer.write(content, 0, content.length());
            file_writer.flush();
            file_writer.close();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while write a string to '").append(destination.getAbsolutePath()).toString()).append(".").toString(), e);
        }
    }

    public static String convertPathToSystemSeperator(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path can't be null.");
        }
        ArrayList<String> path_parts = StringUtils.split(path, "/");
        return StringUtils.join(path_parts, File.separator);
    }

    public static void deleteFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file can't be null.");
        }
        file.delete();
    }

    public static String getUniqueFilename() {
        Date current_date = new Date();
        String unique_filename = new StringBuffer().append(new StringBuffer().append(current_date.getTime()).append("-").toString()).append((long)((double)1000000 * Math.random())).toString();
        return unique_filename;
    }

    public static void unzipFile(File source, File destination) throws FileUtilsErrorException {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination can't be null.");
        }
        ZipFile zip_file = null;
        Enumeration<? extends ZipEntry> entries = null;
        try {
            zip_file = new ZipFile(source);
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while creating the zipfile '").append(source.getAbsolutePath()).toString()).append("'.").toString(), e);
        }
        entries = zip_file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = null;
            InputStream input_stream = null;
            String output_filename = null;
            File output_file = null;
            StringBuffer output_file_directoryname = null;
            File output_file_directory = null;
            FileOutputStream file_output_stream = null;
            byte[] buffer = new byte[1024];
            int return_value = -1;
            entry = entries.nextElement();
            try {
                input_stream = zip_file.getInputStream(entry);
            }
            catch (IOException e) {
                throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while obtaining the inputstream for entry '").append(entry.getName()).toString()).append("'.").toString(), e);
            }
            output_filename = new StringBuffer().append(new StringBuffer().append(destination.getAbsolutePath()).append(File.separator).toString()).append(entry.getName().replace('/', File.separatorChar)).toString();
            output_file = new File(output_filename);
            output_file_directoryname = new StringBuffer(output_file.getPath());
            output_file_directoryname.setLength(output_file_directoryname.length() - output_file.getName().length() - File.separator.length());
            output_file_directory = new File(output_file_directoryname.toString());
            if (!output_file_directory.exists()) {
                if (!output_file_directory.mkdirs()) {
                    throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Couldn't create directory '").append(output_file_directory.getAbsolutePath()).toString()).append("' and its parents.").toString());
                }
            } else if (!output_file_directory.isDirectory()) {
                throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Destination '").append(output_file_directory.getAbsolutePath()).toString()).append("' exists and is not a directory.").toString());
            }
            try {
                file_output_stream = new FileOutputStream(output_filename);
            }
            catch (IOException e) {
                throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while creating the output stream for file '").append(output_filename).toString()).append("'.").toString(), e);
            }
            try {
                return_value = input_stream.read(buffer);
                while (-1 != return_value) {
                    file_output_stream.write(buffer, 0, return_value);
                    return_value = input_stream.read(buffer);
                }
            }
            catch (IOException e) {
                throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while uncompressing entry '").append(output_filename).toString()).append("'.").toString(), e);
            }
            try {
                file_output_stream.close();
            }
            catch (IOException e) {
                throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while closing the output stream for file '").append(output_filename).toString()).append("'.").toString(), e);
            }
            try {
                input_stream.close();
            }
            catch (IOException e) {
                throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while closing the input stream for entry '").append(entry.getName()).toString()).append("'.").toString(), e);
            }
        }
        try {
            zip_file.close();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Error while closing the zipfile '").append(source.getAbsolutePath()).toString()).append("'.").toString(), e);
        }
    }

    public static String getBaseName(File file) {
        return FileUtils.getBaseName(file.getName());
    }

    public static String getBaseName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can't be null.");
        }
        String basename = null;
        int index = fileName.lastIndexOf(46);
        if (index > 0 && index < fileName.length() - 1) {
            basename = fileName.substring(0, index);
        }
        return basename;
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can't be null.");
        }
        String ext = null;
        int index = fileName.lastIndexOf(46);
        if (index > 0 && index < fileName.length() - 1) {
            ext = fileName.substring(index + 1).toLowerCase();
        }
        return ext;
    }
}

