/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class ExecUtils {
    public static Process exec(String command) throws IOException, InterruptedException {
        return ExecUtils.exec(command, null);
    }

    public static Process exec(String command, String[] envp) throws IOException, InterruptedException {
        Process process = null;
        process = envp == null ? Runtime.getRuntime().exec(command) : Runtime.getRuntime().exec(command, envp);
        process.waitFor();
        return process;
    }

    public static Process exec(String[] commands, String[] envp) throws IOException, InterruptedException {
        Process process = null;
        process = envp == null ? Runtime.getRuntime().exec(commands) : Runtime.getRuntime().exec(commands, envp);
        process.waitFor();
        return process;
    }

    public static Process exec(String command, long interval, long timeout) throws IOException, InterruptedException {
        return ExecUtils.exec(command, null, interval, timeout);
    }

    public static Process exec(String[] commands, long interval, long timeout) throws IOException, InterruptedException {
        return ExecUtils.exec(commands, null, interval, timeout);
    }

    public static synchronized Process exec(String command, String[] envp, long interval, long timeout) throws IOException, InterruptedException {
        Process process = null;
        process = envp == null ? Runtime.getRuntime().exec(command) : Runtime.getRuntime().exec(command, envp);
        return ExecUtils.processTimeout(process, interval, timeout);
    }

    public static synchronized Process exec(String[] commands, String[] envp, long interval, long timeout) throws IOException, InterruptedException {
        Process process = null;
        process = envp == null ? Runtime.getRuntime().exec(commands) : Runtime.getRuntime().exec(commands, envp);
        return ExecUtils.processTimeout(process, interval, timeout);
    }

    private static synchronized Process processTimeout(Process process, long interval, long timeout) throws InterruptedException {
        long time_waiting = 0;
        boolean process_finished = false;
        while (time_waiting < timeout && !process_finished) {
            process_finished = true;
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                e.fillInStackTrace();
                throw e;
            }
            try {
                process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                process_finished = false;
            }
            time_waiting += interval;
        }
        if (process_finished) {
            return process;
        }
        process.destroy();
        return null;
    }

    public static void outputSystemProperties() {
        Map.Entry property = null;
        Iterator iterator = ((Collection)System.getProperties().entrySet()).iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            property = (Map.Entry)element;
            System.out.println(property.getKey() + "=" + property.getValue());
        }
    }
}

