/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.template.Template;
import com.uwyn.rife.tools.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class ExceptionUtils {
    private static final int DEFAULT_STACKTRACELIMIT = 15;
    private static final int DEFAULT_BUFFERLIMIT = 300000;

    public static String getExceptionStackTrace(Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception can't be null;");
        }
        String stack_trace = null;
        StringWriter string_writer = new StringWriter();
        PrintWriter print_writer = new PrintWriter(string_writer);
        exception.printStackTrace(print_writer);
        stack_trace = string_writer.getBuffer().toString();
        print_writer.close();
        try {
            string_writer.close();
        }
        catch (Throwable e2) {}
        return stack_trace;
    }

    public static String formatExceptionStackTrace(Throwable exception, Template template2) {
        return ExceptionUtils.formatExceptionStackTrace(exception, template2, 15, 300000);
    }

    public static String formatExceptionStackTrace(Throwable exception, Template template2, int stacktraceLimit) {
        return ExceptionUtils.formatExceptionStackTrace(exception, template2, stacktraceLimit, 300000);
    }

    public static String formatExceptionStackTrace(Throwable exception, Template template2, int stacktraceLimit, int bufferLimit) {
        StringBuffer exceptions;
        if (exception == null) {
            throw new IllegalArgumentException("exception can't be null.");
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (stacktraceLimit <= 0) {
            throw new IllegalArgumentException("stacktraceLimit has to be bigger than 0.");
        }
        if (bufferLimit <= 0) {
            throw new IllegalArgumentException("bufferLimit has to be bigger than 0.");
        }
        String exception_name = null;
        String message = null;
        String class_name = null;
        String method_name = null;
        String file_name = null;
        StringBuffer stringBuffer = exceptions = new StringBuffer();
        synchronized (stringBuffer) {
            while (exception != null) {
                exception_name = exception.getClass().getName();
                message = exception.getMessage();
                if (exception_name == null) {
                    exception_name = "<unknown exception name>";
                }
                if (message == null) {
                    message = "<no message>";
                }
                template2.setValue("exception_class_name", StringUtils.encodeHtml(exception_name));
                template2.setValue("exception_message", StringUtils.encodeHtml(message));
                if (template2.hasValueId("exception_stack_trace")) {
                    StackTraceElement[] stack_trace = exception.getStackTrace();
                    StringBuffer stack_trace_out = new StringBuffer();
                    StringBuffer stack_trace_details = null;
                    StringBuffer stringBuffer2 = stack_trace_out;
                    synchronized (stringBuffer2) {
                        int i = 0;
                        while (i < stack_trace.length) {
                            class_name = stack_trace[i].getClassName();
                            method_name = stack_trace[i].getMethodName();
                            if (class_name == null) {
                                class_name = "<unknown class>";
                            }
                            if (class_name == null) {
                                method_name = "<unknown method>";
                            }
                            template2.setValue("class_name", StringUtils.encodeHtml(class_name));
                            template2.setValue("method_name", StringUtils.encodeHtml(method_name));
                            StringBuffer stringBuffer3 = stack_trace_details = new StringBuffer();
                            synchronized (stringBuffer3) {
                                file_name = stack_trace[i].getFileName();
                                if (file_name == null) {
                                    file_name = "<unknown>";
                                }
                                template2.setValue("file_name", StringUtils.encodeHtml(file_name));
                                stack_trace_details.append(template2.getBlock("file_name"));
                                if (stack_trace[i].getLineNumber() > 0) {
                                    template2.setValue("line_number", stack_trace[i].getLineNumber());
                                    stack_trace_details.append(template2.getBlock("line_number"));
                                }
                                template2.setValue("details", stack_trace_details.toString());
                            }
                            stack_trace_out.append(template2.getBlock("stack_trace_line"));
                            if (i > stacktraceLimit) {
                                template2.setValue("count", stack_trace.length - 1 - i);
                                stack_trace_out.append(template2.getBlock("more_stack_trace"));
                                break;
                            }
                            if (exceptions.length() + stack_trace_out.length() > bufferLimit) {
                                template2.setValue("count", stack_trace.length - 1 - i);
                                stack_trace_out.append(template2.getBlock("more_stack_trace"));
                                exception = null;
                                break;
                            }
                            ++i;
                        }
                        template2.setValue("exception_stack_trace", stack_trace_out.toString());
                    }
                }
                exceptions.append(template2.getBlock("exception"));
                if (template2.hasBlock("more_exceptions") && exceptions.length() > bufferLimit) {
                    exceptions.append(template2.getBlock("more_exceptions"));
                    exception = null;
                    break;
                }
                if (exception == null) continue;
                exception = exception.getCause();
            }
            return exceptions.toString();
        }
    }
}

