/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.tools.ClasspathComponentsSingleton;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClasspathUtils {
    public static ArrayList<String> getResourcesInDirectory(String directory) {
        return ClasspathUtils.getResourcesInDirectory(directory, true);
    }

    public static ArrayList<String> getResourcesInDirectory(String directory, boolean excludeJavaHomePaths) {
        ArrayList<String> resources = new ArrayList<String>();
        ArrayList<URL> classpath_components = ClasspathComponentsSingleton.INSTANCE.getClasspathComponents();
        String classpath_component_filename = null;
        File classpath_component_file = null;
        String java_home = System.getProperty("java.home");
        for (URL classpath_component : (Collection)classpath_components) {
            try {
                classpath_component_filename = URLDecoder.decode(classpath_component.getFile(), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            if (classpath_component_filename == null || !excludeJavaHomePaths || classpath_component_filename.startsWith(java_home) || !(classpath_component_file = new File(classpath_component_filename)).canRead()) continue;
            ArrayList<String> filelist = null;
            if (classpath_component_file.isFile() && classpath_component_filename.endsWith(".jar")) {
                try {
                    JarFile jar_file = new JarFile(classpath_component_file);
                    Enumeration<JarEntry> jar_entries = jar_file.entries();
                    JarEntry jar_entry = null;
                    filelist = new ArrayList(jar_file.size());
                    while (jar_entries.hasMoreElements()) {
                        jar_entry = jar_entries.nextElement();
                        if (jar_entry.isDirectory()) continue;
                        filelist.add(jar_entry.getName());
                    }
                }
                catch (IOException e) {}
            } else if (classpath_component_file.isDirectory()) {
                filelist = FileUtils.getFileList(classpath_component_file);
            }
            if (filelist == null) continue;
            for (String filelist_entry : (Collection)filelist) {
                if (!(filelist_entry = filelist_entry.replace(File.separatorChar, '/')).startsWith(directory) || resources.contains(filelist_entry)) continue;
                resources.add(filelist_entry);
            }
        }
        return resources;
    }

    private static ArrayList<String> getClassPathCandidates(ClassLoader classloader) {
        Class<?> resin_classloader = null;
        try {
            resin_classloader = classloader.loadClass("com.caucho.util.DynamicClassLoader");
        }
        catch (ClassNotFoundException e) {
            resin_classloader = null;
        }
        ArrayList<String> classpath_candidates = new ArrayList<String>();
        URL[] classloader_urls = null;
        do {
            if (classloader instanceof URLClassLoader) {
                URL[] uRLArray = classloader_urls = ((URLClassLoader)classloader).getURLs();
                int n = 0;
                while (n < uRLArray.length) {
                    URL classloader_url = uRLArray[n];
                    if (classloader_url.getProtocol().equals("file")) {
                        try {
                            classpath_candidates.add(URLDecoder.decode(classloader_url.getPath(), "ISO-8859-1"));
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
                continue;
            }
            if (resin_classloader == null || !resin_classloader.isAssignableFrom(classloader.getClass())) continue;
            try {
                Method method = resin_classloader.getDeclaredMethod("getClassPath", null);
                String resin_classpath = (String)method.invoke((Object)classloader, (Object[])null);
                classpath_candidates.addAll(StringUtils.split(resin_classpath, File.pathSeparator));
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        } while ((classloader = classloader.getParent()) != null);
        return classpath_candidates;
    }

    public static String getClassPath(Class reference) {
        Class<?> clazz;
        ArrayList<String> classpath = new ArrayList<String>();
        ArrayList<String> classpath_candidates = new ArrayList<String>();
        classpath_candidates.addAll(ClasspathUtils.getClassPathCandidates(Thread.currentThread().getContextClassLoader()));
        classpath_candidates.addAll(ClasspathUtils.getClassPathCandidates(reference.getClassLoader()));
        try {
            clazz = Class.forName("com.uwyn.rife.tools.ClasspathUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        String current_class_file = new StringBuffer().append(clazz.getName().replace('.', '/')).append(".class").toString();
        URL rife_classpath_resource = reference.getClassLoader().getResource(current_class_file);
        if (rife_classpath_resource != null) {
            String rife_classpath_entry = rife_classpath_resource.toExternalForm();
            if (rife_classpath_entry.startsWith("jar:file:")) {
                rife_classpath_entry = rife_classpath_entry.substring("jar:file:".length());
                rife_classpath_entry = rife_classpath_entry.substring(0, rife_classpath_entry.indexOf("!"));
            } else if (rife_classpath_entry.startsWith("file:")) {
                rife_classpath_entry = rife_classpath_entry.substring("file:".length());
                rife_classpath_entry = rife_classpath_entry.substring(0, rife_classpath_entry.indexOf(current_class_file));
            } else {
                rife_classpath_entry = null;
            }
            if (rife_classpath_entry != null) {
                classpath_candidates.add(rife_classpath_entry);
            }
        }
        classpath_candidates.addAll(StringUtils.split(RifeConfig.Global.getApplicationClassPath(), File.pathSeparator));
        classpath_candidates.addAll(StringUtils.split(System.getProperty("sun.boot.class.path"), File.pathSeparator));
        classpath_candidates.addAll(StringUtils.split(System.getProperty("java.class.path"), File.pathSeparator));
        File path_file = null;
        for (String path : (Collection)classpath_candidates) {
            if (classpath.contains(path) || !(path_file = new File(path)).exists() || !path_file.canRead() || !path_file.isDirectory() && (!path_file.isFile() || !path.endsWith(".jar"))) continue;
            classpath.add(path);
        }
        return StringUtils.join(classpath, File.pathSeparator);
    }
}

