/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.ClasspathUtilsErrorException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClasspathComponents {
    private ArrayList<URL> sClasspathComponents = null;

    ClasspathComponents() {
        this.init();
    }

    ArrayList<URL> getClasspathComponents() {
        return this.sClasspathComponents;
    }

    private void init() {
        String classpath = System.getProperty("java.class.path");
        ArrayList<String> paths = StringUtils.split(classpath, File.pathSeparator);
        ArrayList<URL> urls = new ArrayList<URL>();
        File path_file = null;
        URL path_url = null;
        try {
            for (String path : (Collection)paths) {
                path_file = new File(path);
                path_url = path_file.toURL();
                urls.add(path_url);
            }
        }
        catch (MalformedURLException e) {
            throw new ClasspathUtilsErrorException(new StringBuffer().append(new StringBuffer().append("Unable to parse the class path '").append(path_file).toString()).append("'.").toString(), e);
        }
        this.sClasspathComponents = urls;
    }
}

