/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanUtils {
    private static BeanInfo getBeanInfo(Class beanClass) throws BeanUtilsException {
        try {
            return Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            throw new BeanUtilsException("Couldn't introspect the bean.", beanClass, e);
        }
    }

    private static String validateProperty(PropertyDescriptor property, ArrayList<String> includedProperties, ArrayList<String> excludedProperties, String prefix) {
        String name = null;
        if (property.getReadMethod() != null && property.getWriteMethod() != null && !(name = property.getName()).equals("class")) {
            if (prefix != null) {
                name = new StringBuffer().append(prefix).append(name).toString();
            }
            if (!(includedProperties != null && !includedProperties.contains(name) || excludedProperties != null && excludedProperties.contains(name))) {
                return name;
            }
        }
        return null;
    }

    public static SortedSet<String> getPropertyNames(Class beanClass, String[] includedProperties, String[] excludedProperties, String prefix) throws BeanUtilsException {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        TreeSet<String> property_names = new TreeSet<String>();
        BeanInfo bean_info = BeanUtils.getBeanInfo(beanClass);
        PropertyDescriptor[] bean_properties = bean_info.getPropertyDescriptors();
        if (bean_properties.length > 0) {
            String property_name = null;
            ArrayList<String> included_properties = null;
            ArrayList<String> excluded_properties = null;
            if (includedProperties != null && includedProperties.length > 0) {
                included_properties = new ArrayList<String>(Arrays.asList(includedProperties));
            }
            if (excludedProperties != null && excludedProperties.length > 0) {
                excluded_properties = new ArrayList<String>(Arrays.asList(excludedProperties));
            }
            PropertyDescriptor[] propertyDescriptorArray = bean_properties;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor bean_property = propertyDescriptorArray[n];
                property_name = BeanUtils.validateProperty(bean_property, included_properties, excluded_properties, prefix);
                if (property_name != null) {
                    property_names.add(property_name);
                }
                ++n;
            }
        }
        return property_names;
    }

    public static int countProperties(Class beanClass, String[] includedProperties, String[] excludedProperties, String prefix) throws BeanUtilsException {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        int counter = 0;
        BeanInfo bean_info = BeanUtils.getBeanInfo(beanClass);
        PropertyDescriptor[] bean_properties = bean_info.getPropertyDescriptors();
        if (bean_properties.length > 0) {
            String property_name = null;
            ArrayList<String> included_properties = null;
            ArrayList<String> excluded_properties = null;
            if (includedProperties != null && includedProperties.length > 0) {
                included_properties = new ArrayList<String>(Arrays.asList(includedProperties));
            }
            if (excludedProperties != null && excludedProperties.length > 0) {
                excluded_properties = new ArrayList<String>(Arrays.asList(excludedProperties));
            }
            PropertyDescriptor[] propertyDescriptorArray = bean_properties;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor bean_property = propertyDescriptorArray[n];
                property_name = BeanUtils.validateProperty(bean_property, included_properties, excluded_properties, prefix);
                if (property_name != null) {
                    ++counter;
                }
                ++n;
            }
        }
        return counter;
    }

    public static Object getPropertyValue(Object bean, String name) throws BeanUtilsException {
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        if (bean instanceof Class) {
            throw new IllegalArgumentException("bean should be a bean instance, not a bean class.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        Class<?> bean_class = bean.getClass();
        BeanInfo bean_info = BeanUtils.getBeanInfo(bean_class);
        PropertyDescriptor[] bean_properties = bean_info.getPropertyDescriptors();
        if (bean_properties.length > 0) {
            String property_name = null;
            Method property_read_method = null;
            PropertyDescriptor[] propertyDescriptorArray = bean_properties;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor bean_property = propertyDescriptorArray[n];
                property_name = bean_property.getName();
                if (property_name.equals(name)) {
                    property_read_method = bean_property.getReadMethod();
                    try {
                        return property_read_method.invoke(bean, (Object[])null);
                    }
                    catch (IllegalAccessException e) {
                        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append("No permission to invoke the '").append(property_read_method.getName()).toString()).append("' method on the bean.").toString(), bean_class, e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append("Invalid arguments while invoking the '").append(property_read_method.getName()).toString()).append("' method on the bean.").toString(), bean_class, e);
                    }
                    catch (InvocationTargetException e) {
                        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append("The '").append(property_read_method.getName()).toString()).append("' method of the bean has thrown an exception.").toString(), bean_class, e.getTargetException());
                    }
                }
                ++n;
            }
        }
        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The bean '").append(bean_class).toString()).append("' doesn't contain property '").toString()).append(name).toString()).append("'").toString(), bean_class);
    }

    public static void setPropertyValue(Object bean, String name, Object value) throws BeanUtilsException {
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        if (bean instanceof Class) {
            throw new IllegalArgumentException("bean should be a bean instance, not a bean class.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        Class<?> bean_class = bean.getClass();
        BeanInfo bean_info = BeanUtils.getBeanInfo(bean_class);
        PropertyDescriptor[] bean_properties = bean_info.getPropertyDescriptors();
        if (bean_properties.length > 0) {
            String property_name = null;
            Method property_write_method = null;
            PropertyDescriptor[] propertyDescriptorArray = bean_properties;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor bean_property = propertyDescriptorArray[n];
                property_name = bean_property.getName();
                if (property_name.equals(name)) {
                    property_write_method = bean_property.getWriteMethod();
                    try {
                        property_write_method.invoke(bean, value);
                        return;
                    }
                    catch (IllegalAccessException e) {
                        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append("No permission to invoke the '").append(property_write_method.getName()).toString()).append("' method on the bean.").toString(), bean_class, e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append("Invalid arguments while invoking the '").append(property_write_method.getName()).toString()).append("' method on the bean.").toString(), bean_class, e);
                    }
                    catch (InvocationTargetException e) {
                        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append("The '").append(property_write_method.getName()).toString()).append("' method of the bean has thrown an exception.").toString(), bean_class, e.getTargetException());
                    }
                }
                ++n;
            }
        }
        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The bean '").append(bean_class).toString()).append("' doesn't contain property '").toString()).append(name).toString()).append("'").toString(), bean_class);
    }

    public static Class getPropertyType(Class beanClass, String name) throws BeanUtilsException {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        BeanInfo bean_info = BeanUtils.getBeanInfo(beanClass);
        PropertyDescriptor[] bean_properties = bean_info.getPropertyDescriptors();
        if (bean_properties.length > 0) {
            String property_name = null;
            Method property_read_method = null;
            PropertyDescriptor[] propertyDescriptorArray = bean_properties;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor bean_property = propertyDescriptorArray[n];
                property_name = bean_property.getName();
                if (property_name.equals(name)) {
                    property_read_method = bean_property.getReadMethod();
                    return property_read_method.getReturnType();
                }
                ++n;
            }
        }
        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The bean '").append(beanClass).toString()).append("' doesn't contain property '").toString()).append(name).toString()).append("'").toString(), beanClass);
    }

    public static SortedMap<String, Object> getPropertyValues(Object bean, String[] includedProperties, String[] excludedProperties, String prefix) throws BeanUtilsException {
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        if (bean instanceof Class) {
            throw new IllegalArgumentException("bean should be a bean instance, not a bean class.");
        }
        TreeMap<String, Object> property_values = new TreeMap<String, Object>();
        Class<?> bean_class = bean.getClass();
        BeanInfo bean_info = BeanUtils.getBeanInfo(bean_class);
        PropertyDescriptor[] bean_properties = bean_info.getPropertyDescriptors();
        if (bean_properties.length > 0) {
            String property_name = null;
            Method property_read_method = null;
            Object property_value = null;
            ArrayList<String> included_properties = null;
            ArrayList<String> excluded_properties = null;
            if (includedProperties != null && includedProperties.length > 0) {
                included_properties = new ArrayList<String>(Arrays.asList(includedProperties));
            }
            if (excludedProperties != null && excludedProperties.length > 0) {
                excluded_properties = new ArrayList<String>(Arrays.asList(excludedProperties));
            }
            PropertyDescriptor[] propertyDescriptorArray = bean_properties;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor bean_property = propertyDescriptorArray[n];
                property_name = BeanUtils.validateProperty(bean_property, included_properties, excluded_properties, prefix);
                if (property_name != null) {
                    property_read_method = bean_property.getReadMethod();
                    try {
                        property_value = property_read_method.invoke(bean, (Object[])null);
                    }
                    catch (IllegalAccessException e) {
                        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append("No permission to invoke the '").append(property_read_method.getName()).toString()).append("' method on the bean.").toString(), bean_class, e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append("Invalid arguments while invoking the '").append(property_read_method.getName()).toString()).append("' method on the bean.").toString(), bean_class, e);
                    }
                    catch (InvocationTargetException e) {
                        throw new BeanUtilsException(new StringBuffer().append(new StringBuffer().append("The '").append(property_read_method.getName()).toString()).append("' method of the bean has thrown an exception.").toString(), bean_class, e.getTargetException());
                    }
                    property_values.put(property_name, property_value);
                }
                ++n;
            }
        }
        return property_values;
    }

    public static SortedMap<String, Class> getPropertyTypes(Class beanClass, String[] includedProperties, String[] excludedProperties, String prefix) throws BeanUtilsException {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        TreeMap<String, Class> property_types = new TreeMap<String, Class>();
        BeanInfo bean_info = BeanUtils.getBeanInfo(beanClass);
        PropertyDescriptor[] bean_properties = bean_info.getPropertyDescriptors();
        if (bean_properties.length > 0) {
            String property_name = null;
            Method property_read_method = null;
            Class<?> property_class = null;
            ArrayList<String> included_properties = null;
            ArrayList<String> excluded_properties = null;
            if (includedProperties != null && includedProperties.length > 0) {
                included_properties = new ArrayList<String>(Arrays.asList(includedProperties));
            }
            if (excludedProperties != null && excludedProperties.length > 0) {
                excluded_properties = new ArrayList<String>(Arrays.asList(excludedProperties));
            }
            PropertyDescriptor[] propertyDescriptorArray = bean_properties;
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor bean_property = propertyDescriptorArray[n];
                property_name = BeanUtils.validateProperty(bean_property, included_properties, excluded_properties, prefix);
                if (property_name != null) {
                    property_read_method = bean_property.getReadMethod();
                    property_class = property_read_method.getReturnType();
                    property_types.put(property_name, property_class);
                }
                ++n;
            }
        }
        return property_types;
    }
}

