/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.datastructures.EnumClass;
import java.util.logging.Logger;

public class ArrayUtils {
    public static ArrayType getArrayType(Object object) {
        String classname = object.getClass().getName();
        if ('[' == classname.charAt(0)) {
            int position = 1;
            while (position < classname.length()) {
                if ('[' != classname.charAt(position)) {
                    switch (classname.charAt(position)) {
                        case 'L': {
                            return ArrayType.OBJECT_ARRAY;
                        }
                        case 'Z': {
                            return ArrayType.BOOLEAN_ARRAY;
                        }
                        case 'B': {
                            return ArrayType.BYTE_ARRAY;
                        }
                        case 'C': {
                            return ArrayType.CHAR_ARRAY;
                        }
                        case 'S': {
                            return ArrayType.SHORT_ARRAY;
                        }
                        case 'I': {
                            return ArrayType.INT_ARRAY;
                        }
                        case 'J': {
                            return ArrayType.LONG_ARRAY;
                        }
                        case 'F': {
                            return ArrayType.FLOAT_ARRAY;
                        }
                        case 'D': {
                            return ArrayType.DOUBLE_ARRAY;
                        }
                    }
                    Logger.getLogger("com.uwyn.rife.tools").severe("Unknown primitive array class: " + classname);
                    return null;
                }
                ++position;
            }
            return null;
        }
        return ArrayType.NO_ARRAY;
    }

    public static String[] createStringArray(Object source) {
        if (source == null) {
            return null;
        }
        String[] result = null;
        ArrayType type = ArrayUtils.getArrayType(source);
        if (type == ArrayType.NO_ARRAY) {
            result = new String[]{String.valueOf(source)};
        } else if (type == ArrayType.BYTE_ARRAY) {
            result = null;
        } else if (type == ArrayType.OBJECT_ARRAY) {
            result = ArrayUtils.createStringArray((Object[])source);
        } else if (type == ArrayType.BOOLEAN_ARRAY) {
            result = ArrayUtils.createStringArray((boolean[])source);
        } else if (type == ArrayType.CHAR_ARRAY) {
            result = ArrayUtils.createStringArray((char[])source);
        } else if (type == ArrayType.SHORT_ARRAY) {
            result = ArrayUtils.createStringArray((short[])source);
        } else if (type == ArrayType.INT_ARRAY) {
            result = ArrayUtils.createStringArray((int[])source);
        } else if (type == ArrayType.LONG_ARRAY) {
            result = ArrayUtils.createStringArray((long[])source);
        } else if (type == ArrayType.FLOAT_ARRAY) {
            result = ArrayUtils.createStringArray((float[])source);
        } else if (type == ArrayType.DOUBLE_ARRAY) {
            result = ArrayUtils.createStringArray((double[])source);
        }
        return result;
    }

    public static String[] createStringArray(Object[] array) {
        if (array == null) {
            return null;
        }
        String[] new_array = new String[array.length];
        Object converted_string = null;
        int i = 0;
        while (i < array.length) {
            new_array[i] = String.valueOf(array[i]);
            ++i;
        }
        return new_array;
    }

    public static String[] createStringArray(boolean[] array) {
        if (array == null) {
            return null;
        }
        String[] new_array = new String[array.length];
        Object converted_string = null;
        int i = 0;
        while (i < array.length) {
            new_array[i] = String.valueOf(array[i]);
            ++i;
        }
        return new_array;
    }

    public static String[] createStringArray(byte[] array) {
        if (array == null) {
            return null;
        }
        String[] new_array = new String[array.length];
        Object converted_string = null;
        int i = 0;
        while (i < array.length) {
            new_array[i] = String.valueOf(array[i]);
            ++i;
        }
        return new_array;
    }

    public static String[] createStringArray(char[] array) {
        if (array == null) {
            return null;
        }
        String[] new_array = new String[array.length];
        int i = 0;
        while (i < array.length) {
            new_array[i] = String.valueOf(array[i]);
            ++i;
        }
        return new_array;
    }

    public static String[] createStringArray(short[] array) {
        if (array == null) {
            return null;
        }
        String[] new_array = new String[array.length];
        int i = 0;
        while (i < array.length) {
            new_array[i] = String.valueOf(array[i]);
            ++i;
        }
        return new_array;
    }

    public static String[] createStringArray(int[] array) {
        if (array == null) {
            return null;
        }
        String[] new_array = new String[array.length];
        int i = 0;
        while (i < array.length) {
            new_array[i] = String.valueOf(array[i]);
            ++i;
        }
        return new_array;
    }

    public static String[] createStringArray(long[] array) {
        if (array == null) {
            return null;
        }
        String[] new_array = new String[array.length];
        int i = 0;
        while (i < array.length) {
            new_array[i] = String.valueOf(array[i]);
            ++i;
        }
        return new_array;
    }

    public static String[] createStringArray(float[] array) {
        if (array == null) {
            return null;
        }
        String[] new_array = new String[array.length];
        int i = 0;
        while (i < array.length) {
            new_array[i] = String.valueOf(array[i]);
            ++i;
        }
        return new_array;
    }

    public static String[] createStringArray(double[] array) {
        if (array == null) {
            return null;
        }
        String[] new_array = new String[array.length];
        int i = 0;
        while (i < array.length) {
            new_array[i] = String.valueOf(array[i]);
            ++i;
        }
        return new_array;
    }

    public static boolean[] createBooleanArray(Object[] array) {
        if (array == null) {
            return null;
        }
        boolean[] new_array = new boolean[]{};
        boolean converted_boolean = false;
        Object[] objectArray = array;
        int n = 0;
        while (n < objectArray.length) {
            Object element = objectArray[n];
            if (element != null) {
                converted_boolean = Boolean.valueOf(String.valueOf(element));
                new_array = ArrayUtils.join(new_array, converted_boolean);
            }
            ++n;
        }
        return new_array;
    }

    public static byte[] createByteArray(Object[] array) {
        if (array == null) {
            return null;
        }
        byte[] new_array = new byte[]{};
        byte converted_byte = (byte)-1;
        Object[] objectArray = array;
        int n = 0;
        while (n < objectArray.length) {
            Object element = objectArray[n];
            try {
                if (element != null) {
                    converted_byte = Byte.parseByte(String.valueOf(element));
                    new_array = ArrayUtils.join(new_array, converted_byte);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++n;
        }
        return new_array;
    }

    public static char[] createCharArray(Object[] array) {
        if (array == null) {
            return null;
        }
        char[] new_array = new char[]{};
        char converted_char = '\u0000';
        Object[] objectArray = array;
        int n = 0;
        while (n < objectArray.length) {
            String string_value;
            Object element = objectArray[n];
            if (element != null && 0 != (string_value = String.valueOf(element)).length() && string_value.length() <= 1) {
                converted_char = string_value.charAt(0);
                new_array = ArrayUtils.join(new_array, converted_char);
            }
            ++n;
        }
        return new_array;
    }

    public static short[] createShortArray(Object[] array) {
        if (array == null) {
            return null;
        }
        short[] new_array = new short[]{};
        short converted_short = (short)-1;
        Object[] objectArray = array;
        int n = 0;
        while (n < objectArray.length) {
            Object element = objectArray[n];
            try {
                if (element != null) {
                    converted_short = Short.parseShort(String.valueOf(element));
                    new_array = ArrayUtils.join(new_array, converted_short);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++n;
        }
        return new_array;
    }

    public static int[] createIntArray(Object[] array) {
        if (array == null) {
            return null;
        }
        int[] new_array = new int[]{};
        int converted_int = -1;
        Object[] objectArray = array;
        int n = 0;
        while (n < objectArray.length) {
            Object element = objectArray[n];
            try {
                if (element != null) {
                    converted_int = Integer.parseInt(String.valueOf(element));
                    new_array = ArrayUtils.join(new_array, converted_int);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++n;
        }
        return new_array;
    }

    public static long[] createLongArray(Object[] array) {
        if (array == null) {
            return null;
        }
        long[] new_array = new long[]{};
        long converted_long = -1;
        Object[] objectArray = array;
        int n = 0;
        while (n < objectArray.length) {
            Object element = objectArray[n];
            try {
                if (element != null) {
                    converted_long = Long.parseLong(String.valueOf(element));
                    new_array = ArrayUtils.join(new_array, converted_long);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++n;
        }
        return new_array;
    }

    public static float[] createFloatArray(Object[] array) {
        if (array == null) {
            return null;
        }
        float[] new_array = new float[]{};
        float converted_float = -1;
        Object[] objectArray = array;
        int n = 0;
        while (n < objectArray.length) {
            Object element = objectArray[n];
            try {
                if (element != null) {
                    converted_float = Float.parseFloat(String.valueOf(element));
                    new_array = ArrayUtils.join(new_array, converted_float);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++n;
        }
        return new_array;
    }

    public static double[] createDoubleArray(Object[] array) {
        if (array == null) {
            return null;
        }
        double[] new_array = new double[]{};
        double converted_double = -1;
        Object[] objectArray = array;
        int n = 0;
        while (n < objectArray.length) {
            Object element = objectArray[n];
            try {
                if (element != null) {
                    converted_double = Double.parseDouble(String.valueOf(element));
                    new_array = ArrayUtils.join(new_array, converted_double);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++n;
        }
        return new_array;
    }

    public static String[] join(String[] first, String[] second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        String[] new_array = new String[first.length + second.length];
        System.arraycopy(first, 0, new_array, 0, first.length);
        System.arraycopy(second, 0, new_array, first.length, second.length);
        return new_array;
    }

    public static String[] join(String[] first, String second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return new String[]{second};
        }
        if (second == null) {
            return first;
        }
        String[] new_array = new String[first.length + 1];
        System.arraycopy(first, 0, new_array, 0, first.length);
        new_array[first.length] = second;
        return new_array;
    }

    public static byte[] join(byte[] first, byte[] second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        byte[] new_array = new byte[first.length + second.length];
        System.arraycopy(first, 0, new_array, 0, first.length);
        System.arraycopy(second, 0, new_array, first.length, second.length);
        return new_array;
    }

    public static byte[] join(byte[] first, byte second) {
        if (first == null) {
            return new byte[]{second};
        }
        byte[] new_array = new byte[first.length + 1];
        System.arraycopy(first, 0, new_array, 0, first.length);
        new_array[first.length] = second;
        return new_array;
    }

    public static char[] join(char[] first, char[] second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        char[] new_array = new char[first.length + second.length];
        System.arraycopy(first, 0, new_array, 0, first.length);
        System.arraycopy(second, 0, new_array, first.length, second.length);
        return new_array;
    }

    public static char[] join(char[] first, char second) {
        if (first == null) {
            return new char[]{second};
        }
        char[] new_array = new char[first.length + 1];
        System.arraycopy(first, 0, new_array, 0, first.length);
        new_array[first.length] = second;
        return new_array;
    }

    public static short[] join(short[] first, short[] second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        short[] new_array = new short[first.length + second.length];
        System.arraycopy(first, 0, new_array, 0, first.length);
        System.arraycopy(second, 0, new_array, first.length, second.length);
        return new_array;
    }

    public static short[] join(short[] first, short second) {
        if (first == null) {
            return new short[]{second};
        }
        short[] new_array = new short[first.length + 1];
        System.arraycopy(first, 0, new_array, 0, first.length);
        new_array[first.length] = second;
        return new_array;
    }

    public static int[] join(int[] first, int[] second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int[] new_array = new int[first.length + second.length];
        System.arraycopy(first, 0, new_array, 0, first.length);
        System.arraycopy(second, 0, new_array, first.length, second.length);
        return new_array;
    }

    public static int[] join(int[] first, int second) {
        if (first == null) {
            return new int[]{second};
        }
        int[] new_array = new int[first.length + 1];
        System.arraycopy(first, 0, new_array, 0, first.length);
        new_array[first.length] = second;
        return new_array;
    }

    public static long[] join(long[] first, long[] second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        long[] new_array = new long[first.length + second.length];
        System.arraycopy(first, 0, new_array, 0, first.length);
        System.arraycopy(second, 0, new_array, first.length, second.length);
        return new_array;
    }

    public static long[] join(long[] first, long second) {
        if (first == null) {
            return new long[]{second};
        }
        long[] new_array = new long[first.length + 1];
        System.arraycopy(first, 0, new_array, 0, first.length);
        new_array[first.length] = second;
        return new_array;
    }

    public static float[] join(float[] first, float[] second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        float[] new_array = new float[first.length + second.length];
        System.arraycopy(first, 0, new_array, 0, first.length);
        System.arraycopy(second, 0, new_array, first.length, second.length);
        return new_array;
    }

    public static float[] join(float[] first, float second) {
        if (first == null) {
            return new float[]{second};
        }
        float[] new_array = new float[first.length + 1];
        System.arraycopy(first, 0, new_array, 0, first.length);
        new_array[first.length] = second;
        return new_array;
    }

    public static double[] join(double[] first, double[] second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        double[] new_array = new double[first.length + second.length];
        System.arraycopy(first, 0, new_array, 0, first.length);
        System.arraycopy(second, 0, new_array, first.length, second.length);
        return new_array;
    }

    public static double[] join(double[] first, double second) {
        if (first == null) {
            return new double[]{second};
        }
        double[] new_array = new double[first.length + 1];
        System.arraycopy(first, 0, new_array, 0, first.length);
        new_array[first.length] = second;
        return new_array;
    }

    public static boolean[] join(boolean[] first, boolean[] second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        boolean[] new_array = new boolean[first.length + second.length];
        System.arraycopy(first, 0, new_array, 0, first.length);
        System.arraycopy(second, 0, new_array, first.length, second.length);
        return new_array;
    }

    public static boolean[] join(boolean[] first, boolean second) {
        if (first == null) {
            return new boolean[]{second};
        }
        boolean[] new_array = new boolean[first.length + 1];
        System.arraycopy(first, 0, new_array, 0, first.length);
        new_array[first.length] = second;
        return new_array;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayType
    extends EnumClass<String> {
        public static final ArrayType NO_ARRAY = new ArrayType("NO_ARRAY");
        public static final ArrayType OBJECT_ARRAY = new ArrayType("OBJECT_ARRAY");
        public static final ArrayType BYTE_ARRAY = new ArrayType("BYTE_ARRAY");
        public static final ArrayType BOOLEAN_ARRAY = new ArrayType("BOOLEAN_ARRAY");
        public static final ArrayType CHAR_ARRAY = new ArrayType("CHAR_ARRAY");
        public static final ArrayType SHORT_ARRAY = new ArrayType("SHORT_ARRAY");
        public static final ArrayType INT_ARRAY = new ArrayType("INT_ARRAY");
        public static final ArrayType LONG_ARRAY = new ArrayType("LONG_ARRAY");
        public static final ArrayType FLOAT_ARRAY = new ArrayType("FLOAT_ARRAY");
        public static final ArrayType DOUBLE_ARRAY = new ArrayType("DOUBLE_ARRAY");

        ArrayType(String identifier) {
            super(identifier);
        }

        public static ArrayType getArrayType(String name) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.tools.ArrayUtils$ArrayType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return (ArrayType)EnumClass.getMember(clazz, name);
        }
    }
}

