/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.exceptions.SourceBeanRequiredException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Logger;

public abstract class AbstractPropertyChangeSupport
implements Cloneable {
    private PropertyChangeSupport mPropertyChangeSupport = null;

    protected AbstractPropertyChangeSupport() {
    }

    protected void setSource(Object sourceBean) {
        this.mPropertyChangeSupport = new PropertyChangeSupport(sourceBean);
    }

    private final void ensureSourceBean() {
        if (this.mPropertyChangeSupport == null) {
            throw new SourceBeanRequiredException(this.getClass());
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.ensureSourceBean();
        this.mPropertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.ensureSourceBean();
        this.mPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.ensureSourceBean();
        this.mPropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.ensureSourceBean();
        this.mPropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.ensureSourceBean();
        this.mPropertyChangeSupport.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.ensureSourceBean();
        this.mPropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        this.ensureSourceBean();
        return this.mPropertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        this.ensureSourceBean();
        return this.mPropertyChangeSupport.getPropertyChangeListeners();
    }

    public boolean hasListeners(String propertyName) {
        this.ensureSourceBean();
        return this.mPropertyChangeSupport.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.ensureSourceBean();
        this.mPropertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.ensureSourceBean();
        this.mPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public AbstractPropertyChangeSupport clone() {
        AbstractPropertyChangeSupport new_object = null;
        try {
            new_object = (AbstractPropertyChangeSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.tools").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        new_object.mPropertyChangeSupport = new PropertyChangeSupport(new_object);
        return new_object;
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }
}

