/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.template;

import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.template.TemplateTransformer;
import com.uwyn.rife.template.exceptions.FilterNotFoundException;
import com.uwyn.rife.template.exceptions.TransformerErrorException;
import com.uwyn.rife.xml.XmlInputSource;
import com.uwyn.rife.xml.XmlUriResolver;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateTransformerXslt
implements TemplateTransformer {
    private ResourceFinder mResourceFinder = ResourceFinderClasspath.getInstance();
    private ArrayList<SAXSource> mFilters = null;
    private Properties mProperties = null;
    private String mState = null;
    public static final String OUTPUT_METHOD = "method";
    public static final String OUTPUT_INDENT = "indent";
    public static final String OUTPUT_MEDIA_TYPE = "media-type";
    public static final String OUTPUT_VERSION = "version";
    public static final String OUTPUT_INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    public static final String OUTPUT_USE_URL_ESCAPING = "{http://xml.apache.org/xalan}use-url-escaping";
    public static final String OUTPUT_OMIT_META_TAG = "{http://xml.apache.org/xalan}omit-meta-tag";

    @Override
    public String getState() {
        if (this.mState == null) {
            StringBuffer state = new StringBuffer();
            if (this.mFilters != null) {
                for (SAXSource filter : (Collection)this.mFilters) {
                    state.append(filter.getInputSource().toString());
                    state.append(";");
                }
            }
            if (this.mProperties != null) {
                state.append("\n");
                Enumeration<?> property_names = this.mProperties.propertyNames();
                String property_name = null;
                while (property_names.hasMoreElements()) {
                    property_name = (String)property_names.nextElement();
                    state.append(property_name);
                    state.append("=");
                    state.append(this.mProperties.getProperty(property_name));
                    state.append(";");
                }
            }
            this.mState = state.toString();
        }
        return this.mState;
    }

    public void addFilter(String xmlPath) {
        URL resource;
        if (xmlPath == null) {
            throw new IllegalArgumentException("xmlPath can't be null");
        }
        if (0 == xmlPath.length()) {
            throw new IllegalArgumentException("xmlPath can't be empty");
        }
        if (this.mFilters == null) {
            this.mFilters = new ArrayList();
        }
        if ((resource = this.mResourceFinder.getResource(xmlPath)) == null) {
            throw new FilterNotFoundException(xmlPath);
        }
        this.mState = null;
        this.mFilters.add(new SAXSource(new XmlInputSource(resource)));
    }

    public void clearFilters() {
        this.mState = null;
        this.mFilters = null;
    }

    @Override
    public ResourceFinder getResourceFinder() {
        return this.mResourceFinder;
    }

    @Override
    public void setResourceFinder(ResourceFinder resourceFinder) {
        this.mResourceFinder = resourceFinder;
    }

    public void setOutputProperty(String name, String value) {
        if (this.mProperties == null) {
            this.mProperties = new Properties();
        }
        this.mState = null;
        this.mProperties.setProperty(name, value);
    }

    public void setOutputProperties(Properties properties) {
        this.mState = null;
        this.mProperties = properties;
    }

    @Override
    public Collection<URL> transform(String templateName, URL resource, OutputStream result, String encoding) {
        ArrayList<URL> stylesheets = new ArrayList<URL>();
        XmlInputSource input = new XmlInputSource(resource);
        if (encoding != null) {
            input.setEncoding(encoding);
        }
        try {
            XMLReader reader;
            SAXParserFactory parser_factory = SAXParserFactory.newInstance();
            parser_factory.setNamespaceAware(true);
            SAXParser parser = parser_factory.newSAXParser();
            XMLReader parent = reader = parser.getXMLReader();
            XMLFilter filter = null;
            SAXTransformerFactory transformer_factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            transformer_factory.setURIResolver(new XmlUriResolver(this.mResourceFinder));
            Source source = transformer_factory.getAssociatedStylesheet(new SAXSource(input), null, null, null);
            if (source != null) {
                filter = transformer_factory.newXMLFilter(source);
                filter.setParent(parent);
                parent = filter;
                stylesheets.add(new URL(source.getSystemId()));
                reader = filter;
            }
            if (this.mFilters != null && this.mFilters.size() > 0) {
                for (SAXSource sAXSource : this.mFilters) {
                    filter = transformer_factory.newXMLFilter(sAXSource);
                    filter.setParent(parent);
                    parent = filter;
                    stylesheets.add(new URL(sAXSource.getSystemId()));
                }
                reader = filter;
            }
            Transformer transformer = transformer_factory.newTransformer();
            if (this.mProperties != null) {
                Properties merged_properties = transformer.getOutputProperties();
                merged_properties.putAll((Map<?, ?>)this.mProperties);
                transformer.setOutputProperties(merged_properties);
            }
            StreamResult stream_result = new StreamResult(result);
            SAXSource transform_source = new SAXSource(reader, input);
            transformer.transform(transform_source, stream_result);
        }
        catch (MalformedURLException e) {
            throw new TransformerErrorException(resource, (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerErrorException(resource, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new TransformerErrorException(resource, (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new TransformerErrorException(resource, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new TransformerErrorException(resource, (Throwable)e);
        }
        catch (SAXException e) {
            throw new TransformerErrorException(resource, (Throwable)e);
        }
        return stylesheets;
    }

    @Override
    public String getEncoding() {
        if (this.mProperties != null && this.mProperties.containsKey("encoding")) {
            return this.mProperties.getProperty("encoding");
        }
        return null;
    }
}

