/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.template;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.datastructures.EnumClass;
import com.uwyn.rife.engine.EngineTemplateInitializer;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.template.AbstractTemplate;
import com.uwyn.rife.template.BeanHandler;
import com.uwyn.rife.template.BeanHandlerPlain;
import com.uwyn.rife.template.BeanHandlerXhtml;
import com.uwyn.rife.template.BeanHandlerXml;
import com.uwyn.rife.template.EncoderHtml;
import com.uwyn.rife.template.EncoderHtmlSingleton;
import com.uwyn.rife.template.EncoderXml;
import com.uwyn.rife.template.EncoderXmlSingleton;
import com.uwyn.rife.template.Parser;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateClassLoader;
import com.uwyn.rife.template.TemplateEncoder;
import com.uwyn.rife.template.TemplateInitializer;
import com.uwyn.rife.template.TemplateTransformer;
import com.uwyn.rife.template.exceptions.TemplateException;
import com.uwyn.rife.template.exceptions.TemplateNotFoundException;
import com.uwyn.rife.tools.Localization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFactory
extends EnumClass<String> {
    private static final Parser.Config CONFIG_COMPACT_STANDARD;
    private static final Parser.Config CONFIG_INVISIBLE_XML;
    private static final Parser.Config CONFIG_INVISIBLE_TXT;
    private static final Parser.Config CONFIG_INVISIBLE_SQL;
    private static final Parser.Config CONFIG_INVISIBLE_JAVA;
    public static final Parser.Config[] CONFIGS_XML;
    public static final Parser.Config[] CONFIGS_TXT;
    public static final Parser.Config[] CONFIGS_SQL;
    public static final Parser.Config[] CONFIGS_JAVA;
    public static final String PREFIX_CONFIG = "CONFIG:";
    public static final String PREFIX_L10N = "L10N:";
    public static final String PREFIX_LANG = "LANG:";
    public static final String PREFIX_OGNL_CONFIG = "OGNL:CONFIG:";
    public static final String PREFIX_OGNL = "OGNL:";
    public static final String PREFIX_GROOVY_CONFIG = "GROOVY:CONFIG:";
    public static final String PREFIX_GROOVY = "GROOVY:";
    public static final String PREFIX_JANINO_CONFIG = "JANINO:CONFIG:";
    public static final String PREFIX_JANINO = "JANINO:";
    public static final String TAG_CONFIG = "^CONFIG:\\s*(.*)\\s*$";
    public static final String TAG_L10N = "^L10N:\\s*(.*)\\s*$";
    public static final String TAG_LANG = "(?s)^(LANG:.*):\\s*(\\w*)\\s*$";
    public static final String TAG_OGNL_CONFIG = "(?s)^(OGNL:CONFIG:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$";
    public static final String TAG_OGNL = "(?s)^(OGNL:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$";
    public static final String TAG_GROOVY_CONFIG = "(?s)^(GROOVY:CONFIG:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$";
    public static final String TAG_GROOVY = "(?s)^(GROOVY:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$";
    public static final String TAG_JANINO_CONFIG = "(?s)^(JANINO:CONFIG:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$";
    public static final String TAG_JANINO = "(?s)^(JANINO:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$";
    public static final TemplateFactory HTML;
    public static final TemplateFactory XHTML;
    public static final TemplateFactory XML;
    public static final TemplateFactory TXT;
    public static final TemplateFactory SQL;
    public static final TemplateFactory JAVA;
    public static final TemplateFactory ENGINEHTML;
    public static final TemplateFactory ENGINEXHTML;
    public static final TemplateFactory ENGINEXML;
    public static final TemplateFactory ENGINETXT;
    private TemplateClassLoader mLastClassloader;
    private Parser mParser;
    private BeanHandler mBeanHandler;
    private TemplateEncoder mEncoder;
    private ResourceFinder mResourceFinder;
    private TemplateInitializer mInitializer;
    private String mIdentifierUppercase;
    private static /* synthetic */ boolean $assertionsDisabled;

    public TemplateFactory(ResourceFinder resourceFinder, String identifier, Parser.Config[] configs, String extension, String[] blockFilters, String[] valueFilters, BeanHandler beanHandler, TemplateEncoder encoder, TemplateInitializer initializer) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.TemplateFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        super(clazz, identifier);
        this.mLastClassloader = null;
        this.mParser = null;
        this.mBeanHandler = null;
        this.mEncoder = null;
        this.mResourceFinder = null;
        this.mInitializer = null;
        this.mIdentifierUppercase = null;
        this.mIdentifierUppercase = identifier.toUpperCase();
        this.mParser = new Parser(this, identifier, configs, extension, blockFilters, valueFilters);
        this.mResourceFinder = resourceFinder;
        this.mBeanHandler = beanHandler;
        this.mEncoder = encoder;
        this.mInitializer = initializer;
        if (!$assertionsDisabled && this.mParser == null) {
            throw new AssertionError();
        }
    }

    public String getIdentifierUppercase() {
        return this.mIdentifierUppercase;
    }

    public TemplateFactory(String identifier, TemplateFactory base) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.TemplateFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        super(clazz, identifier);
        this.mLastClassloader = null;
        this.mParser = null;
        this.mBeanHandler = null;
        this.mEncoder = null;
        this.mResourceFinder = null;
        this.mInitializer = null;
        this.mIdentifierUppercase = null;
        this.mParser = new Parser(this, identifier, base.getParser().getConfigs(), base.getParser().getExtension(), base.getParser().getBlockFilters(), base.getParser().getValueFilters());
        this.mResourceFinder = base.getResourceFinder();
        this.mBeanHandler = base.getBeanHandler();
        this.mEncoder = base.getEncoder();
        this.mInitializer = base.getInitializer();
        if (!$assertionsDisabled && this.mParser == null) {
            throw new AssertionError();
        }
    }

    public static Collection<String> getFactoryTypes() {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.TemplateFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return EnumClass.getIdentifiers(clazz);
    }

    public static TemplateFactory getFactory(String identifier) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.TemplateFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (TemplateFactory)EnumClass.getMember(clazz, identifier);
    }

    public Template get(String name) {
        return this.get(name, null, null);
    }

    public Template get(String name, TemplateTransformer transformer) {
        return this.get(name, null, transformer);
    }

    public Template get(String name, String encoding) {
        return this.get(name, encoding, null);
    }

    public Template get(String name, String encoding, TemplateTransformer transformer) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        try {
            AbstractTemplate template2 = (AbstractTemplate)this.getClassLoader().loadClass(new StringBuffer().append(this.mParser.getPackage()).append(this.mParser.escapeClassname(name)).toString(), false, encoding, transformer).newInstance();
            template2.setBeanHandler(this.mBeanHandler);
            template2.setEncoder(this.mEncoder);
            template2.setInitializer(this.mInitializer);
            if (!$assertionsDisabled && template2 == null) {
                throw new AssertionError();
            }
            Collection<String> default_resourcebundles = RifeConfig.Template.getDefaultResourcebundles(this);
            if (default_resourcebundles != null) {
                ArrayList<ResourceBundle> default_bundles = new ArrayList<ResourceBundle>();
                for (String bundle_name : default_resourcebundles) {
                    ResourceBundle bundle = Localization.getResourceBundle(bundle_name);
                    if (bundle != null) {
                        default_bundles.add(bundle);
                        continue;
                    }
                    try {
                        Class<?> clazz;
                        Class<?> bundle_class = Class.forName(bundle_name);
                        try {
                            clazz = Class.forName("java.util.ResourceBundle");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (!clazz.isAssignableFrom(bundle_class) || (bundle = (ResourceBundle)bundle_class.newInstance()) == null) continue;
                        default_bundles.add(bundle);
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (InstantiationException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
                template2.setDefaultResourceBundles(default_bundles);
            }
            template2.initialize();
            return template2;
        }
        catch (ClassNotFoundException e) {
            throw new TemplateNotFoundException(name, e);
        }
        catch (IllegalAccessException e) {
            throw new TemplateException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("TemplateFactory.get() : '").append(name).toString()).append("' IllegalAccessException : ").toString()).append(e.getMessage()).toString(), e);
        }
        catch (InstantiationException e) {
            throw new TemplateException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("TemplateFactory.get() : '").append(name).toString()).append("' InstantiationException : ").toString()).append(e.getMessage()).toString(), e);
        }
    }

    public TemplateFactory setResourceFinder(ResourceFinder resourceFinder) {
        if (resourceFinder == null) {
            throw new IllegalArgumentException("resourceFinder can't be null.");
        }
        this.mResourceFinder = resourceFinder;
        return this;
    }

    public ResourceFinder getResourceFinder() {
        if (!$assertionsDisabled && this.mResourceFinder == null) {
            throw new AssertionError();
        }
        return this.mResourceFinder;
    }

    Parser getParser() {
        if (!$assertionsDisabled && this.mParser == null) {
            throw new AssertionError();
        }
        return this.mParser;
    }

    public TemplateFactory setBeanHandler(BeanHandler beanHandler) {
        this.mBeanHandler = beanHandler;
        return this;
    }

    public BeanHandler getBeanHandler() {
        return this.mBeanHandler;
    }

    public TemplateFactory setEncoder(TemplateEncoder encoder) {
        this.mEncoder = encoder;
        return this;
    }

    public TemplateEncoder getEncoder() {
        return this.mEncoder;
    }

    public TemplateFactory setInitializer(TemplateInitializer initializer) {
        this.mInitializer = initializer;
        return this;
    }

    public TemplateInitializer getInitializer() {
        return this.mInitializer;
    }

    private TemplateClassLoader getClassLoader() {
        if (this.mLastClassloader == null) {
            this.setClassLoader(new TemplateClassLoader(this, this.getClass().getClassLoader()));
        }
        if (!$assertionsDisabled && this.mLastClassloader == null) {
            throw new AssertionError();
        }
        return this.mLastClassloader;
    }

    synchronized void setClassLoader(TemplateClassLoader classloader) {
        this.mLastClassloader = classloader;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.TemplateFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        CONFIG_COMPACT_STANDARD = new Parser.Config("[!", "]", "/", "'");
        CONFIG_INVISIBLE_XML = new Parser.Config("<!--", "-->", "/", "'");
        CONFIG_INVISIBLE_TXT = new Parser.Config("<!", ">", "/", "'");
        CONFIG_INVISIBLE_SQL = new Parser.Config("/*", "*/", "-", "'");
        CONFIG_INVISIBLE_JAVA = new Parser.Config("/*", "*/", "-", "'");
        CONFIGS_XML = new Parser.Config[]{CONFIG_INVISIBLE_XML, CONFIG_COMPACT_STANDARD};
        CONFIGS_TXT = new Parser.Config[]{CONFIG_INVISIBLE_TXT, CONFIG_COMPACT_STANDARD};
        CONFIGS_SQL = new Parser.Config[]{CONFIG_INVISIBLE_SQL, CONFIG_COMPACT_STANDARD};
        CONFIGS_JAVA = new Parser.Config[]{CONFIG_INVISIBLE_JAVA, CONFIG_COMPACT_STANDARD};
        HTML = new TemplateFactory(ResourceFinderClasspath.getInstance(), "html", CONFIGS_XML, ".html", new String[]{"(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORMESSAGE:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", TAG_LANG, TAG_OGNL_CONFIG, TAG_OGNL, TAG_GROOVY_CONFIG, TAG_GROOVY, TAG_JANINO_CONFIG, TAG_JANINO}, new String[]{"(?:^MARK:(?:(\\w+):)?|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", TAG_CONFIG, TAG_L10N}, BeanHandlerXhtml.getInstance(), EncoderHtmlSingleton.INSTANCE, null);
        XHTML = new TemplateFactory(ResourceFinderClasspath.getInstance(), "xhtml", CONFIGS_XML, ".xhtml", new String[]{"(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORMESSAGE:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", TAG_LANG, TAG_OGNL_CONFIG, TAG_OGNL, TAG_GROOVY_CONFIG, TAG_GROOVY, TAG_JANINO_CONFIG, TAG_JANINO}, new String[]{"(?:^MARK:(?:(\\w+):)?|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", TAG_CONFIG, TAG_L10N}, BeanHandlerXhtml.getInstance(), EncoderHtmlSingleton.INSTANCE, null);
        XML = new TemplateFactory(ResourceFinderClasspath.getInstance(), "xml", CONFIGS_XML, ".xml", new String[]{"(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORMESSAGE:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", TAG_LANG, TAG_OGNL_CONFIG, TAG_OGNL, TAG_GROOVY_CONFIG, TAG_GROOVY, TAG_JANINO_CONFIG, TAG_JANINO}, new String[]{"(?:^MARK:(?:(\\w+):)?|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", TAG_CONFIG, TAG_L10N}, BeanHandlerXml.getInstance(), EncoderXmlSingleton.INSTANCE, null);
        TXT = new TemplateFactory(ResourceFinderClasspath.getInstance(), "txt", CONFIGS_TXT, ".txt", new String[]{TAG_LANG, TAG_OGNL_CONFIG, TAG_OGNL, TAG_GROOVY_CONFIG, TAG_GROOVY, TAG_JANINO_CONFIG, TAG_JANINO}, new String[]{TAG_CONFIG, TAG_L10N}, BeanHandlerPlain.getInstance(), null, null);
        SQL = new TemplateFactory(ResourceFinderClasspath.getInstance(), "sql", CONFIGS_SQL, ".sql", new String[]{TAG_LANG, TAG_OGNL_CONFIG, TAG_OGNL, TAG_GROOVY_CONFIG, TAG_GROOVY, TAG_JANINO_CONFIG, TAG_JANINO}, new String[]{TAG_CONFIG, TAG_L10N}, BeanHandlerPlain.getInstance(), EncoderHtmlSingleton.INSTANCE, null);
        JAVA = new TemplateFactory(ResourceFinderClasspath.getInstance(), "java", CONFIGS_JAVA, ".java", new String[]{TAG_LANG, TAG_OGNL_CONFIG, TAG_OGNL, TAG_GROOVY_CONFIG, TAG_GROOVY, TAG_JANINO_CONFIG, TAG_JANINO}, new String[]{TAG_CONFIG, TAG_L10N}, BeanHandlerPlain.getInstance(), null, null);
        ENGINEHTML = new TemplateFactory(ResourceFinderClasspath.getInstance(), "enginehtml", CONFIGS_XML, ".html", new String[]{"(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORMESSAGE:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", TAG_LANG, TAG_OGNL_CONFIG, "(?s)^(OGNL:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_OGNL, TAG_GROOVY_CONFIG, "(?s)^(GROOVY:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_GROOVY, TAG_JANINO_CONFIG, "(?s)^(JANINO:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_JANINO}, new String[]{"(?:^MARK:(?:(\\w+):)?|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "^ELEMENT:(.*?)(:[^:]*)?$", TAG_CONFIG, TAG_L10N}, BeanHandlerXhtml.getInstance(), EncoderHtml.getInstance(), new EngineTemplateInitializer());
        ENGINEXHTML = new TemplateFactory(ResourceFinderClasspath.getInstance(), "enginexhtml", CONFIGS_XML, ".xhtml", new String[]{"(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORMESSAGE:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", TAG_LANG, TAG_OGNL_CONFIG, "(?s)^(OGNL:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_OGNL, TAG_GROOVY_CONFIG, "(?s)^(GROOVY:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_GROOVY, TAG_JANINO_CONFIG, "(?s)^(JANINO:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_JANINO}, new String[]{"(?:^MARK:(?:(\\w+):)?|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "^ELEMENT:(.*?)(:[^:]*)?$", TAG_CONFIG, TAG_L10N}, BeanHandlerXhtml.getInstance(), EncoderHtml.getInstance(), new EngineTemplateInitializer());
        ENGINEXML = new TemplateFactory(ResourceFinderClasspath.getInstance(), "enginexml", CONFIGS_XML, ".xml", new String[]{"(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORMESSAGE:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", TAG_LANG, TAG_OGNL_CONFIG, "(?s)^(OGNL:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_OGNL, TAG_GROOVY_CONFIG, "(?s)^(GROOVY:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_GROOVY, TAG_JANINO_CONFIG, "(?s)^(JANINO:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_JANINO}, new String[]{"(?:^MARK:(?:(\\w+):)?|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)", "^ELEMENT:(.*?)(:[^:]*)?$", TAG_CONFIG, TAG_L10N}, BeanHandlerXml.getInstance(), EncoderXml.getInstance(), new EngineTemplateInitializer());
        ENGINETXT = new TemplateFactory(ResourceFinderClasspath.getInstance(), "enginetxt", CONFIGS_TXT, ".txt", new String[]{TAG_LANG, TAG_OGNL_CONFIG, "(?s)^(OGNL:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_OGNL, TAG_GROOVY_CONFIG, "(?s)^(GROOVY:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_GROOVY, TAG_JANINO_CONFIG, "(?s)^(JANINO:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$", TAG_JANINO}, new String[]{"^ELEMENT:(.*?)(:[^:]*)?$", TAG_CONFIG, TAG_L10N}, BeanHandlerPlain.getInstance(), null, new EngineTemplateInitializer());
    }
}

