/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.template;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.resources.ResourceFinderDirectories;
import com.uwyn.rife.resources.ResourceFinderGroup;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.SortListComparables;
import com.uwyn.rife.tools.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDeployer {
    private boolean mVerbose = false;
    private File[] mDirectories = null;
    private TemplateFactory mTemplateFactory = null;
    private Pattern mInclude = null;
    private Pattern mExclude = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    TemplateDeployer(boolean verbose, ArrayList<String> directoryPaths, TemplateFactory templateFactory, Pattern include, Pattern exclude) {
        if (!$assertionsDisabled && directoryPaths == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && directoryPaths.size() <= 0) {
            throw new AssertionError();
        }
        this.mVerbose = verbose;
        this.mTemplateFactory = templateFactory;
        this.mInclude = include;
        this.mExclude = exclude;
        ArrayList<File> directories = new ArrayList<File>();
        File directory_file = null;
        for (String directory_path : (Collection)directoryPaths) {
            directory_file = new File(directory_path);
            if (!directory_file.exists()) {
                System.err.println(new StringBuffer().append(new StringBuffer().append("The path '").append(directory_path).toString()).append("' doesn't exist.").toString());
                System.exit(1);
            }
            if (!directory_file.isDirectory()) {
                System.err.println(new StringBuffer().append(new StringBuffer().append("The path '").append(directory_path).toString()).append("' is not a directory.").toString());
                System.exit(1);
            }
            if (!directory_file.canRead()) {
                System.err.println(new StringBuffer().append(new StringBuffer().append("The directory '").append(directory_path).toString()).append("' is not readable.").toString());
                System.exit(1);
            }
            directories.add(directory_file);
        }
        this.mDirectories = new File[directories.size()];
        this.mDirectories = directories.toArray(this.mDirectories);
    }

    private void execute() {
        ArrayList<String> files = null;
        String classname = null;
        Object full_path = null;
        File[] fileArray = this.mDirectories;
        int n = 0;
        while (n < fileArray.length) {
            File directory = fileArray[n];
            ResourceFinderGroup group = new ResourceFinderGroup().add(new ResourceFinderDirectories(new File[]{directory})).add(ResourceFinderClasspath.getInstance());
            this.mTemplateFactory.setResourceFinder(group);
            files = FileUtils.getFileList(directory, Pattern.compile(new StringBuffer().append(new StringBuffer().append(".*\\").append(this.mTemplateFactory.getParser().getExtension()).toString()).append("$").toString()), Pattern.compile(".*(SCCS|CVS|\\.svn).*"));
            for (String file : (Collection)files) {
                if (!StringUtils.filter(file, this.mInclude, this.mExclude)) continue;
                if (this.mVerbose) {
                    System.out.print(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(directory.getPath()).append(" : ").toString()).append(file).toString()).append(" ... ").toString());
                }
                classname = file.replace(File.separatorChar, '.');
                classname = classname.substring(0, classname.length() - this.mTemplateFactory.getParser().getExtension().length());
                this.mTemplateFactory.get(classname);
                if (!this.mVerbose) continue;
                System.out.println("done.");
            }
            ++n;
        }
    }

    private static void listTemplateTypes() {
        ArrayList<String> types = new ArrayList<String>(TemplateFactory.getFactoryTypes());
        SortListComparables sort = new SortListComparables();
        sort.sort(types);
        for (Object type : (Collection)types) {
            System.err.println(new StringBuffer().append("  ").append(type).toString());
        }
    }

    public static void main(String[] arguments) {
        boolean valid_arguments = true;
        boolean verbose = false;
        ArrayList<String> directory_paths = new ArrayList<String>();
        String template_type = "enginehtml";
        Pattern include = null;
        Pattern exclude = null;
        if (arguments.length < 1) {
            valid_arguments = false;
        } else {
            int i = 0;
            while (i < arguments.length) {
                if (arguments[i].startsWith("-")) {
                    if (arguments[i].equals("-t")) {
                        if (arguments[++i].startsWith("-")) {
                            valid_arguments = false;
                        } else {
                            template_type = arguments[i];
                        }
                    } else if (arguments[i].equals("-l")) {
                        System.err.println("The supported template types are:");
                        TemplateDeployer.listTemplateTypes();
                        System.exit(0);
                    } else if (arguments[i].equals("-verbose")) {
                        verbose = true;
                    } else if (arguments[i].equals("-d")) {
                        if (arguments[++i].startsWith("-")) {
                            valid_arguments = false;
                        } else {
                            RifeConfig.Template.setGenerationPath(arguments[i]);
                        }
                    } else if (arguments[i].equals("-encoding")) {
                        if (arguments[++i].startsWith("-")) {
                            valid_arguments = false;
                        } else {
                            RifeConfig.Template.setDefaultEncoding(arguments[i]);
                        }
                    } else if (arguments[i].equals("-preload")) {
                        if (arguments[++i].startsWith("-")) {
                            valid_arguments = false;
                        } else {
                            ArrayList<String> class_names = StringUtils.split(arguments[i], ":");
                            for (String class_name : (Collection)class_names) {
                                try {
                                    Class.forName(class_name);
                                }
                                catch (ClassNotFoundException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    } else if (arguments[i].equals("-i")) {
                        if (arguments[++i].startsWith("-")) {
                            valid_arguments = false;
                        } else {
                            include = Pattern.compile(arguments[i]);
                        }
                    } else if (arguments[i].equals("-e")) {
                        if (arguments[++i].startsWith("-")) {
                            valid_arguments = false;
                        } else {
                            exclude = Pattern.compile(arguments[i]);
                        }
                    } else {
                        valid_arguments = false;
                    }
                } else {
                    directory_paths.add(arguments[i]);
                }
                if (!valid_arguments) break;
                ++i;
            }
        }
        if (0 == directory_paths.size()) {
            valid_arguments = false;
        }
        if (!valid_arguments) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.template.TemplateDeployer");
            }
            catch (ClassNotFoundException i) {
                throw new NoClassDefFoundError(i.getMessage());
            }
            System.err.println(new StringBuffer().append(new StringBuffer().append("Usage : java ").append(clazz.getName()).toString()).append(" <options> <directories>").toString());
            System.err.println("Compiles RIFE templates to class files.");
            System.err.println("All the files of the active template type that are found in the provided");
            System.err.println("directories will be parsed and compiled to java bytecode into the");
            System.err.println("destination directory.");
            System.err.println("  -t <type>             Specify which template type to use (default enginehtml)");
            System.err.println("  -l                    List the known template types");
            System.err.println("  -verbose              Output messages about what the parser is doing");
            System.err.println("  -d <directory>        Specify where to place generated class files");
            System.err.println("  -encoding <encoding>  Specify character encoding used by template files");
            System.err.println("  -preload <classes>    Colon seperated list of classes to preload");
            System.err.println("  -i <regexp>           Regexp to include certain files");
            System.err.println("  -e <regexp>           Regexp to exclude certain files");
            System.err.println("  -help                 Print a synopsis of standard options");
            System.exit(1);
        }
        TemplateFactory factory = null;
        factory = TemplateFactory.getFactory(template_type);
        if (factory == null) {
            System.err.println(new StringBuffer().append(new StringBuffer().append("The template type '").append(template_type).toString()).append("' is not supported.").toString());
            System.err.println("The list of valid types is:");
            TemplateDeployer.listTemplateTypes();
            System.exit(1);
        }
        RifeConfig.Template.setGenerateClasses(true);
        TemplateDeployer deployer = new TemplateDeployer(verbose, directory_paths, factory, include, exclude);
        deployer.execute();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.TemplateDeployer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

