/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.template;

import com.uwyn.rife.template.AbstractTemplate;
import com.uwyn.rife.template.ExternalValue;
import com.uwyn.rife.template.exceptions.BlockUnknownException;
import com.uwyn.rife.template.exceptions.CircularContructionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalValue {
    private AbstractTemplate mTemplate = null;
    private ArrayList<CharSequence> mConstruction = new ArrayList();
    private ArrayList<CharSequence> mValueIds = new ArrayList();
    private ArrayList<CharSequence> mValueTags = new ArrayList();

    public void appendBlock(String blockId) {
        if (blockId == null) {
            throw new IllegalArgumentException("blockId can't be null.");
        }
        if (0 == blockId.length()) {
            throw new IllegalArgumentException("blockId can't be empty.");
        }
        if (!this.mTemplate.appendBlockInternalForm(blockId, this)) {
            throw new BlockUnknownException(blockId);
        }
    }

    public void appendValue(InternalValue value) {
        if (value == null) {
            throw new IllegalArgumentException("value can't be null.");
        }
        this.appendConstructedValue(value);
    }

    public void appendValue(Object value) {
        this.appendValue(String.valueOf(value));
    }

    public void appendValue(boolean value) {
        this.appendValue(String.valueOf(value));
    }

    public void appendValue(char value) {
        this.appendValue(String.valueOf(value));
    }

    public void appendValue(char[] value) {
        this.appendValue(String.valueOf(value));
    }

    public void appendValue(char[] value, int offset, int count) {
        this.appendValue(String.valueOf(value, offset, count));
    }

    public void appendValue(double value) {
        this.appendValue(String.valueOf(value));
    }

    public void appendValue(float value) {
        this.appendValue(String.valueOf(value));
    }

    public void appendValue(int value) {
        this.appendValue(String.valueOf(value));
    }

    public void appendValue(long value) {
        this.appendValue(String.valueOf(value));
    }

    public void appendValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value can't be null.");
        }
        this.appendText(value);
    }

    InternalValue(AbstractTemplate template2) {
        this.mTemplate = template2;
    }

    InternalValue(AbstractTemplate template2, List<CharSequence> deferredContent) {
        this.mTemplate = template2;
        if (deferredContent != null) {
            this.mConstruction.addAll(deferredContent);
        }
    }

    void increasePartsCapacity(int size) {
        this.mConstruction.ensureCapacity(size + this.mConstruction.size());
    }

    void increaseValuesCapacity(int size) {
        this.mValueIds.ensureCapacity(size + this.mValueIds.size());
        this.mValueTags.ensureCapacity(size + this.mValueTags.size());
    }

    int partsSize() {
        return this.mConstruction.size();
    }

    int valuesSize() {
        return this.mValueIds.size();
    }

    void appendExternalForm(ExternalValue result) {
        String value_id = null;
        String value_tag = null;
        int value_count = 0;
        for (CharSequence part : (Collection)this.mConstruction) {
            if (part == null) {
                value_id = this.mValueIds.get(value_count).toString();
                value_tag = this.mValueTags.get(value_count).toString();
                ++value_count;
                this.mTemplate.appendValueExternalForm(value_id, value_tag, result);
                continue;
            }
            result.append(part);
        }
    }

    void appendText(CharSequence text) {
        this.mConstruction.add(text);
    }

    void appendValueId(String id, String tag) {
        this.mConstruction.add(null);
        this.mValueIds.add(id);
        this.mValueTags.add(tag);
    }

    void appendConstructedValue(InternalValue constructedValue) {
        if (this == constructedValue || this.mValueIds == constructedValue.mValueIds) {
            throw new CircularContructionException();
        }
        this.increasePartsCapacity(constructedValue.partsSize());
        this.increaseValuesCapacity(constructedValue.valuesSize());
        for (CharSequence charsequence : (Collection)constructedValue.mConstruction) {
            this.mConstruction.add(charsequence);
        }
        for (CharSequence charsequence : (Collection)constructedValue.mValueIds) {
            this.mValueIds.add(charsequence);
        }
        for (CharSequence charsequence : (Collection)constructedValue.mValueTags) {
            this.mValueTags.add(charsequence);
        }
    }

    public boolean isEmpty() {
        return 0 == this.mConstruction.size();
    }

    public void clear() {
        this.mConstruction = new ArrayList();
        this.mValueIds = new ArrayList();
        this.mValueTags = new ArrayList();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        InternalValue other = (InternalValue)object;
        if (this.mConstruction.size() != other.mConstruction.size()) {
            return false;
        }
        Iterator<CharSequence> this_it = null;
        Iterator<CharSequence> other_it = null;
        CharSequence this_value = null;
        CharSequence other_value = null;
        this_it = this.mConstruction.iterator();
        other_it = other.mConstruction.iterator();
        while (this_it.hasNext()) {
            if (!other_it.hasNext()) {
                return false;
            }
            this_value = this_it.next();
            other_value = other_it.next();
            if (this_value == null && other_value == null) continue;
            if (this_value == null || other_value == null) {
                return false;
            }
            if (this_value.equals(other_value)) continue;
            return false;
        }
        CharSequence this_valueid = null;
        CharSequence other_valueid = null;
        this_it = this.mValueIds.iterator();
        other_it = other.mValueIds.iterator();
        while (this_it.hasNext()) {
            if (!other_it.hasNext()) {
                return false;
            }
            this_valueid = this_it.next();
            other_valueid = other_it.next();
            if (this_valueid == null && other_valueid == null) continue;
            if (this_valueid == null || other_valueid == null) {
                return false;
            }
            if (this_valueid.equals(other_valueid)) continue;
            return false;
        }
        CharSequence this_valuetag = null;
        CharSequence other_valuetag = null;
        this_it = this.mValueTags.iterator();
        other_it = other.mValueTags.iterator();
        while (this_it.hasNext()) {
            if (!other_it.hasNext()) {
                return false;
            }
            this_valuetag = this_it.next();
            other_valuetag = other_it.next();
            if (this_valuetag == null && other_valuetag == null) continue;
            if (this_valuetag == null || other_valuetag == null) {
                return false;
            }
            if (this_valuetag.equals(other_valuetag)) continue;
            return false;
        }
        return true;
    }
}

