/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class MouseMotionEventTranslator
implements MouseMotionListener {
    private Component mTargetComponent = null;

    public MouseMotionEventTranslator(Component targetComponent) {
        this.mTargetComponent = targetComponent;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.mTargetComponent instanceof MouseMotionListener) {
            MouseMotionListener target_listener = (MouseMotionListener)((Object)this.mTargetComponent);
            target_listener.mouseDragged(this.translateMouseEvent(e));
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.mTargetComponent instanceof MouseMotionListener) {
            MouseMotionListener target_listener = (MouseMotionListener)((Object)this.mTargetComponent);
            target_listener.mouseMoved(this.translateMouseEvent(e));
        }
    }

    private MouseEvent translateMouseEvent(MouseEvent e) {
        MouseEvent new_mouse_event = null;
        Point target_location = this.mTargetComponent.getLocationOnScreen();
        Component source_component = (Component)e.getSource();
        int new_x = (int)((double)source_component.getX() - target_location.getX() + (double)e.getX());
        int new_y = (int)((double)source_component.getY() - target_location.getY() + (double)e.getY());
        new_mouse_event = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), new_x, new_y, e.getClickCount(), e.isPopupTrigger());
        return new_mouse_event;
    }
}

