/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import java.awt.MenuContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class JMenuBuilder {
    private static final ItemActionEventBridge ITEM_ACTION_EVENT_BRIDGE = new ItemActionEventBridge();

    public static JMenu addMenu(MenuContainer parentMenu, String menuLabel) {
        return JMenuBuilder.addMenu(parentMenu, menuLabel, '\u0000');
    }

    public static JMenu addMenu(MenuContainer parentMenu, String menuLabel, char mnemonic) {
        if (parentMenu == null) {
            throw new IllegalArgumentException("parentMenu can't be null.");
        }
        if (menuLabel == null) {
            throw new IllegalArgumentException("menuLabel can't be null.");
        }
        if (0 == menuLabel.length()) {
            throw new IllegalArgumentException("menuLabel can't be empty.");
        }
        JMenu menu = new JMenu(menuLabel);
        if ('\u0000' != mnemonic) {
            menu.setMnemonic(mnemonic);
        }
        ((JComponent)parentMenu).add(menu);
        return menu;
    }

    public static JMenuItem addMenuItem(MenuContainer parentMenu, Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action can't be null.");
        }
        return JMenuBuilder.processMenuItem(new JMenuItem(action), parentMenu, null);
    }

    public static JCheckBoxMenuItem addCheckBoxMenuItem(MenuContainer parentMenu, Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action can't be null.");
        }
        return (JCheckBoxMenuItem)JMenuBuilder.processMenuItem(new JCheckBoxMenuItem(action), parentMenu, null);
    }

    public static JCheckBoxMenuItem addCheckBoxMenuItem(MenuContainer parentMenu, ButtonGroup group, Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action can't be null.");
        }
        return (JCheckBoxMenuItem)JMenuBuilder.processMenuItem(new JCheckBoxMenuItem(action), parentMenu, null);
    }

    public static JRadioButtonMenuItem addRadioButtonMenuItem(MenuContainer parentMenu, Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action can't be null.");
        }
        return (JRadioButtonMenuItem)JMenuBuilder.processMenuItem(new JRadioButtonMenuItem(action), parentMenu, null);
    }

    public static JRadioButtonMenuItem addRadioButtonMenuItem(MenuContainer parentMenu, ButtonGroup group, Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action can't be null.");
        }
        return (JRadioButtonMenuItem)JMenuBuilder.processMenuItem(new JRadioButtonMenuItem(action), parentMenu, group);
    }

    private static JMenuItem processMenuItem(JMenuItem menuItem, MenuContainer parentMenu, ButtonGroup group) {
        if (menuItem == null) {
            throw new IllegalArgumentException("menuItem can't be null.");
        }
        if (parentMenu == null) {
            throw new IllegalArgumentException("parentMenu can't be null.");
        }
        ((JComponent)parentMenu).add(menuItem);
        menuItem.addItemListener(ITEM_ACTION_EVENT_BRIDGE);
        if (group != null) {
            group.add(menuItem);
        }
        return menuItem;
    }

    private static class ItemActionEventBridge
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            JMenuItem menuitem;
            Action action;
            if (1 == event.getStateChange() && (action = (menuitem = (JMenuItem)event.getSource()).getAction()) != null) {
                action.actionPerformed(new ActionEvent(event.getSource(), 1001, menuitem.getActionCommand()));
            }
        }
    }
}

