/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.swing.Colors;
import com.uwyn.rife.swing.DefaultFocusSetter;
import com.uwyn.rife.swing.DefaultFocused;
import com.uwyn.rife.swing.Images;
import com.uwyn.rife.swing.JDialog;
import com.uwyn.rife.tools.Localization;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class JDialogConfirm
extends JDialog
implements ActionListener,
DefaultFocused {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected GridBagConstraints mConstraints = null;
    protected JFrame mParentFrame = null;
    protected JPanel mContentPane = null;
    protected JLabel mConfirmationIcon = null;
    protected JPanel mConfirmationIconPanel = null;
    protected JComponent mConfirmationMessage = null;
    protected JButton mOkButton = null;
    protected JButton mCancelButton = null;
    protected JPanel mButtonsPanel = null;
    protected int mPerformedAction = 1;

    public JDialogConfirm(JFrame frame, String text) {
        this(frame, Localization.getString("rife.dialog.confirm.title"), text);
    }

    public JDialogConfirm(JFrame frame, String title, String text) {
        this(frame, title, new JLabel(text));
    }

    public JDialogConfirm(JFrame frame, String title, JComponent messageComponent) {
        super(frame, title, true);
        this.mParentFrame = frame;
        this.mConfirmationIcon = new JLabel(Images.getRepInstance().getImageIcon(RifeConfig.Swing.getIconConfirmPath()));
        this.mConfirmationIcon.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, (Color)null));
        this.mConfirmationIcon.setBackground(Colors.CONFIRM_BACKGROUND);
        this.mConfirmationIcon.setOpaque(true);
        this.mConfirmationIconPanel = new JPanel();
        this.mConfirmationIconPanel.setBackground(Colors.CONFIRM_BACKGROUND);
        this.mConfirmationIconPanel.add(this.mConfirmationIcon);
        this.mConfirmationMessage = messageComponent;
        this.mConfirmationMessage.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mOkButton = new JButton();
        this.mOkButton.addActionListener(this);
        this.mCancelButton = new JButton();
        this.mCancelButton.addActionListener(this);
        this.mButtonsPanel = new JPanel(new FlowLayout(2));
        this.setButtonLabels();
        this.mButtonsPanel.add(this.mOkButton);
        this.mButtonsPanel.add(this.mCancelButton);
        this.mContentPane = new JPanel(new GridBagLayout());
        this.mContentPane.setBackground(Color.white);
        this.setContentPane(this.mContentPane);
        this.mConstraints = new GridBagConstraints();
        this.mConstraints.gridx = 0;
        this.mConstraints.gridy = 0;
        this.mConstraints.gridwidth = 1;
        this.mConstraints.gridheight = 1;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.anchor = 10;
        this.mConstraints.fill = 1;
        this.mContentPane.add((Component)this.mConfirmationIconPanel, this.mConstraints);
        this.mConstraints.gridx = 1;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.anchor = 18;
        this.mConstraints.fill = 2;
        this.mContentPane.add((Component)this.mConfirmationMessage, this.mConstraints);
        this.mConstraints.gridx = 0;
        this.mConstraints.gridy = 1;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.gridwidth = 2;
        this.mContentPane.add((Component)new JSeparator(0), this.mConstraints);
        this.mConstraints.gridy = 2;
        this.mContentPane.add((Component)this.mButtonsPanel, this.mConstraints);
        this.mContentPane.setVisible(true);
        this.pack();
        this.setDefaultCloseOperation(2);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        }
        new DefaultFocusSetter(this);
    }

    public JComponent getDefaultFocus() {
        return this.mOkButton;
    }

    protected void setButtonLabels() {
        this.mOkButton.setText(Localization.getString("rife.dialog.confirm.okbutton"));
        this.mOkButton.setMnemonic(Localization.getChar("rife.dialog.confirm.okbutton.mnemonic"));
        this.mCancelButton.setText(Localization.getString("rife.dialog.confirm.cancelbutton"));
        this.mCancelButton.setMnemonic(Localization.getChar("rife.dialog.confirm.cancelbutton.mnemonic"));
    }

    public int getPerformedAction() {
        return this.mPerformedAction;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.mOkButton == source) {
            this.mPerformedAction = 0;
            this.dispose();
        } else if (this.mCancelButton == source) {
            this.mPerformedAction = 1;
            this.dispose();
        }
    }
}

