/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import com.uwyn.rife.swing.DayButton;
import com.uwyn.rife.swing.DaySelectionListener;
import com.uwyn.rife.swing.JDateSelectorListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EtchedBorder;

public class JDateSelector
extends JComponent
implements ActionListener,
DaySelectionListener {
    private ArrayList<JDateSelectorListener> mJDateSelectorListeners = new ArrayList();
    private JPopupMenu mPopup = null;
    private Calendar mCalendar = null;
    private Font mFont = null;
    private SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat();
    private JComponent mParent = null;
    private int mCurrentDay = 0;
    private int mCurrentMonth = 0;
    private int mCurrentYear = 0;
    private GridBagConstraints mConstraints = null;
    private Insets mInsets = null;
    private JButton mPreviousYearButton = null;
    private JButton mPreviousMonthButton = null;
    private JLabel mSelectedDateLabel = null;
    private JButton mNextMonthButton = null;
    private JButton mNextYearButton = null;
    private JPanel mHeaderPanel = null;
    private JPanel mDaysPanel = null;
    private String[] mWeekDayNames = null;

    public JDateSelector() {
        this(Calendar.getInstance());
    }

    public JDateSelector(Calendar calendar) {
        this.mSimpleDateFormat.applyPattern("dd MMMM yyyy");
        this.setDate(calendar);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.mFont = font;
        if (this.mCalendar != null) {
            this.setDate(this.mCalendar);
        }
    }

    public void setWeekDayNames(String[] weekDayNames) {
        this.mWeekDayNames = weekDayNames;
        DateFormatSymbols symbols = this.mSimpleDateFormat.getDateFormatSymbols();
        symbols.setShortWeekdays(this.mWeekDayNames);
        this.mSimpleDateFormat.setDateFormatSymbols(symbols);
    }

    public void setMonthNames(String[] monthNames) {
        DateFormatSymbols symbols = this.mSimpleDateFormat.getDateFormatSymbols();
        symbols.setMonths(monthNames);
        this.mSimpleDateFormat.setDateFormatSymbols(symbols);
    }

    public void setDateFormatPattern(String pattern) {
        this.mSimpleDateFormat.applyPattern(pattern);
        this.updateLabel();
    }

    public void setDate(Calendar calendar) {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mCalendar = calendar;
        this.mCalendar.setLenient(true);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(2, 0, 2, 0);
        this.mPreviousYearButton = new JButton("<<");
        if (this.mFont != null) {
            this.mPreviousYearButton.setFont(this.mFont);
        }
        this.mPreviousYearButton.addActionListener(this);
        this.mPreviousMonthButton = new JButton("<");
        if (this.mFont != null) {
            this.mPreviousMonthButton.setFont(this.mFont);
        }
        this.mPreviousMonthButton.addActionListener(this);
        this.mSelectedDateLabel = new JLabel("", 0);
        if (this.mFont != null) {
            this.mSelectedDateLabel.setFont(this.mFont);
        }
        this.mSelectedDateLabel.setBorder(new EtchedBorder(1));
        this.mNextMonthButton = new JButton(">");
        if (this.mFont != null) {
            this.mNextMonthButton.setFont(this.mFont);
        }
        this.mNextMonthButton.addActionListener(this);
        this.mNextYearButton = new JButton(">>");
        if (this.mFont != null) {
            this.mNextYearButton.setFont(this.mFont);
        }
        this.mNextYearButton.addActionListener(this);
        if (this.mHeaderPanel != null) {
            this.remove(this.mHeaderPanel);
        }
        this.mHeaderPanel = new JPanel();
        this.mHeaderPanel.setLayout(new GridBagLayout());
        this.mConstraints.gridx = 0;
        this.mConstraints.gridy = 0;
        this.mConstraints.gridwidth = 1;
        this.mConstraints.gridheight = 1;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.anchor = 10;
        this.mConstraints.fill = 1;
        this.mConstraints.insets = this.mInsets;
        this.mHeaderPanel.add((Component)this.mPreviousYearButton, this.mConstraints);
        this.mConstraints.gridx = 1;
        this.mHeaderPanel.add((Component)this.mPreviousMonthButton, this.mConstraints);
        this.mConstraints.gridx = 2;
        this.mConstraints.weightx = 1.0;
        this.mHeaderPanel.add((Component)this.mSelectedDateLabel, this.mConstraints);
        this.mConstraints.gridx = 3;
        this.mConstraints.weightx = 0.0;
        this.mHeaderPanel.add((Component)this.mNextMonthButton, this.mConstraints);
        this.mConstraints.gridx = 4;
        this.mHeaderPanel.add((Component)this.mNextYearButton, this.mConstraints);
        this.setLayout(new BorderLayout());
        this.add("North", this.mHeaderPanel);
        this.createDaysOfTheMonth(this.mCalendar);
    }

    public Calendar getSelectedDate() {
        this.mCalendar.set(11, 0);
        this.mCalendar.set(12, 0);
        this.mCalendar.set(13, 0);
        return this.mCalendar;
    }

    public void popup(JComponent parent) {
        this.mPopup = new JPopupMenu();
        this.mPopup.add(this);
        this.mParent = parent;
        this.mPopup.show(this.mParent, 0, this.mParent.getHeight());
    }

    public JComponent getParentComponent() {
        return this.mParent;
    }

    public void popdown() {
        if (this.mPopup != null) {
            this.mPopup.setVisible(false);
        }
    }

    public boolean isPoppedUp() {
        if (this.mPopup == null) {
            return false;
        }
        return this.mPopup.isVisible();
    }

    private void createDaysOfTheMonth(Calendar calendar) {
        DayButton button;
        if (this.mDaysPanel != null) {
            this.remove(this.mDaysPanel);
        }
        this.mCurrentDay = calendar.get(5);
        this.mCurrentMonth = calendar.get(2);
        this.mCurrentYear = calendar.get(1);
        this.mDaysPanel = new JPanel(new GridLayout(7, 7));
        Calendar temp_calendar = null;
        temp_calendar = (Calendar)calendar.clone();
        int last_layout_position = 0;
        if (this.mWeekDayNames == null) {
            this.mWeekDayNames = this.mSimpleDateFormat.getDateFormatSymbols().getShortWeekdays();
        }
        int i = 1;
        while (i < 8) {
            JLabel label = new JLabel(this.mWeekDayNames[i]);
            if (this.mFont != null) {
                label.setFont(this.mFont);
            }
            this.mDaysPanel.add(label);
            temp_calendar.roll(7, true);
            ++last_layout_position;
            ++i;
        }
        temp_calendar = (Calendar)calendar.clone();
        temp_calendar.set(5, 1);
        int first_visible_day = temp_calendar.get(7);
        temp_calendar.roll(5, false);
        int last_day_of_month = temp_calendar.get(5);
        temp_calendar.set(5, 1);
        temp_calendar.roll(2, false);
        temp_calendar.roll(5, false);
        temp_calendar.set(5, temp_calendar.get(5) - (first_visible_day - 2));
        int i2 = 0;
        while (i2 < first_visible_day - 1) {
            button = new DayButton(temp_calendar.get(5) + i2);
            if (this.mFont != null) {
                button.setFont(this.mFont);
            }
            button.setEnabled(false);
            this.mDaysPanel.add(button);
            ++last_layout_position;
            ++i2;
        }
        temp_calendar = (Calendar)calendar.clone();
        temp_calendar.set(5, 1);
        i2 = 0;
        while (i2 < last_day_of_month) {
            button = new DayButton(temp_calendar.get(5));
            if (this.mFont != null) {
                button.setFont(this.mFont);
            }
            button.addDaySelectionListener(this);
            this.mDaysPanel.add(button);
            temp_calendar.roll(5, true);
            ++last_layout_position;
            ++i2;
        }
        i2 = last_layout_position;
        while (i2 < 49) {
            button = new DayButton(temp_calendar.get(5));
            if (this.mFont != null) {
                button.setFont(this.mFont);
            }
            button.setEnabled(false);
            this.mDaysPanel.add(button);
            temp_calendar.roll(5, true);
            ++i2;
        }
        this.add("Center", this.mDaysPanel);
        this.revalidate();
        if (this.mPopup != null) {
            this.mPopup.pack();
        }
        this.add("Center", this.mDaysPanel);
        this.updateLabel();
    }

    private void updateLabel() {
        this.mSelectedDateLabel.setText(this.mSimpleDateFormat.format(this.mCalendar.getTime()));
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.mPreviousYearButton == source) {
            this.mCalendar.roll(1, false);
            this.createDaysOfTheMonth(this.mCalendar);
        } else if (this.mPreviousMonthButton == source) {
            this.mCalendar.roll(2, false);
            this.createDaysOfTheMonth(this.mCalendar);
        } else if (this.mNextMonthButton == source) {
            this.mCalendar.roll(2, true);
            this.createDaysOfTheMonth(this.mCalendar);
        } else if (this.mNextYearButton == source) {
            this.mCalendar.roll(1, true);
            this.createDaysOfTheMonth(this.mCalendar);
        }
    }

    public void daySelected(int day) {
        this.mCalendar.set(5, day);
        this.updateLabel();
        this.mCurrentDay = day;
        if (this.mPopup != null) {
            this.mPopup.setVisible(false);
        }
        this.fireDateSelected(this.mCalendar.getTime());
    }

    public void addJDateSelectorListener(JDateSelectorListener jDateSelectorListeners) {
        this.mJDateSelectorListeners.add(jDateSelectorListeners);
    }

    public void removeJDateSelectorListener(JDateSelectorListener jDateSelectorListeners) {
        this.mJDateSelectorListeners.remove(jDateSelectorListeners);
    }

    private void fireDateSelected(Date date) {
        Iterator iterator = ((Collection)this.mJDateSelectorListeners).iterator();
        while (iterator.hasNext()) {
            JDateSelectorListener listener = (JDateSelectorListener)iterator.next();
            listener.dateSelected(date);
        }
    }
}

