/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import com.uwyn.rife.rep.Participant;
import com.uwyn.rife.rep.Rep;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.tools.ClasspathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Images {
    private String mPath = null;
    private HashMap<String, ImageIcon> mImages = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public Images() {
        this.mImages = new HashMap();
    }

    public Images(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path can't be null.");
        }
        if (0 == path.length()) {
            throw new IllegalArgumentException("path can't be empty.");
        }
        this.mPath = path;
        this.initialize();
        if (!$assertionsDisabled && this.mPath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mPath.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mImages == null) {
            throw new AssertionError();
        }
    }

    private void initialize() {
        this.mImages = new HashMap();
        ArrayList<String> resources = ClasspathUtils.getResourcesInDirectory(this.mPath);
        String graphics_filename_short = null;
        for (String graphics_filename : (Collection)resources) {
            graphics_filename_short = graphics_filename.substring(this.mPath.length());
            this.mImages.put(graphics_filename_short, new ImageIcon(ResourceFinderClasspath.getInstance().getResource(graphics_filename)));
        }
    }

    public static boolean hasRepInstance() {
        return Rep.hasParticipant("ParticipantImages");
    }

    public static Images getRepInstance() {
        Participant participant = Rep.getParticipant("ParticipantImages");
        if (participant == null) {
            return null;
        }
        return (Images)participant.getObject();
    }

    public ImageIcon getImageIcon(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path can't be null.");
        }
        return this.mImages.get(path);
    }

    public ArrayList<String> getImageIconNames(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix can't be null.");
        }
        ArrayList<String> matching_images = new ArrayList<String>();
        for (String image_filename : (Collection)this.mImages.keySet()) {
            if (!image_filename.startsWith(prefix)) continue;
            matching_images.add(image_filename);
        }
        return matching_images;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.swing.Images");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

