/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.template.Template;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidationFormatter {
    public static final String DEFAULT_ERROR_MESSAGE_ID = "error_message";
    public static final String DEFAULT_ERROR_LINE_ID = "error_line";
    public static final String DEFAULT_ERROR_CONTENT_ID = "error_content";
    public static final String DEFAULT_ERROR_AREA_ID = "error_area";

    public static void setValidationErrors(Template template2, Collection<ValidationError> errors) {
        ValidationFormatter.setValidationErrors(template2, errors, DEFAULT_ERROR_MESSAGE_ID, DEFAULT_ERROR_LINE_ID, DEFAULT_ERROR_CONTENT_ID, DEFAULT_ERROR_AREA_ID);
    }

    public static void setValidationErrors(Template template2, Collection<ValidationError> errors, String errorMessageId, String errorLineId, String errorContentId, String errorAreaId) {
        if (template2 == null || errors == null) {
            return;
        }
        if (errorMessageId == null) {
            throw new IllegalArgumentException("errorMessageId can't be null.");
        }
        if (errorLineId == null) {
            throw new IllegalArgumentException("errorLineId can't be null.");
        }
        if (errorContentId == null) {
            throw new IllegalArgumentException("errorContentId can't be null.");
        }
        if (errorAreaId == null) {
            throw new IllegalArgumentException("errorAreaId can't be null.");
        }
        if (!template2.hasValueId(errorMessageId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template value '").append(errorMessageId).toString()).append("'.").toString());
        }
        if (!template2.hasValueId(errorContentId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template value '").append(errorContentId).toString()).append("'.").toString());
        }
        if (!template2.hasValueId(errorAreaId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template value '").append(errorAreaId).toString()).append("'.").toString());
        }
        if (!template2.hasBlock(errorLineId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template block '").append(errorLineId).toString()).append("'.").toString());
        }
        if (!template2.hasBlock(errorAreaId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template block '").append(errorAreaId).toString()).append("'.").toString());
        }
        String error_block_name = null;
        for (ValidationError error : errors) {
            error_block_name = new StringBuffer().append(new StringBuffer().append(error.getIdentifier()).append(":").toString()).append(error.getSubject()).toString();
            if (template2.hasBlock(error_block_name)) {
                template2.setBlock(errorMessageId, error_block_name);
            } else {
                template2.setValue(errorMessageId, error_block_name);
            }
            template2.appendBlock(errorContentId, errorLineId);
        }
        template2.setBlock(errorAreaId, errorAreaId);
    }

    public static void setErrorArea(Template template2, String content) {
        ValidationFormatter.setErrorArea(template2, content, DEFAULT_ERROR_MESSAGE_ID, DEFAULT_ERROR_LINE_ID, DEFAULT_ERROR_CONTENT_ID, DEFAULT_ERROR_AREA_ID);
    }

    public static void setErrorArea(Template template2, String content, String errorMessageId, String errorLineId, String errorContentId, String errorAreaId) {
        if (template2 == null || content == null) {
            return;
        }
        if (errorMessageId == null) {
            throw new IllegalArgumentException("errorMessageId can't be null.");
        }
        if (errorLineId == null) {
            throw new IllegalArgumentException("errorLineId can't be null.");
        }
        if (errorContentId == null) {
            throw new IllegalArgumentException("errorContentId can't be null.");
        }
        if (errorAreaId == null) {
            throw new IllegalArgumentException("errorAreaId can't be null.");
        }
        if (!template2.hasValueId(errorMessageId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template value '").append(errorMessageId).toString()).append("'.").toString());
        }
        if (!template2.hasValueId(errorContentId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template value '").append(errorContentId).toString()).append("'.").toString());
        }
        if (!template2.hasValueId(errorAreaId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template value '").append(errorAreaId).toString()).append("'.").toString());
        }
        if (!template2.hasBlock(errorLineId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template block '").append(errorLineId).toString()).append("'.").toString());
        }
        if (!template2.hasBlock(errorAreaId)) {
            throw new IllegalArgumentException(new StringBuffer().append(new StringBuffer().append("Missing template block '").append(errorAreaId).toString()).append("'.").toString());
        }
        template2.setValue(errorMessageId, content);
        template2.setBlock(errorContentId, errorLineId);
        template2.setBlock(errorAreaId, errorAreaId);
    }

    public static void highlightInvalidSubjects(Template template2, Collection<ValidationError> errors, String highlightValuePrefix, String highlightBlockId) {
        if (template2 == null || errors == null) {
            return;
        }
        if (highlightValuePrefix == null) {
            throw new IllegalArgumentException("highlightValuePrefix can't be null.");
        }
        if (highlightBlockId == null) {
            throw new IllegalArgumentException("highlightBlockId can't be null.");
        }
        String value_id = null;
        for (ValidationError validationerror : errors) {
            value_id = new StringBuffer().append(highlightValuePrefix).append(validationerror.getSubject()).toString();
            if (!template2.hasValueId(value_id)) continue;
            template2.setBlock(value_id, highlightBlockId);
        }
    }
}

