/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedBean;
import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.PropertyValidationRule;
import com.uwyn.rife.site.Validated;
import com.uwyn.rife.site.ValidationContext;
import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.site.ValidationGroup;
import com.uwyn.rife.site.ValidationRule;
import com.uwyn.rife.site.ValidationRuleEmail;
import com.uwyn.rife.site.ValidationRuleFormat;
import com.uwyn.rife.site.ValidationRuleInList;
import com.uwyn.rife.site.ValidationRuleLimitedDate;
import com.uwyn.rife.site.ValidationRuleLimitedLength;
import com.uwyn.rife.site.ValidationRuleNotEmpty;
import com.uwyn.rife.site.ValidationRuleNotEqual;
import com.uwyn.rife.site.ValidationRuleNotNull;
import com.uwyn.rife.site.ValidationRuleRange;
import com.uwyn.rife.site.ValidationRuleRegexp;
import com.uwyn.rife.site.ValidationRuleSameAs;
import com.uwyn.rife.site.ValidationRuleUrl;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validation<T extends ConstrainedBean, E extends ConstrainedProperty>
implements Validated,
Constrained<T, E>,
Cloneable {
    private boolean mActivated = false;
    private ArrayList<ValidationRule> mValidationRules = null;
    private ArrayList<String> mValidatedSubjects = null;
    private HashMap<String, E> mConstrainedProperties = null;
    private HashMap<String, ValidationGroup<E>> mValidationGroups = null;
    private T mConstrainedBean = null;
    private Set<ValidationError> mValidationErrors = null;
    private List<String> mErrorLimitedSubjects = null;

    protected void activateValidation() {
    }

    private void ensureActivatedValidation() {
        if (this.mActivated) {
            return;
        }
        this.mActivated = true;
        this.activateValidation();
    }

    public ValidationGroup<E> addGroup(String name) {
        this.ensureActivatedValidation();
        if (this.mValidationGroups == null) {
            this.mValidationGroups = new HashMap();
        }
        ValidationGroup group = new ValidationGroup(name, this);
        this.mValidationGroups.put(name, group);
        return group;
    }

    public void focusGroup(String name) {
        this.ensureActivatedValidation();
        if (this.mValidationGroups == null || this.mValidationErrors == null || name == null) {
            return;
        }
        ValidationGroup<E> group = this.mValidationGroups.get(name);
        if (group == null) {
            return;
        }
        LinkedHashSet<ValidationError> retained_errors = new LinkedHashSet<ValidationError>();
        List<String> retained_subjects = group.getSubjects();
        for (ValidationError error : (Collection)this.mValidationErrors) {
            if (!retained_subjects.contains(error.getSubject())) continue;
            retained_errors.add(error);
        }
        this.mValidationErrors = retained_errors;
    }

    public void resetGroup(String name) {
        this.ensureActivatedValidation();
        if (this.mValidationGroups == null || this.mValidationErrors == null || name == null) {
            return;
        }
        ValidationGroup<E> group = this.mValidationGroups.get(name);
        if (group == null) {
            return;
        }
        LinkedHashSet<ValidationError> retained_errors = new LinkedHashSet<ValidationError>();
        List<String> group_subjects = group.getSubjects();
        for (ValidationError error : (Collection)this.mValidationErrors) {
            if (group_subjects.contains(error.getSubject())) continue;
            retained_errors.add(error);
        }
        this.mValidationErrors = retained_errors;
    }

    public void addRule(ValidationRule rule) {
        this.ensureActivatedValidation();
        if (rule == null) {
            return;
        }
        if (this.mValidationRules == null) {
            this.mValidationRules = new ArrayList();
        }
        if (this.mValidatedSubjects == null) {
            this.mValidatedSubjects = new ArrayList();
        }
        if (rule.getBean() == null) {
            rule.setBean(this);
        }
        this.mValidationRules.add(rule);
        String subject = rule.getSubject();
        if (!this.mValidatedSubjects.contains(subject)) {
            this.mValidatedSubjects.add(subject);
        }
    }

    private ValidationRule addConstrainedPropertyRule(E constrainedProperty, PropertyValidationRule rule) {
        rule.setConstrainedProperty((ConstrainedProperty)constrainedProperty);
        rule.setSubject(((ConstrainedProperty)constrainedProperty).getSubjectName());
        this.addRule(rule);
        return rule;
    }

    public ArrayList<PropertyValidationRule> getConstrainedPropertyRules(E constrainedProperty) {
        ArrayList<PropertyValidationRule> rules = new ArrayList<PropertyValidationRule>();
        if (((ConstrainedProperty)constrainedProperty).isNotNull()) {
            rules.add(new ValidationRuleNotNull(((ConstrainedProperty)constrainedProperty).getPropertyName()));
        }
        if (((ConstrainedProperty)constrainedProperty).isNotEmpty()) {
            rules.add(new ValidationRuleNotEmpty(((ConstrainedProperty)constrainedProperty).getPropertyName()));
        }
        if (((ConstrainedProperty)constrainedProperty).isNotEqual()) {
            rules.add(new ValidationRuleNotEqual(((ConstrainedProperty)constrainedProperty).getPropertyName(), ((ConstrainedProperty)constrainedProperty).getNotEqual()));
        }
        if (((ConstrainedProperty)constrainedProperty).hasLimitedLength()) {
            rules.add(new ValidationRuleLimitedLength(((ConstrainedProperty)constrainedProperty).getPropertyName(), ((ConstrainedProperty)constrainedProperty).getMinLength(), ((ConstrainedProperty)constrainedProperty).getMaxLength()));
        }
        if (((ConstrainedProperty)constrainedProperty).isEmail()) {
            rules.add(new ValidationRuleEmail(((ConstrainedProperty)constrainedProperty).getPropertyName()));
        }
        if (((ConstrainedProperty)constrainedProperty).isUrl()) {
            rules.add(new ValidationRuleUrl(((ConstrainedProperty)constrainedProperty).getPropertyName()));
        }
        if (((ConstrainedProperty)constrainedProperty).matchesRegexp()) {
            rules.add(new ValidationRuleRegexp(((ConstrainedProperty)constrainedProperty).getPropertyName(), ((ConstrainedProperty)constrainedProperty).getRegexp()));
        }
        if (((ConstrainedProperty)constrainedProperty).isLimitedDate()) {
            rules.add(new ValidationRuleLimitedDate(((ConstrainedProperty)constrainedProperty).getPropertyName(), ((ConstrainedProperty)constrainedProperty).getMinDate(), ((ConstrainedProperty)constrainedProperty).getMaxDate()));
        }
        if (((ConstrainedProperty)constrainedProperty).isInList()) {
            rules.add(new ValidationRuleInList(((ConstrainedProperty)constrainedProperty).getPropertyName(), ((ConstrainedProperty)constrainedProperty).getInList()));
        }
        if (((ConstrainedProperty)constrainedProperty).isRange()) {
            rules.add(new ValidationRuleRange(((ConstrainedProperty)constrainedProperty).getPropertyName(), ((ConstrainedProperty)constrainedProperty).getRangeBegin(), ((ConstrainedProperty)constrainedProperty).getRangeEnd()));
        }
        if (((ConstrainedProperty)constrainedProperty).isSameAs()) {
            rules.add(new ValidationRuleSameAs(((ConstrainedProperty)constrainedProperty).getPropertyName(), ((ConstrainedProperty)constrainedProperty).getSameAs()));
        }
        if (((ConstrainedProperty)constrainedProperty).isFormatted()) {
            rules.add(new ValidationRuleFormat(((ConstrainedProperty)constrainedProperty).getPropertyName(), ((ConstrainedProperty)constrainedProperty).getFormat()));
        }
        return rules;
    }

    List<PropertyValidationRule> addConstrainedPropertyRules(E constrainedProperty) {
        ConstrainedProperty old_constrained_property;
        this.ensureActivatedValidation();
        if (constrainedProperty == null) {
            return null;
        }
        if (this.mConstrainedProperties == null) {
            this.mConstrainedProperties = new LinkedHashMap<String, E>();
        }
        if ((old_constrained_property = (ConstrainedProperty)this.mConstrainedProperties.put(((ConstrainedProperty)constrainedProperty).getPropertyName(), constrainedProperty)) != null && this.mValidationRules != null) {
            ArrayList<ValidationRule> rules_to_remove = new ArrayList<ValidationRule>();
            for (ValidationRule rule : (Collection)this.mValidationRules) {
                if (!(rule instanceof PropertyValidationRule) || old_constrained_property != ((PropertyValidationRule)rule).getConstrainedProperty()) continue;
                rules_to_remove.add(rule);
            }
            this.mValidationRules.removeAll(rules_to_remove);
            HashMap<String, Object> merged_constraints = old_constrained_property.getConstraints();
            merged_constraints.putAll(((ConstrainedProperty)constrainedProperty).getConstraints());
            ((ConstrainedProperty)constrainedProperty).getConstraints().putAll(merged_constraints);
        }
        ArrayList<PropertyValidationRule> rules = this.getConstrainedPropertyRules(constrainedProperty);
        for (ValidationRule rule : (Collection)rules) {
            this.addConstrainedPropertyRule(constrainedProperty, (PropertyValidationRule)rule);
        }
        return rules;
    }

    @Override
    public void addConstraint(E constrainedProperty) {
        this.addConstrainedPropertyRules(constrainedProperty);
    }

    @Override
    public void addConstraint(T constrainedBean) {
        if (constrainedBean == null) {
            return;
        }
        if ((ConstrainedBean)this.mConstrainedBean != null) {
            HashMap<String, Object> merged_constraints = ((ConstrainedBean)this.mConstrainedBean).getConstraints();
            merged_constraints.putAll(((ConstrainedBean)constrainedBean).getConstraints());
            ((ConstrainedBean)this.mConstrainedBean).getConstraints().putAll(merged_constraints);
        }
        this.mConstrainedBean = constrainedBean;
    }

    @Override
    public void addValidationError(ValidationError error) {
        if (error == null) {
            return;
        }
        if (this.mValidationErrors == null) {
            this.mValidationErrors = new LinkedHashSet<ValidationError>();
        }
        if (this.mErrorLimitedSubjects != null && this.mErrorLimitedSubjects.contains(error.getSubject()) && !this.isSubjectValid(error.getSubject())) {
            return;
        }
        this.mValidationErrors.add(error);
    }

    public List<ValidationRule> getRules() {
        this.ensureActivatedValidation();
        if (this.mValidationRules == null) {
            this.mValidationRules = new ArrayList();
        }
        return this.mValidationRules;
    }

    @Override
    public Collection<E> getConstrainedProperties() {
        this.ensureActivatedValidation();
        if (this.mConstrainedProperties == null) {
            this.mConstrainedProperties = new LinkedHashMap<String, E>();
        }
        return this.mConstrainedProperties.values();
    }

    @Override
    public E getConstrainedProperty(String propertyName) {
        this.ensureActivatedValidation();
        if (propertyName == null || 0 == propertyName.length() || this.mConstrainedProperties == null) {
            return null;
        }
        return (E)((ConstrainedProperty)this.mConstrainedProperties.get(propertyName));
    }

    public Collection<ValidationGroup<E>> getGroups() {
        this.ensureActivatedValidation();
        if (this.mValidationGroups == null) {
            this.mValidationGroups = new HashMap();
        }
        return this.mValidationGroups.values();
    }

    public ValidationGroup<E> getGroup(String name) {
        this.ensureActivatedValidation();
        if (name == null || 0 == name.length() || this.mValidationGroups == null) {
            return null;
        }
        return this.mValidationGroups.get(name);
    }

    @Override
    public T getConstrainedBean() {
        this.ensureActivatedValidation();
        return (T)((ConstrainedBean)this.mConstrainedBean);
    }

    private boolean validateSubjects(List<String> subjects) {
        this.ensureActivatedValidation();
        if (this.mValidationRules == null || 0 == this.mValidationRules.size()) {
            return true;
        }
        for (ValidationRule rule : (Collection)this.mValidationRules) {
            if (subjects != null && !subjects.contains(rule.getSubject()) || rule.validate()) continue;
            this.addValidationError(rule.getError());
        }
        return 0 == this.countValidationErrors();
    }

    @Override
    public boolean validate() {
        return this.validateSubjects(null);
    }

    @Override
    public boolean validate(ValidationContext context) {
        this.validateSubjects(null);
        if (context != null) {
            context.validate(this);
        }
        return 0 == this.getValidationErrors().size();
    }

    public boolean validateGroup(String name) {
        this.ensureActivatedValidation();
        if (name == null || this.mValidationGroups == null) {
            return true;
        }
        List<String> subjects = null;
        ValidationGroup<E> group = this.mValidationGroups.get(name);
        if (group != null) {
            subjects = group.getSubjects();
        }
        if (subjects == null) {
            return true;
        }
        return this.validateSubjects(subjects);
    }

    @Override
    public int countValidationErrors() {
        if (this.mValidationErrors == null) {
            return 0;
        }
        return this.mValidationErrors.size();
    }

    @Override
    public void resetValidation() {
        if (this.mValidationErrors != null) {
            this.mValidationErrors = new LinkedHashSet<ValidationError>();
        }
    }

    @Override
    public Set<ValidationError> getValidationErrors() {
        if (this.mValidationErrors == null) {
            this.mValidationErrors = new LinkedHashSet<ValidationError>();
        }
        return this.mValidationErrors;
    }

    @Override
    public void replaceValidationErrors(Set<ValidationError> errors) {
        this.mValidationErrors = errors;
    }

    @Override
    public void limitSubjectErrors(String subject) {
        if (subject == null) {
            return;
        }
        if (this.mErrorLimitedSubjects == null) {
            this.mErrorLimitedSubjects = new ArrayList<String>();
        }
        if (!this.mErrorLimitedSubjects.contains(subject)) {
            this.mErrorLimitedSubjects.add(subject);
        }
    }

    @Override
    public void unlimitSubjectErrors(String subject) {
        if (subject == null) {
            return;
        }
        if (this.mErrorLimitedSubjects == null) {
            return;
        }
        this.mErrorLimitedSubjects.remove(subject);
    }

    @Override
    public boolean isSubjectValid(String subject) {
        if (subject == null) {
            return true;
        }
        if (this.mValidationErrors == null) {
            return true;
        }
        boolean valid = true;
        for (ValidationError error : (Collection)this.mValidationErrors) {
            if (!error.getSubject().equals(subject)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    @Override
    public void makeSubjectValid(String subject) {
        if (subject == null) {
            return;
        }
        if (this.mValidationErrors == null) {
            return;
        }
        ArrayList<ValidationError> errors_to_remove = new ArrayList<ValidationError>();
        for (ValidationError error : (Collection)this.mValidationErrors) {
            if (!error.getSubject().equals(subject)) continue;
            errors_to_remove.add(error);
        }
        for (ValidationError error_to_remove : (Collection)errors_to_remove) {
            this.mValidationErrors.remove(error_to_remove);
        }
    }

    @Override
    public void makeErrorValid(String identifier, String subject) {
        if (subject == null) {
            return;
        }
        if (identifier == null) {
            return;
        }
        if (this.mValidationErrors == null) {
            return;
        }
        ArrayList<ValidationError> errors_to_remove = new ArrayList<ValidationError>();
        for (ValidationError error : (Collection)this.mValidationErrors) {
            if (!error.getSubject().equals(subject) || !error.getIdentifier().equals(identifier)) continue;
            errors_to_remove.add(error);
        }
        for (ValidationError error_to_remove : (Collection)errors_to_remove) {
            this.mValidationErrors.remove(error_to_remove);
        }
    }

    @Override
    public List<String> getValidatedSubjects() {
        this.ensureActivatedValidation();
        if (this.mValidatedSubjects == null) {
            this.mValidatedSubjects = new ArrayList();
        }
        return this.mValidatedSubjects;
    }

    public static String getErrorIndication(Validated validated, String subject, String valid, String error) {
        if (validated != null && !validated.isSubjectValid(subject)) {
            return error;
        }
        return valid;
    }

    public Validation clone() throws CloneNotSupportedException {
        Validation new_validation = null;
        try {
            new_validation = (Validation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.site").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        if (this.mValidationRules != null) {
            new_validation.mValidationRules = ObjectUtils.deepClone(this.mValidationRules);
            Iterator<ValidationRule> rules_it = new_validation.mValidationRules.iterator();
            ValidationRule rule = null;
            while (rules_it.hasNext()) {
                rule = rules_it.next();
                if (this != rule.getBean()) continue;
                rule.setBean(new_validation);
            }
        }
        if (this.mValidationErrors != null) {
            new_validation.mValidationErrors = new LinkedHashSet<ValidationError>(this.mValidationErrors);
        }
        if (this.mConstrainedProperties != null) {
            new_validation.mConstrainedProperties = new LinkedHashMap<String, E>(this.mConstrainedProperties);
        }
        if (this.mErrorLimitedSubjects != null) {
            new_validation.mErrorLimitedSubjects = new ArrayList<String>(this.mErrorLimitedSubjects);
        }
        if (this.mValidationGroups != null) {
            new_validation.mValidationGroups = new HashMap();
            Object new_group = null;
            for (ValidationGroup<E> group : this.mValidationGroups.values()) {
                new_group = group.clone();
                ((ValidationGroup)new_group).setValidation(new_validation);
                new_validation.mValidationGroups.put(((ValidationGroup)new_group).getName(), (ValidationGroup<E>)new_group);
            }
        }
        return new_validation;
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

