/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.engine.ElementSupport;
import com.uwyn.rife.template.Template;

public class PagedNavigation {
    public static String PREFIX_NAV = "NAV:";
    public static String SUFFIX_DISABLED = ":DISABLED";
    public static String ID_RANGECOUNT = PREFIX_NAV + "RANGECOUNT";
    public static String ID_ABSOLUTERANGE_TEXT = "ABSOLUTERANGE_TEXT";
    public static String ID_FIRSTRANGE = PREFIX_NAV + "FIRSTRANGE";
    public static String ID_PREVIOUSRANGE = PREFIX_NAV + "PREVIOUSRANGE";
    public static String ID_ABSOLUTERANGES = PREFIX_NAV + "ABSOLUTERANGES";
    public static String ID_ABSOLUTERANGE = PREFIX_NAV + "ABSOLUTERANGE";
    public static String ID_NEXTRANGE = PREFIX_NAV + "NEXTRANGE";
    public static String ID_LASTRANGE = PREFIX_NAV + "LASTRANGE";
    public static String ID_FIRSTRANGE_DISABLED = PREFIX_NAV + "FIRSTRANGE" + SUFFIX_DISABLED;
    public static String ID_PREVIOUSRANGE_DISABLED = PREFIX_NAV + "PREVIOUSRANGE" + SUFFIX_DISABLED;
    public static String ID_ABSOLUTERANGE_DISABLED = PREFIX_NAV + "ABSOLUTERANGE" + SUFFIX_DISABLED;
    public static String ID_NEXTRANGE_DISABLED = PREFIX_NAV + "NEXTRANGE" + SUFFIX_DISABLED;
    public static String ID_LASTRANGE_DISABLED = PREFIX_NAV + "LASTRANGE" + SUFFIX_DISABLED;
    public static String DEFAULT_EXIT = "change_offset";
    public static String DEFAULT_OUTPUT = "offset";

    public static void generateNavigation(ElementSupport element, Template template2, long count, int limit, long offset, int span) {
        PagedNavigation.generateNavigation(element, template2, count, limit, offset, span, DEFAULT_EXIT, DEFAULT_OUTPUT);
    }

    public static void generateNavigation(ElementSupport element, Template template2, long count, int limit, long offset, int span, String exit, String output) {
        PagedNavigation.generateNavigation(element, template2, count, limit, offset, span, exit, output, null);
    }

    public static void generateNavigation(ElementSupport element, Template template2, long count, int limit, long offset, int span, String exit, String output, String pathInfo) {
        long max_offset;
        long range_count = (long)Math.ceil((double)count / (double)limit);
        if (range_count < (long)0) {
            range_count = 0;
        }
        if ((max_offset = (range_count - (long)1) * (long)limit) < (long)0) {
            max_offset = 0;
        }
        if (template2.hasValueId(ID_RANGECOUNT)) {
            template2.setValue(ID_RANGECOUNT, range_count);
        }
        offset = offset < (long)0 ? (long)0 : (offset > max_offset ? max_offset : (long)(Math.floor(offset / (long)limit) * (double)limit));
        String first_offset = "0";
        String previous_offset = String.valueOf(offset - (long)limit);
        String next_offset = String.valueOf(offset + (long)limit);
        String last_offset = String.valueOf((long)Math.floor((count - (long)1) / (long)limit) * (long)limit);
        if (offset <= (long)0) {
            template2.setBlock(ID_FIRSTRANGE, ID_FIRSTRANGE_DISABLED);
            template2.setBlock(ID_PREVIOUSRANGE, ID_PREVIOUSRANGE_DISABLED);
        } else {
            element.setExitQuery(template2, exit, pathInfo, new String[]{output, first_offset});
            template2.setBlock(ID_FIRSTRANGE, ID_FIRSTRANGE);
            element.setExitQuery(template2, exit, pathInfo, new String[]{output, previous_offset});
            template2.setBlock(ID_PREVIOUSRANGE, ID_PREVIOUSRANGE);
        }
        if (offset + (long)limit >= count) {
            template2.setBlock(ID_NEXTRANGE, ID_NEXTRANGE_DISABLED);
            template2.setBlock(ID_LASTRANGE, ID_LASTRANGE_DISABLED);
        } else {
            element.setExitQuery(template2, exit, pathInfo, new String[]{output, next_offset});
            template2.setBlock(ID_NEXTRANGE, ID_NEXTRANGE);
            element.setExitQuery(template2, exit, pathInfo, new String[]{output, last_offset});
            template2.setBlock(ID_LASTRANGE, ID_LASTRANGE);
        }
        long absolute_range_end = (long)(Math.floor(offset / (long)limit) + (double)span + 1.0);
        long absolute_range_page = (long)(Math.floor(offset / (long)limit) + 1.0 - (double)span);
        if (absolute_range_page < (long)1) {
            absolute_range_page = 1;
        }
        long absolute_range_offset = (absolute_range_page - (long)1) * (long)limit;
        template2.setValue(ID_ABSOLUTERANGES, "");
        if (absolute_range_page > (long)1) {
            template2.setValue(ID_ABSOLUTERANGE_TEXT, "...");
            template2.setBlock(ID_ABSOLUTERANGES, ID_ABSOLUTERANGE_DISABLED);
        }
        while (absolute_range_offset < count && absolute_range_page <= absolute_range_end) {
            template2.setValue(ID_ABSOLUTERANGE_TEXT, absolute_range_page);
            if (offset >= absolute_range_offset && offset < absolute_range_offset + (long)limit) {
                template2.appendBlock(ID_ABSOLUTERANGES, ID_ABSOLUTERANGE_DISABLED);
            } else {
                String[] outputs = new String[]{output, String.valueOf((int)absolute_range_offset)};
                element.setExitQuery(template2, exit, pathInfo, outputs);
                template2.appendBlock(ID_ABSOLUTERANGES, ID_ABSOLUTERANGE);
            }
            absolute_range_offset += (long)limit;
            ++absolute_range_page;
        }
        if ((double)absolute_range_end < Math.ceil(count / (long)limit)) {
            template2.setValue(ID_ABSOLUTERANGE_TEXT, "...");
            template2.appendBlock(ID_ABSOLUTERANGES, ID_ABSOLUTERANGE_DISABLED);
        }
        template2.removeValue(ID_ABSOLUTERANGE_TEXT);
    }
}

