/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedProperty;
import java.util.Iterator;

public class ConstrainedUtils {
    public static Constrained getConstrainedInstance(Class beanClass) {
        Class<?> clazz;
        if (beanClass == null) {
            return null;
        }
        Constrained constrained = null;
        try {
            clazz = Class.forName("com.uwyn.rife.site.Constrained");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz.isAssignableFrom(beanClass)) {
            try {
                constrained = (Constrained)beanClass.newInstance();
            }
            catch (Throwable e) {
                return null;
            }
        }
        return constrained;
    }

    public static Constrained makeConstrainedInstance(Object bean) {
        if (bean == null) {
            return null;
        }
        Constrained constrained = null;
        if (bean instanceof Constrained) {
            constrained = (Constrained)bean;
        }
        return constrained;
    }

    public static String getIdentityProperty(Class beanClass) {
        String identity_property = null;
        Constrained constrained_bean = ConstrainedUtils.getConstrainedInstance(beanClass);
        if (constrained_bean != null) {
            Iterator properties_it = constrained_bean.getConstrainedProperties().iterator();
            ConstrainedProperty property = null;
            while (properties_it.hasNext()) {
                property = (ConstrainedProperty)properties_it.next();
                if (!property.isIdentifier()) continue;
                identity_property = property.getPropertyName();
                break;
            }
        }
        if (identity_property == null) {
            identity_property = "id";
        }
        return identity_property;
    }

    public static boolean editConstrainedProperty(Constrained bean, String propertyName, String prefix) {
        if (bean == null) {
            return true;
        }
        if (prefix != null && propertyName.startsWith(prefix)) {
            propertyName = propertyName.substring(prefix.length());
        }
        ConstrainedProperty constrained_property = null;
        constrained_property = (ConstrainedProperty)bean.getConstrainedProperty(propertyName);
        return constrained_property == null || constrained_property.isEditable();
    }

    public static boolean persistConstrainedProperty(Constrained bean, String propertyName, String prefix) {
        if (bean == null) {
            return true;
        }
        if (prefix != null && propertyName.startsWith(prefix)) {
            propertyName = propertyName.substring(prefix.length());
        }
        ConstrainedProperty constrained_property = null;
        constrained_property = (ConstrainedProperty)bean.getConstrainedProperty(propertyName);
        return constrained_property == null || constrained_property.isPersistent() && !constrained_property.isSameAs();
    }

    public static boolean saveConstrainedProperty(Constrained bean, String propertyName, String prefix) {
        if (bean == null) {
            return true;
        }
        if (prefix != null && propertyName.startsWith(prefix)) {
            propertyName = propertyName.substring(prefix.length());
        }
        ConstrainedProperty constrained_property = null;
        constrained_property = (ConstrainedProperty)bean.getConstrainedProperty(propertyName);
        return constrained_property == null || constrained_property.isPersistent() && constrained_property.isSaved() && !constrained_property.isSameAs();
    }

    public static boolean fileConstrainedProperty(Constrained bean, String propertyName, String prefix) {
        if (bean == null) {
            return false;
        }
        if (prefix != null && propertyName.startsWith(prefix)) {
            propertyName = propertyName.substring(prefix.length());
        }
        ConstrainedProperty constrained_property = null;
        constrained_property = (ConstrainedProperty)bean.getConstrainedProperty(propertyName);
        return constrained_property != null && constrained_property.isFile();
    }
}

