/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.tools.ClassUtils;
import com.uwyn.rife.tools.Convert;
import java.text.Format;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedProperty<T extends ConstrainedProperty> {
    public static final String NOT_NULL = "NOT_NULL";
    public static final String NOT_EMPTY = "NOT_EMPTY";
    public static final String NOT_EQUAL = "NOT_EQUAL";
    public static final String UNIQUE = "UNIQUE";
    public static final String IDENTIFIER = "IDENTIFIER";
    public static final String EDITABLE = "EDITABLE";
    public static final String PERSISTANT = "PERSISTANT";
    public static final String SAVED = "SAVED";
    public static final String DISPLAYED_RAW = "DISPLAYED_RAW";
    public static final String MIN_LENGTH = "MIN_LENGTH";
    public static final String MAX_LENGTH = "MAX_LENGTH";
    public static final String SCALE = "SCALE";
    public static final String REGEXP = "REGEXP";
    public static final String EMAIL = "EMAIL";
    public static final String URL = "URL";
    public static final String MIN_DATE = "MIN_DATE";
    public static final String MAX_DATE = "MAX_DATE";
    public static final String IN_LIST = "IN_LIST";
    public static final String RANGE_BEGIN = "RANGE_BEGIN";
    public static final String RANGE_END = "RANGE_END";
    public static final String DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final String SAME_AS = "SAME_AS";
    public static final String MANY_TO_ONE = "MANY_TO_ONE";
    public static final String FORMAT = "FORMAT";
    public static final String FILE = "FILE";
    private String mPropertyName = null;
    private String mSubjectName = null;
    protected HashMap<String, Object> mConstraints = new HashMap();

    public ConstrainedProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName can't be null.");
        }
        if (0 == propertyName.length()) {
            throw new IllegalArgumentException("propertyName can't be empty.");
        }
        this.mPropertyName = propertyName;
    }

    public T subjectName(String name) {
        this.setSubjectName(name);
        return (T)this;
    }

    public void setSubjectName(String name) {
        this.mSubjectName = name;
    }

    public String getSubjectName() {
        if (this.mSubjectName == null) {
            return this.mPropertyName;
        }
        return this.mSubjectName;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    public T notNull(boolean notNull) {
        this.setNotNull(notNull);
        return (T)this;
    }

    public void setNotNull(boolean notNull) {
        this.mConstraints.put(NOT_NULL, new Boolean(notNull));
    }

    public boolean isNotNull() {
        return Convert.toBoolean(this.mConstraints.get(NOT_NULL), false);
    }

    public T notEmpty(boolean notEmpty) {
        this.setNotEmpty(notEmpty);
        return (T)this;
    }

    public void setNotEmpty(boolean notEmpty) {
        this.mConstraints.put(NOT_EMPTY, new Boolean(notEmpty));
    }

    public boolean isNotEmpty() {
        return Convert.toBoolean(this.mConstraints.get(NOT_EMPTY), false);
    }

    public T notEqual(boolean reference) {
        this.setNotEqual(reference);
        return (T)this;
    }

    public T notEqual(byte reference) {
        this.setNotEqual(reference);
        return (T)this;
    }

    public T notEqual(char reference) {
        this.setNotEqual(reference);
        return (T)this;
    }

    public T notEqual(short reference) {
        this.setNotEqual(reference);
        return (T)this;
    }

    public T notEqual(int reference) {
        this.setNotEqual(reference);
        return (T)this;
    }

    public T notEqual(long reference) {
        this.setNotEqual(reference);
        return (T)this;
    }

    public T notEqual(float reference) {
        this.setNotEqual(reference);
        return (T)this;
    }

    public T notEqual(double reference) {
        this.setNotEqual(reference);
        return (T)this;
    }

    public T notEqual(Object reference) {
        this.setNotEqual(reference);
        return (T)this;
    }

    public void setNotEqual(boolean reference) {
        this.setNotEqual(new Boolean(reference));
    }

    public void setNotEqual(byte reference) {
        this.setNotEqual(new Byte(reference));
    }

    public void setNotEqual(char reference) {
        this.setNotEqual(new Character(reference));
    }

    public void setNotEqual(short reference) {
        this.setNotEqual(new Short(reference));
    }

    public void setNotEqual(int reference) {
        this.setNotEqual(new Integer(reference));
    }

    public void setNotEqual(long reference) {
        this.setNotEqual(new Long(reference));
    }

    public void setNotEqual(float reference) {
        this.setNotEqual(new Float(reference));
    }

    public void setNotEqual(double reference) {
        this.setNotEqual(new Double(reference));
    }

    public void setNotEqual(Object reference) {
        if (reference == null) {
            this.mConstraints.remove(NOT_EQUAL);
        } else {
            this.mConstraints.put(NOT_EQUAL, reference);
        }
    }

    public boolean isNotEqual() {
        return this.mConstraints.containsKey(NOT_EQUAL);
    }

    public Object getNotEqual() {
        return this.mConstraints.get(NOT_EQUAL);
    }

    public T unique(boolean unique) {
        this.setUnique(unique);
        return (T)this;
    }

    public void setUnique(boolean unique) {
        this.mConstraints.put(UNIQUE, new Boolean(unique));
    }

    public boolean isUnique() {
        return Convert.toBoolean(this.mConstraints.get(UNIQUE), false);
    }

    public T identifier(boolean identifier) {
        this.setIdentifier(identifier);
        return (T)this;
    }

    public void setIdentifier(boolean identifier) {
        this.mConstraints.put(IDENTIFIER, new Boolean(identifier));
    }

    public boolean isIdentifier() {
        return Convert.toBoolean(this.mConstraints.get(IDENTIFIER), false);
    }

    public T editable(boolean editable) {
        this.setEditable(editable);
        return (T)this;
    }

    public void setEditable(boolean editable) {
        this.mConstraints.put(EDITABLE, new Boolean(editable));
    }

    public boolean isEditable() {
        return Convert.toBoolean(this.mConstraints.get(EDITABLE), true);
    }

    public T persistent(boolean persistent) {
        this.setPersistent(persistent);
        return (T)this;
    }

    public void setPersistent(boolean persistent) {
        this.mConstraints.put(PERSISTANT, new Boolean(persistent));
    }

    public boolean isPersistent() {
        return Convert.toBoolean(this.mConstraints.get(PERSISTANT), true);
    }

    public T saved(boolean saved) {
        this.setSaved(saved);
        return (T)this;
    }

    public void setSaved(boolean saved) {
        this.mConstraints.put(SAVED, new Boolean(saved));
    }

    public boolean isSaved() {
        return Convert.toBoolean(this.mConstraints.get(SAVED), true);
    }

    public T displayedRaw(boolean displayedRaw) {
        this.setDisplayedRaw(displayedRaw);
        return (T)this;
    }

    public void setDisplayedRaw(boolean displayedRaw) {
        this.mConstraints.put(DISPLAYED_RAW, new Boolean(displayedRaw));
    }

    public boolean isDisplayedRaw() {
        return Convert.toBoolean(this.mConstraints.get(DISPLAYED_RAW), false);
    }

    public boolean hasLimitedLength() {
        return this.mConstraints.containsKey(MIN_LENGTH) || this.mConstraints.containsKey(MAX_LENGTH);
    }

    public boolean hasMixLength() {
        return this.mConstraints.containsKey(MAX_LENGTH);
    }

    public boolean hasMaxLength() {
        return this.mConstraints.containsKey(MAX_LENGTH);
    }

    public T minLength(int minLength) {
        this.setMinLength(minLength);
        return (T)this;
    }

    public void setMinLength(int minLength) {
        if (minLength <= 0) {
            this.mConstraints.remove(MIN_LENGTH);
        } else {
            this.mConstraints.put(MIN_LENGTH, new Integer(minLength));
        }
    }

    public int getMinLength() {
        return Convert.toInt(this.mConstraints.get(MIN_LENGTH), -1);
    }

    public T maxLength(int maxLength) {
        this.setMaxLength(maxLength);
        return (T)this;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < 0) {
            this.mConstraints.remove(MAX_LENGTH);
        } else {
            this.mConstraints.put(MAX_LENGTH, new Integer(maxLength));
        }
    }

    public int getMaxLength() {
        return Convert.toInt(this.mConstraints.get(MAX_LENGTH), -1);
    }

    public boolean hasPrecision() {
        return this.mConstraints.containsKey(MAX_LENGTH);
    }

    public T precision(int precision) {
        this.setPrecision(precision);
        return (T)this;
    }

    public void setPrecision(int precision) {
        this.setMaxLength(precision);
    }

    public int getPrecision() {
        return this.getMaxLength();
    }

    public boolean hasScale() {
        return this.mConstraints.containsKey(SCALE);
    }

    public T scale(int scale) {
        this.setScale(scale);
        return (T)this;
    }

    public void setScale(int scale) {
        if (scale < 0) {
            this.mConstraints.remove(SCALE);
        } else {
            this.mConstraints.put(SCALE, new Integer(scale));
        }
    }

    public int getScale() {
        return Convert.toInt(this.mConstraints.get(SCALE), -1);
    }

    public T regexp(String regexp) {
        this.setRegexp(regexp);
        return (T)this;
    }

    public void setRegexp(String regexp) {
        if (regexp == null) {
            this.mConstraints.remove(REGEXP);
        } else {
            this.mConstraints.put(REGEXP, regexp);
        }
    }

    public String getRegexp() {
        return (String)this.mConstraints.get(REGEXP);
    }

    public boolean matchesRegexp() {
        return this.mConstraints.containsKey(REGEXP);
    }

    public T email(boolean email) {
        this.setEmail(email);
        return (T)this;
    }

    public void setEmail(boolean email) {
        this.mConstraints.put(EMAIL, new Boolean(email));
    }

    public boolean isEmail() {
        return Convert.toBoolean(this.mConstraints.get(EMAIL), false);
    }

    public T url(boolean url) {
        this.setUrl(url);
        return (T)this;
    }

    public void setUrl(boolean url) {
        this.mConstraints.put(URL, new Boolean(url));
    }

    public boolean isUrl() {
        return Convert.toBoolean(this.mConstraints.get(URL), false);
    }

    public T minDate(Date minDate) {
        this.setMinDate(minDate);
        return (T)this;
    }

    public void setMinDate(Date minDate) {
        if (minDate == null) {
            this.mConstraints.remove(MIN_DATE);
        } else {
            this.mConstraints.put(MIN_DATE, minDate);
        }
    }

    public Date getMinDate() {
        return (Date)this.mConstraints.get(MIN_DATE);
    }

    public T maxDate(Date maxDate) {
        this.setMaxDate(maxDate);
        return (T)this;
    }

    public void setMaxDate(Date maxDate) {
        if (maxDate == null) {
            this.mConstraints.remove(MAX_DATE);
        } else {
            this.mConstraints.put(MAX_DATE, maxDate);
        }
    }

    public Date getMaxDate() {
        return (Date)this.mConstraints.get(MAX_DATE);
    }

    public boolean isLimitedDate() {
        return this.mConstraints.containsKey(MIN_DATE) || this.mConstraints.containsKey(MAX_DATE);
    }

    public T inList(String[] inList) {
        this.setInList(inList);
        return (T)this;
    }

    public void setInList(String[] inList) {
        if (inList == null) {
            this.mConstraints.remove(IN_LIST);
        } else {
            this.mConstraints.put(IN_LIST, inList);
        }
    }

    public T inList(int[] inList) {
        this.setInList(inList);
        return (T)this;
    }

    public void setInList(int[] inList) {
        String[] list = null;
        if (inList != null) {
            list = new String[inList.length];
            int i = 0;
            while (i < inList.length) {
                list[i] = String.valueOf(inList[i]);
                ++i;
            }
        }
        this.setInList(list);
    }

    public T inList(byte[] inList) {
        this.setInList(inList);
        return (T)this;
    }

    public void setInList(byte[] inList) {
        String[] list = null;
        if (inList != null) {
            list = new String[inList.length];
            int i = 0;
            while (i < inList.length) {
                list[i] = String.valueOf(inList[i]);
                ++i;
            }
        }
        this.setInList(list);
    }

    public T inList(char[] inList) {
        this.setInList(inList);
        return (T)this;
    }

    public void setInList(char[] inList) {
        String[] list = null;
        if (inList != null) {
            list = new String[inList.length];
            int i = 0;
            while (i < inList.length) {
                list[i] = String.valueOf(inList[i]);
                ++i;
            }
        }
        this.setInList(list);
    }

    public T inList(short[] inList) {
        this.setInList(inList);
        return (T)this;
    }

    public void setInList(short[] inList) {
        String[] list = null;
        if (inList != null) {
            list = new String[inList.length];
            int i = 0;
            while (i < inList.length) {
                list[i] = String.valueOf(inList[i]);
                ++i;
            }
        }
        this.setInList(list);
    }

    public T inList(long[] inList) {
        this.setInList(inList);
        return (T)this;
    }

    public void setInList(long[] inList) {
        String[] list = null;
        if (inList != null) {
            list = new String[inList.length];
            int i = 0;
            while (i < inList.length) {
                list[i] = String.valueOf(inList[i]);
                ++i;
            }
        }
        this.setInList(list);
    }

    public T inList(float[] inList) {
        this.setInList(inList);
        return (T)this;
    }

    public void setInList(float[] inList) {
        String[] list = null;
        if (inList != null) {
            list = new String[inList.length];
            int i = 0;
            while (i < inList.length) {
                list[i] = String.valueOf(inList[i]);
                ++i;
            }
        }
        this.setInList(list);
    }

    public T inList(double[] inList) {
        this.setInList(inList);
        return (T)this;
    }

    public void setInList(double[] inList) {
        String[] list = null;
        if (inList != null) {
            list = new String[inList.length];
            int i = 0;
            while (i < inList.length) {
                list[i] = String.valueOf(inList[i]);
                ++i;
            }
        }
        this.setInList(list);
    }

    public T inList(Collection inList) {
        this.setInList(inList);
        return (T)this;
    }

    public void setInList(Collection inList) {
        String[] list = null;
        if (inList != null) {
            list = new String[inList.size()];
            int i = 0;
            for (Object entry : inList) {
                list[i++] = String.valueOf(entry);
            }
        }
        this.setInList(list);
    }

    public String[] getInList() {
        return (String[])this.mConstraints.get(IN_LIST);
    }

    public boolean isInList() {
        return this.mConstraints.containsKey(IN_LIST) && ((String[])this.mConstraints.get(IN_LIST)).length > 0;
    }

    public T rangeBegin(byte value) {
        this.setRangeBegin(value);
        return (T)this;
    }

    public T rangeBegin(char value) {
        this.setRangeBegin(value);
        return (T)this;
    }

    public T rangeBegin(short value) {
        this.setRangeBegin(value);
        return (T)this;
    }

    public T rangeBegin(int value) {
        this.setRangeBegin(value);
        return (T)this;
    }

    public T rangeBegin(long value) {
        this.setRangeBegin(value);
        return (T)this;
    }

    public T rangeBegin(float value) {
        this.setRangeBegin(value);
        return (T)this;
    }

    public T rangeBegin(double value) {
        this.setRangeBegin(value);
        return (T)this;
    }

    public T rangeBegin(Comparable value) {
        this.setRangeBegin(value);
        return (T)this;
    }

    public void setRangeBegin(byte value) {
        this.setRangeBegin(new Byte(value));
    }

    public void setRangeBegin(char value) {
        this.setRangeBegin(new Character(value));
    }

    public void setRangeBegin(short value) {
        this.setRangeBegin(new Short(value));
    }

    public void setRangeBegin(int value) {
        this.setRangeBegin(new Integer(value));
    }

    public void setRangeBegin(long value) {
        this.setRangeBegin(new Long(value));
    }

    public void setRangeBegin(float value) {
        this.setRangeBegin(new Float(value));
    }

    public void setRangeBegin(double value) {
        this.setRangeBegin(new Double(value));
    }

    public void setRangeBegin(Comparable rangeBegin) {
        if (rangeBegin == null) {
            this.mConstraints.remove(RANGE_BEGIN);
        } else {
            this.mConstraints.put(RANGE_BEGIN, rangeBegin);
        }
    }

    public Comparable getRangeBegin() {
        return (Comparable)this.mConstraints.get(RANGE_BEGIN);
    }

    public T rangeEnd(char value) {
        this.setRangeEnd(value);
        return (T)this;
    }

    public T rangeEnd(byte value) {
        this.setRangeEnd(value);
        return (T)this;
    }

    public T rangeEnd(double value) {
        this.setRangeEnd(value);
        return (T)this;
    }

    public T rangeEnd(float value) {
        this.setRangeEnd(value);
        return (T)this;
    }

    public T rangeEnd(int value) {
        this.setRangeEnd(value);
        return (T)this;
    }

    public T rangeEnd(long value) {
        this.setRangeEnd(value);
        return (T)this;
    }

    public T rangeEnd(short value) {
        this.setRangeEnd(value);
        return (T)this;
    }

    public T rangeEnd(Comparable value) {
        this.setRangeEnd(value);
        return (T)this;
    }

    public void setRangeEnd(byte value) {
        this.setRangeEnd(new Byte(value));
    }

    public void setRangeEnd(char value) {
        this.setRangeEnd(new Character(value));
    }

    public void setRangeEnd(short value) {
        this.setRangeEnd(new Short(value));
    }

    public void setRangeEnd(int value) {
        this.setRangeEnd(new Integer(value));
    }

    public void setRangeEnd(long value) {
        this.setRangeEnd(new Long(value));
    }

    public void setRangeEnd(float value) {
        this.setRangeEnd(new Float(value));
    }

    public void setRangeEnd(double value) {
        this.setRangeEnd(new Double(value));
    }

    public void setRangeEnd(Comparable rangeEnd) {
        if (rangeEnd == null) {
            this.mConstraints.remove(RANGE_END);
        } else {
            this.mConstraints.put(RANGE_END, rangeEnd);
        }
    }

    public Comparable getRangeEnd() {
        return (Comparable)this.mConstraints.get(RANGE_END);
    }

    public boolean isRange() {
        return this.mConstraints.containsKey(RANGE_BEGIN) || this.mConstraints.containsKey(RANGE_END);
    }

    public T defaultValue(boolean value) {
        return (T)((ConstrainedProperty)this.defaultValue(new Boolean(value)));
    }

    public T defaultValue(char value) {
        return (T)((ConstrainedProperty)this.defaultValue(new Character(value)));
    }

    public T defaultValue(byte value) {
        return (T)((ConstrainedProperty)this.defaultValue(new Byte(value)));
    }

    public T defaultValue(short value) {
        return (T)((ConstrainedProperty)this.defaultValue(new Short(value)));
    }

    public T defaultValue(int value) {
        return (T)((ConstrainedProperty)this.defaultValue(new Integer(value)));
    }

    public T defaultValue(long value) {
        return (T)((ConstrainedProperty)this.defaultValue(new Long(value)));
    }

    public T defaultValue(float value) {
        return (T)((ConstrainedProperty)this.defaultValue(new Float(value)));
    }

    public T defaultValue(double value) {
        return (T)((ConstrainedProperty)this.defaultValue(new Double(value)));
    }

    public T defaultValue(Object value) {
        this.setDefaultValue(value);
        return (T)this;
    }

    public void setDefaultValue(Object value) {
        if (value == null) {
            this.mConstraints.remove(DEFAULT_VALUE);
        } else {
            this.mConstraints.put(DEFAULT_VALUE, value);
        }
    }

    public Object getDefaultValue() {
        return this.mConstraints.get(DEFAULT_VALUE);
    }

    public boolean hasDefaultValue() {
        return this.mConstraints.containsKey(DEFAULT_VALUE);
    }

    public T sameAs(String reference) {
        this.setSameAs(reference);
        return (T)this;
    }

    public void setSameAs(String reference) {
        if (reference == null) {
            this.mConstraints.remove(SAME_AS);
        } else {
            this.mConstraints.put(SAME_AS, reference);
        }
    }

    public String getSameAs() {
        return (String)this.mConstraints.get(SAME_AS);
    }

    public boolean isSameAs() {
        return this.mConstraints.containsKey(SAME_AS);
    }

    public void setManyToOne(Class klass, String column_reference) {
        this.mConstraints.put(MANY_TO_ONE, new ManyToOne(klass, column_reference, null, null));
    }

    public void setManyToOne(String table, String column_reference) {
        this.mConstraints.put(MANY_TO_ONE, new ManyToOne(table, column_reference, null, null));
    }

    public void setManyToOne(Class klass, String column_reference, CreateTable.ViolationAction onUpdate, CreateTable.ViolationAction onDelete) {
        this.mConstraints.put(MANY_TO_ONE, new ManyToOne(klass, column_reference, onUpdate, onDelete));
    }

    public void setManyToOne(String table, String column_reference, CreateTable.ViolationAction onUpdate, CreateTable.ViolationAction onDelete) {
        this.mConstraints.put(MANY_TO_ONE, new ManyToOne(table, column_reference, onUpdate, onDelete));
    }

    public ConstrainedProperty<T> getManyToOne() {
        return (ManyToOne)this.mConstraints.get(MANY_TO_ONE);
    }

    public T manyToOne(Class klass, String column_reference) {
        this.setManyToOne(klass, column_reference);
        return (T)this;
    }

    public T manyToOne(String table, String column_reference) {
        this.setManyToOne(table, column_reference);
        return (T)this;
    }

    public T manyToOne(Class klass, String column_reference, CreateTable.ViolationAction onUpdate, CreateTable.ViolationAction onDelete) {
        this.setManyToOne(klass, column_reference, onUpdate, onDelete);
        return (T)this;
    }

    public T manyToOne(String table, String column_reference, CreateTable.ViolationAction onUpdate, CreateTable.ViolationAction onDelete) {
        this.setManyToOne(table, column_reference, onUpdate, onDelete);
        return (T)this;
    }

    public boolean hasManyToOne() {
        return this.mConstraints.containsKey(MANY_TO_ONE);
    }

    public T format(Format format) {
        this.setFormat(format);
        return (T)this;
    }

    public void setFormat(Format format) {
        if (format == null) {
            this.mConstraints.remove(FORMAT);
        } else {
            this.mConstraints.put(FORMAT, format);
        }
    }

    public Format getFormat() {
        return (Format)this.mConstraints.get(FORMAT);
    }

    public boolean isFormatted() {
        return this.mConstraints.containsKey(FORMAT);
    }

    public T file(boolean file) {
        this.setFile(file);
        return (T)this;
    }

    public void setFile(boolean file) {
        this.mConstraints.put(FILE, new Boolean(file));
    }

    public boolean isFile() {
        return Convert.toBoolean(this.mConstraints.get(FILE), false);
    }

    HashMap<String, Object> getConstraints() {
        return this.mConstraints;
    }

    public class ManyToOne {
        private String mColumn = null;
        private String mTable = null;
        private CreateTable.ViolationAction mOnUpdate = null;
        private CreateTable.ViolationAction mOnDelete = null;

        public ManyToOne(String table, String column, CreateTable.ViolationAction onUpdate, CreateTable.ViolationAction onDelete) {
            this.mColumn = column;
            this.mTable = table;
            this.mOnUpdate = onUpdate;
            this.mOnDelete = onDelete;
        }

        public ManyToOne(Class klass, String column, CreateTable.ViolationAction onUpdate, CreateTable.ViolationAction onDelete) {
            this(ClassUtils.shortenClassName(klass), column, onUpdate, onDelete);
        }

        public void setColumn(String column) {
            this.mColumn = column;
        }

        public String getColumn() {
            return this.mColumn;
        }

        public void setTable(String table) {
            this.mTable = table;
        }

        public String getTable() {
            return this.mTable;
        }

        public void setOnUpdate(CreateTable.ViolationAction onUpdate) {
            this.mOnUpdate = onUpdate;
        }

        public CreateTable.ViolationAction getOnUpdate() {
            return this.mOnUpdate;
        }

        public void setOnDelete(CreateTable.ViolationAction onDelete) {
            this.mOnDelete = onDelete;
        }

        public CreateTable.ViolationAction getOnDelete() {
            return this.mOnDelete;
        }

        static /* synthetic */ ConstrainedProperty access$0(ManyToOne manyToOne) {
            return manyToOne.ConstrainedProperty.this;
        }
    }
}

