/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.datastructures.EnumClass;
import com.uwyn.rife.site.TextualIdentifierGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedBean<T extends ConstrainedBean> {
    public static final Direction ASC = new Direction("ASC");
    public static final Direction DESC = new Direction("DESC");
    public static final String ASSOCIATIONS = "ASSOCIATIONS";
    public static final String UNIQUE = "UNIQUE";
    public static final String TEXTUAL_IDENTIFIER = "TEXTUAL_IDENTIFIER";
    public static final String DEFAULT_ORDERING = "DEFAULT_ORDERING";
    protected HashMap<String, Object> mConstraints = new HashMap();

    public T associations(Class[] associations) {
        this.setAssociations(associations);
        return (T)this;
    }

    public void setAssociations(Class[] associations) {
        if (associations == null) {
            this.mConstraints.remove(ASSOCIATIONS);
        } else {
            this.mConstraints.put(ASSOCIATIONS, associations);
        }
    }

    public Class[] getAssociations() {
        return (Class[])this.mConstraints.get(ASSOCIATIONS);
    }

    public boolean hasAssociations() {
        return this.mConstraints.containsKey(ASSOCIATIONS) && ((Class[])this.mConstraints.get(ASSOCIATIONS)).length > 0;
    }

    public T unique(String[] unique) {
        if (unique != null) {
            ArrayList<String[]> unique_list = (ArrayList<String[]>)this.mConstraints.get(UNIQUE);
            if (unique_list == null) {
                unique_list = new ArrayList<String[]>();
                this.mConstraints.put(UNIQUE, unique_list);
            }
            unique_list.add(unique);
        }
        return (T)this;
    }

    public T uniques(List<String[]> unique) {
        this.setUniques(unique);
        return (T)this;
    }

    public void setUniques(List<String[]> unique) {
        if (unique == null) {
            this.mConstraints.remove(UNIQUE);
        } else {
            this.mConstraints.put(UNIQUE, unique);
        }
    }

    public List<String[]> getUniques() {
        return (List)this.mConstraints.get(UNIQUE);
    }

    public boolean hasUniques() {
        return this.mConstraints.containsKey(UNIQUE) && ((List)this.mConstraints.get(UNIQUE)).size() > 0;
    }

    public T textualIdentifier(TextualIdentifierGenerator identifier) {
        this.setTextualIdentifier(identifier);
        return (T)this;
    }

    public void setTextualIdentifier(TextualIdentifierGenerator identifier) {
        if (identifier == null) {
            this.mConstraints.remove(TEXTUAL_IDENTIFIER);
        } else {
            this.mConstraints.put(TEXTUAL_IDENTIFIER, identifier);
        }
    }

    public TextualIdentifierGenerator getTextualIdentifier() {
        return (TextualIdentifierGenerator)this.mConstraints.get(TEXTUAL_IDENTIFIER);
    }

    public boolean hasTextualIdentifier() {
        return this.mConstraints.containsKey(TEXTUAL_IDENTIFIER);
    }

    public T defaultOrder(String propertyName) {
        return (T)((ConstrainedBean)this.defaultOrder(propertyName, ASC));
    }

    public T defaultOrder(String propertyName, Direction direction) {
        return (T)((ConstrainedBean)this.defaultOrder(new Order(propertyName, direction)));
    }

    public T defaultOrder(Order order) {
        if (order != null) {
            ArrayList<Order> ordering_list = (ArrayList<Order>)this.mConstraints.get(DEFAULT_ORDERING);
            if (ordering_list == null) {
                ordering_list = new ArrayList<Order>();
                this.mConstraints.put(DEFAULT_ORDERING, ordering_list);
            }
            ordering_list.add(order);
        }
        return (T)this;
    }

    public T defaultOrdering(List<Order> ordering) {
        this.setDefaultOrdering(ordering);
        return (T)this;
    }

    public void setDefaultOrdering(List<Order> ordering) {
        if (ordering == null) {
            this.mConstraints.remove(DEFAULT_ORDERING);
        } else {
            this.mConstraints.put(DEFAULT_ORDERING, ordering);
        }
    }

    public List<Order> getDefaultOrdering() {
        return (List)this.mConstraints.get(DEFAULT_ORDERING);
    }

    public boolean hasDefaultOrdering() {
        return this.mConstraints.containsKey(DEFAULT_ORDERING) && ((List)this.mConstraints.get(DEFAULT_ORDERING)).size() > 0;
    }

    HashMap<String, Object> getConstraints() {
        return this.mConstraints;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Direction
    extends EnumClass<String> {
        Direction(String identifier) {
            super(identifier);
        }
    }

    public static class Order
    implements Cloneable {
        private String mPropertyName = null;
        private Direction mDirection = null;

        public Order(String property, Direction direction) {
            this.setPropertyName(property);
            this.setDirection(direction);
        }

        public String getPropertyName() {
            return this.mPropertyName;
        }

        void setPropertyName(String propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException("propertyName can't be null.");
            }
            if (0 == propertyName.length()) {
                throw new IllegalArgumentException("propertyName can't be empty.");
            }
            this.mPropertyName = propertyName;
        }

        public Direction getDirection() {
            return this.mDirection;
        }

        void setDirection(Direction direction) {
            if (direction == null) {
                throw new IllegalArgumentException("direction can't be null.");
            }
            this.mDirection = direction;
        }

        public Order clone() {
            Order new_instance = null;
            try {
                new_instance = (Order)super.clone();
            }
            catch (CloneNotSupportedException e) {
                new_instance = null;
            }
            return new_instance;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }
    }
}

