/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.site.ValidationBuilder;
import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.site.exceptions.MissingMarkingBlockException;
import com.uwyn.rife.template.InternalValue;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.tools.ExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidationBuilder
implements ValidationBuilder {
    @Override
    public void setFallbackErrorArea(Template template2, String message) {
        if (template2 == null) {
            return;
        }
        if (message == null) {
            message = "";
        }
        if (template2.hasValueId("ERRORS") && template2.hasBlock("ERRORS:")) {
            if (template2.hasValueId("ERRORMESSAGE") && template2.hasBlock("ERRORMESSAGE:*")) {
                template2.setValue("ERRORMESSAGE", message);
                template2.setBlock("ERRORS", "ERRORMESSAGE:*");
                template2.setBlock("ERRORS:*", "ERRORS:");
                template2.removeValue("ERRORMESSAGE");
                template2.removeValue("ERRORS");
            } else {
                template2.setValue("ERRORS", message);
                template2.setBlock("ERRORS:*", "ERRORS:");
                template2.removeValue("ERRORS");
            }
        } else if (template2.hasValueId("ERRORS") && template2.hasBlock("ERRORS:*")) {
            if (template2.hasValueId("ERRORMESSAGE") && template2.hasBlock("ERRORMESSAGE:*")) {
                template2.setValue("ERRORMESSAGE", message);
                template2.setBlock("ERRORS", "ERRORMESSAGE:*");
                template2.setBlock("ERRORS:*", "ERRORS:*");
                template2.removeValue("ERRORMESSAGE");
                template2.removeValue("ERRORS");
            } else {
                template2.setValue("ERRORS", message);
                template2.setBlock("ERRORS:*", "ERRORS:*");
                template2.removeValue("ERRORS");
            }
        } else {
            template2.setValue("ERRORS:*", message);
        }
    }

    @Override
    public Collection<String> generateValidationErrors(Template template2, Collection<ValidationError> errors, Collection<String> onlySubjectsToClear, String prefix) {
        ArrayList<String> set_values = new ArrayList<String>();
        if (template2 == null || errors == null) {
            return set_values;
        }
        if (prefix != null && onlySubjectsToClear != null) {
            ArrayList<String> prefixed_subjects = new ArrayList<String>();
            for (String property : onlySubjectsToClear) {
                prefixed_subjects.add(new StringBuffer().append(prefix).append(property).toString());
            }
            onlySubjectsToClear = prefixed_subjects;
        }
        if (errors.size() > 0) {
            boolean has_fallback_errors_block = template2.hasBlock("ERRORS:*");
            boolean has_fallback_errors_value = template2.hasValueId("ERRORS:*");
            InternalValue fallback_errors_construction = null;
            if (has_fallback_errors_value) {
                template2.removeValue("ERRORS:*");
                fallback_errors_construction = template2.createInternalValue();
            }
            List<String[]> filtered_errorvalues = template2.getFilteredValues("(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)");
            ArrayList<ArrayList<Object>> sorted_errorvalues = null;
            if (filtered_errorvalues.size() > 0) {
                sorted_errorvalues = new ArrayList<ArrayList<Object>>();
                ArrayList<Object> errorvalues = null;
                for (Object filtered_value : (Collection)filtered_errorvalues) {
                    if (onlySubjectsToClear == null) {
                        template2.removeValue((String)filtered_value[0]);
                    } else {
                        int i = 1;
                        while (i < ((Object)filtered_value).length) {
                            if (onlySubjectsToClear.contains(filtered_value[i])) {
                                template2.removeValue((String)filtered_value[0]);
                                break;
                            }
                            ++i;
                        }
                    }
                    if (((Object)filtered_value).length - 1 < sorted_errorvalues.size()) {
                        errorvalues = (ArrayList<Object>)sorted_errorvalues.get(((Object)filtered_value).length - 1);
                    } else {
                        errorvalues = null;
                        while (((Object)filtered_value).length - 1 >= sorted_errorvalues.size()) {
                            sorted_errorvalues.add(null);
                        }
                    }
                    if (errorvalues == null) {
                        errorvalues = new ArrayList<Object>();
                        sorted_errorvalues.set(((Object)filtered_value).length - 1, errorvalues);
                    }
                    errorvalues.add(filtered_value);
                }
            }
            List<String[]> filtered_errorblocks = template2.getFilteredBlocks("(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)");
            ArrayList<ArrayList<String[]>> sorted_errorblocks = null;
            if (filtered_errorblocks.size() > 0) {
                sorted_errorblocks = new ArrayList<ArrayList<String[]>>();
                ArrayList<String[]> errorblocks = null;
                for (String[] filtered_block : (Collection)filtered_errorblocks) {
                    if (filtered_block.length - 1 < sorted_errorblocks.size()) {
                        errorblocks = (ArrayList<String[]>)sorted_errorblocks.get(filtered_block.length - 1);
                    } else {
                        errorblocks = null;
                        while (filtered_block.length - 1 >= sorted_errorblocks.size()) {
                            sorted_errorblocks.add(null);
                        }
                    }
                    if (errorblocks == null) {
                        errorblocks = new ArrayList<String[]>();
                        sorted_errorblocks.set(filtered_block.length - 1, errorblocks);
                    }
                    errorblocks.add(filtered_block);
                }
            }
            LinkedHashMap block_properties_mapping = null;
            if (sorted_errorblocks != null) {
                block_properties_mapping = new LinkedHashMap();
                ArrayList<Object> block_properties = null;
                for (List categorized_errorblocks : (Collection)sorted_errorblocks) {
                    if (categorized_errorblocks == null) continue;
                    for (Object filtered_block : (Collection)categorized_errorblocks) {
                        block_properties = new ArrayList<Object>();
                        block_properties_mapping.put(filtered_block[0], block_properties);
                        int i = 1;
                        while (i < ((String[])filtered_block).length) {
                            block_properties.add(filtered_block[i]);
                            ++i;
                        }
                    }
                }
            }
            Collection<String> invalid_subjects = this.collectSubjects(errors, prefix);
            HashMap<String, InternalValue> values_construction = null;
            HashMap<String, String> property_value_mapping = null;
            HashMap<String, String> values_block_mapping = null;
            if (filtered_errorvalues.size() > 0) {
                values_construction = new HashMap<String, InternalValue>();
                property_value_mapping = new HashMap<String, String>();
                values_block_mapping = new HashMap<String, String>();
                List errorvalues = null;
                int i = sorted_errorvalues.size() - 1;
                while (i >= 0) {
                    errorvalues = (List)sorted_errorvalues.get(i);
                    if (errorvalues != null) {
                        block10: for (String[] filtered_value : (Collection)errorvalues) {
                            boolean use_value = true;
                            int j = 1;
                            while (j < filtered_value.length) {
                                if (!invalid_subjects.contains(filtered_value[j])) {
                                    use_value = false;
                                    break;
                                }
                                ++j;
                            }
                            if (!use_value) continue;
                            boolean tied_to_properties = false;
                            int j2 = 1;
                            while (j2 < filtered_value.length) {
                                if (!property_value_mapping.containsKey(filtered_value[j2])) {
                                    property_value_mapping.put(filtered_value[j2], filtered_value[0]);
                                    tied_to_properties = true;
                                }
                                ++j2;
                            }
                            if (!tied_to_properties) continue;
                            values_construction.put(filtered_value[0], template2.createInternalValue());
                            ArrayList error_block_properties = null;
                            if (block_properties_mapping == null) continue;
                            for (Map.Entry error_block : (Collection)block_properties_mapping.entrySet()) {
                                boolean matching_block = true;
                                error_block_properties = (ArrayList)error_block.getValue();
                                int j3 = 1;
                                while (j3 < filtered_value.length) {
                                    if (!error_block_properties.contains(filtered_value[j3])) {
                                        matching_block = false;
                                        break;
                                    }
                                    ++j3;
                                }
                                if (!matching_block) continue;
                                values_block_mapping.put(filtered_value[0], (String)error_block.getKey());
                                continue block10;
                            }
                        }
                    }
                    --i;
                }
            }
            List<String[]> filtered_errormessages = template2.getFilteredBlocks("(?=(?<=^ERRORMESSAGE:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)");
            HashMap<String, String> property_errormessages_mapping = null;
            if (filtered_errormessages.size() > 0) {
                property_errormessages_mapping = new HashMap<String, String>();
                Object property_values = null;
                for (String[] filtered_errormessage : (Collection)filtered_errormessages) {
                    int i = 1;
                    while (i < filtered_errormessage.length) {
                        if (!property_errormessages_mapping.containsKey(filtered_errormessage[i])) {
                            property_errormessages_mapping.put(filtered_errormessage[i], filtered_errormessage[0]);
                        }
                        ++i;
                    }
                }
            }
            String property_value = null;
            InternalValue value_construction = null;
            String subject = null;
            for (ValidationError error : errors) {
                subject = error.getSubject();
                if (prefix != null) {
                    subject = new StringBuffer().append(prefix).append(subject).toString();
                }
                if ((property_value = property_value_mapping != null ? (String)property_value_mapping.get(subject) : null) != null) {
                    value_construction = (InternalValue)values_construction.get(property_value);
                    this.generateErrorMessage(template2, error, prefix, value_construction, property_errormessages_mapping);
                    continue;
                }
                if (!has_fallback_errors_value) continue;
                this.generateErrorMessage(template2, error, prefix, fallback_errors_construction, property_errormessages_mapping);
            }
            if (values_construction != null) {
                for (Map.Entry property_value_id : (Collection)values_construction.entrySet()) {
                    if (values_block_mapping != null && values_block_mapping.containsKey((String)property_value_id.getKey())) {
                        template2.setValue("ERRORS", (InternalValue)property_value_id.getValue());
                        template2.setBlock((String)property_value_id.getKey(), (String)values_block_mapping.get((String)property_value_id.getKey()));
                        template2.removeValue("ERRORS");
                    } else if (has_fallback_errors_block) {
                        template2.setValue("ERRORS", (InternalValue)property_value_id.getValue());
                        template2.setBlock((String)property_value_id.getKey(), "ERRORS:*");
                        template2.removeValue("ERRORS");
                    } else {
                        template2.setValue((String)property_value_id.getKey(), (InternalValue)property_value_id.getValue());
                    }
                    set_values.add((String)property_value_id.getKey());
                }
            }
            if (fallback_errors_construction != null && !fallback_errors_construction.isEmpty()) {
                if (has_fallback_errors_block) {
                    template2.setValue("ERRORS", fallback_errors_construction);
                    template2.setBlock("ERRORS:*", "ERRORS:*");
                    template2.removeValue("ERRORS");
                } else {
                    template2.setValue("ERRORS:*", fallback_errors_construction);
                }
                set_values.add("ERRORS:*");
            }
        }
        return set_values;
    }

    private Collection<String> collectSubjects(Collection<ValidationError> errors, String prefix) {
        ArrayList<String> invalid_subjects = new ArrayList<String>();
        String subject = null;
        for (ValidationError error : errors) {
            subject = error.getSubject();
            if (prefix != null) {
                subject = new StringBuffer().append(prefix).append(subject).toString();
            }
            if (invalid_subjects.contains(error.getSubject())) continue;
            invalid_subjects.add(subject);
        }
        return invalid_subjects;
    }

    private String generateErrorBlockId(ValidationError error, String prefix) {
        StringBuffer result;
        StringBuffer stringBuffer = result = new StringBuffer(error.getIdentifier());
        synchronized (stringBuffer) {
            result.append(":");
            if (prefix != null) {
                result.append(prefix);
            }
            result.append(error.getSubject());
            return result.toString();
        }
    }

    private String generateFallbackSubjectBlockId(ValidationError error, String prefix) {
        StringBuffer result;
        StringBuffer stringBuffer = result = new StringBuffer("ERROR:");
        synchronized (stringBuffer) {
            if (prefix != null) {
                result.append(prefix);
            }
            result.append(error.getSubject());
            return result.toString();
        }
    }

    private String generateFallbackIdentifierBlockId(ValidationError error, String prefix) {
        StringBuffer result;
        StringBuffer stringBuffer = result = new StringBuffer(error.getIdentifier());
        synchronized (stringBuffer) {
            result.append(":*");
            return result.toString();
        }
    }

    private void generateErrorMessage(Template template2, ValidationError error, String prefix, InternalValue valueConstruction, HashMap<String, String> errormessagesMapping) {
        String errormessage_block_id = null;
        String subject = error.getSubject();
        if (prefix != null) {
            subject = new StringBuffer().append(prefix).append(subject).toString();
        }
        if (errormessagesMapping != null) {
            errormessage_block_id = errormessagesMapping.get(subject);
        }
        if (errormessage_block_id == null && template2.hasBlock("ERRORMESSAGE:*")) {
            errormessage_block_id = "ERRORMESSAGE:*";
        }
        if (errormessage_block_id != null) {
            if (template2.hasValueId("ERRORMESSAGE")) {
                String errorblock_id = this.generateErrorBlockId(error, prefix);
                if (template2.hasBlock(errorblock_id)) {
                    template2.setBlock("ERRORMESSAGE", errorblock_id);
                } else {
                    String fallback_subject_errorblock_id = this.generateFallbackSubjectBlockId(error, prefix);
                    if (template2.hasBlock(fallback_subject_errorblock_id)) {
                        template2.setBlock("ERRORMESSAGE", fallback_subject_errorblock_id);
                    } else {
                        String fallback_identifier_errorblock_id = this.generateFallbackIdentifierBlockId(error, prefix);
                        if (template2.hasBlock(fallback_identifier_errorblock_id)) {
                            template2.setBlock("ERRORMESSAGE", fallback_identifier_errorblock_id);
                        } else if (template2.hasBlock("ERROR:*")) {
                            template2.setBlock("ERRORMESSAGE", "ERROR:*");
                        } else {
                            template2.setValue("ERRORMESSAGE", errorblock_id);
                        }
                    }
                }
                valueConstruction.appendBlock(errormessage_block_id);
                template2.removeValue("ERRORMESSAGE");
            } else {
                valueConstruction.appendBlock(errormessage_block_id);
            }
        } else {
            String error_value_id = this.generateErrorBlockId(error, prefix);
            if (template2.hasBlock(error_value_id)) {
                valueConstruction.appendBlock(error_value_id);
            } else {
                String errorblock_id = this.generateErrorBlockId(error, prefix);
                if (template2.hasBlock(errorblock_id)) {
                    valueConstruction.appendBlock(errorblock_id);
                } else {
                    String fallback_subject_errorblock_id = this.generateFallbackSubjectBlockId(error, prefix);
                    if (template2.hasBlock(fallback_subject_errorblock_id)) {
                        valueConstruction.appendBlock(fallback_subject_errorblock_id);
                    } else {
                        String fallback_identifier_errorblock_id = this.generateFallbackIdentifierBlockId(error, prefix);
                        if (template2.hasBlock(fallback_identifier_errorblock_id)) {
                            valueConstruction.appendBlock(fallback_identifier_errorblock_id);
                        } else if (template2.hasBlock("ERROR:*")) {
                            valueConstruction.appendBlock("ERROR:*");
                        } else {
                            valueConstruction.appendValue(this.formatLine(errorblock_id));
                        }
                    }
                }
            }
        }
    }

    protected abstract String formatLine(String var1);

    @Override
    public Collection<String> generateErrorMarkings(Template template2, Collection<ValidationError> errors, Collection<String> onlySubjectsToClear, String prefix) {
        ArrayList<String> set_values = new ArrayList<String>();
        if (template2 == null || errors == null) {
            return set_values;
        }
        if (prefix != null && onlySubjectsToClear != null) {
            ArrayList<String> prefixed_subjects = new ArrayList<String>();
            for (String property : onlySubjectsToClear) {
                prefixed_subjects.add(new StringBuffer().append(prefix).append(property).toString());
            }
            onlySubjectsToClear = prefixed_subjects;
        }
        List<String[]> filtered_marks = template2.getFilteredValues("(?:^MARK:(?:(\\w+):)?|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)");
        HashMap sorted_marks_map = null;
        if (filtered_marks.size() > 0) {
            sorted_marks_map = new HashMap();
            ArrayList<ArrayList<String[]>> sorted_marks = null;
            ArrayList<String[]> marks = null;
            for (String[] filtered_mark : (Collection)filtered_marks) {
                int number_of_properties;
                if (onlySubjectsToClear == null) {
                    template2.removeValue(filtered_mark[0]);
                } else {
                    int i = 1;
                    while (i < filtered_mark.length) {
                        if (onlySubjectsToClear.contains(filtered_mark[i])) {
                            template2.removeValue(filtered_mark[0]);
                            break;
                        }
                        ++i;
                    }
                }
                sorted_marks = (ArrayList<ArrayList<String[]>>)sorted_marks_map.get(filtered_mark[1]);
                if (sorted_marks == null) {
                    sorted_marks = new ArrayList<ArrayList<String[]>>();
                    sorted_marks_map.put(filtered_mark[1], sorted_marks);
                }
                if ((number_of_properties = (filtered_mark.length - 2) / 2) < sorted_marks.size()) {
                    marks = (ArrayList<String[]>)sorted_marks.get(number_of_properties);
                } else {
                    marks = null;
                    while (number_of_properties >= sorted_marks.size()) {
                        sorted_marks.add(null);
                    }
                }
                if (marks == null) {
                    marks = new ArrayList<String[]>();
                    sorted_marks.set(number_of_properties, marks);
                }
                marks.add(filtered_mark);
            }
        }
        Collection<String> invalid_subjects = this.collectSubjects(errors, prefix);
        if (sorted_marks_map != null) {
            for (Map.Entry sorted_marks_entry : (Collection)sorted_marks_map.entrySet()) {
                String mark_block_id = null;
                String mark_extension = (String)sorted_marks_entry.getKey();
                if (mark_extension == null) {
                    mark_block_id = "MARK:ERROR";
                } else {
                    StringBuffer buffer;
                    StringBuffer stringBuffer = buffer = new StringBuffer("MARK:ERROR");
                    synchronized (stringBuffer) {
                        buffer.append(":");
                        buffer.append(mark_extension);
                        mark_block_id = buffer.toString();
                    }
                }
                HashMap<String, String> property_mark_mapping = new HashMap<String, String>();
                ArrayList sorted_marks = (ArrayList)sorted_marks_entry.getValue();
                List marks = null;
                int i = sorted_marks.size() - 1;
                while (i >= 0) {
                    marks = (List)sorted_marks.get(i);
                    if (marks != null) {
                        for (String[] filtered_mark : (Collection)marks) {
                            boolean use_mark = true;
                            int j = 2;
                            while (j < filtered_mark.length) {
                                if (!invalid_subjects.contains(filtered_mark[j])) {
                                    use_mark = false;
                                    break;
                                }
                                j += 2;
                            }
                            if (!use_mark) continue;
                            boolean tied_to_properties = false;
                            int j2 = 2;
                            while (j2 < filtered_mark.length) {
                                if (!property_mark_mapping.containsKey(filtered_mark[j2])) {
                                    property_mark_mapping.put(filtered_mark[j2], filtered_mark[0]);
                                    tied_to_properties = true;
                                }
                                j2 += 2;
                            }
                            if (!tied_to_properties) continue;
                            if (!template2.hasBlock(mark_block_id)) {
                                throw new MissingMarkingBlockException(mark_block_id);
                            }
                            template2.setBlock(filtered_mark[0], mark_block_id);
                            set_values.add(filtered_mark[0]);
                        }
                    }
                    --i;
                }
            }
        }
        return set_values;
    }

    @Override
    public void removeValidationErrors(Template template2, Collection<String> subjects, String prefix) {
        List<String[]> filtered_errorvalues;
        if (template2 == null) {
            return;
        }
        if (subjects == null || 0 == subjects.size()) {
            return;
        }
        if (template2.hasValueId("ERRORS:*")) {
            template2.removeValue("ERRORS:*");
        }
        if (prefix != null) {
            ArrayList<String> prefixed_subjects = new ArrayList<String>();
            for (String property : subjects) {
                prefixed_subjects.add(new StringBuffer().append(prefix).append(property).toString());
            }
            subjects = prefixed_subjects;
        }
        if ((filtered_errorvalues = template2.getFilteredValues("(?=(?<=^ERRORS:)|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)")).size() > 0) {
            block1: for (String[] filtered_value : (Collection)filtered_errorvalues) {
                int i = 1;
                while (i < filtered_value.length) {
                    if (subjects.contains(filtered_value[i])) {
                        template2.removeValue(filtered_value[0]);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void removeErrorMarkings(Template template2, Collection<String> subjects, String prefix) {
        List<String[]> filtered_marks;
        if (template2 == null) {
            return;
        }
        if (subjects == null || 0 == subjects.size()) {
            return;
        }
        if (prefix != null) {
            ArrayList<String> prefixed_subjects = new ArrayList<String>();
            for (String property : subjects) {
                prefixed_subjects.add(new StringBuffer().append(prefix).append(property).toString());
            }
            subjects = prefixed_subjects;
        }
        if ((filtered_marks = template2.getFilteredValues("(?:^MARK:(?:(\\w+):)?|\\G(?<!^))\\s*(\\w+)\\s*,?(?=[\\w,]+$|$)")).size() > 0) {
            block1: for (String[] filtered_mark : (Collection)filtered_marks) {
                int i = 2;
                while (i < filtered_mark.length) {
                    if (subjects.contains(filtered_mark[i])) {
                        template2.removeValue(filtered_mark[0]);
                        continue block1;
                    }
                    i += 2;
                }
            }
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.site").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }
}

