/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler.taskoptionmanagers;

import com.uwyn.rife.pcj.map.IntKeyOpenHashMap;
import com.uwyn.rife.scheduler.Scheduler;
import com.uwyn.rife.scheduler.Taskoption;
import com.uwyn.rife.scheduler.TaskoptionManager;
import com.uwyn.rife.scheduler.exceptions.TaskManagerException;
import com.uwyn.rife.scheduler.exceptions.TaskoptionManagerException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.AddTaskoptionErrorException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.DuplicateTaskoptionException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.InexistentTaskIdException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.UpdateTaskoptionErrorException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryTaskoptions
implements TaskoptionManager {
    private Scheduler mScheduler = null;
    private IntKeyOpenHashMap<ArrayList<Taskoption>> mTaskoptionsMapping = new IntKeyOpenHashMap();

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.mScheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.mScheduler;
    }

    @Override
    public boolean addTaskoption(Taskoption taskoption) throws TaskoptionManagerException {
        if (taskoption == null) {
            throw new IllegalArgumentException("taskoption can't be null.");
        }
        if (taskoption.getTaskId() < 0) {
            throw new IllegalArgumentException("the task id is required.");
        }
        MemoryTaskoptions memoryTaskoptions = this;
        synchronized (memoryTaskoptions) {
            Taskoption cloned_taskoption = null;
            try {
                cloned_taskoption = taskoption.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AddTaskoptionErrorException(cloned_taskoption, (Throwable)e);
            }
            try {
                if (this.getScheduler().getTaskManager().getTask(cloned_taskoption.getTaskId()) == null) {
                    throw new InexistentTaskIdException(cloned_taskoption.getTaskId());
                }
            }
            catch (TaskManagerException e) {
                throw new AddTaskoptionErrorException(cloned_taskoption, (Throwable)e);
            }
            int task_id = cloned_taskoption.getTaskId();
            ArrayList<Taskoption> taskoptions = this.mTaskoptionsMapping.get(task_id);
            if (taskoptions == null) {
                taskoptions = new ArrayList();
                this.mTaskoptionsMapping.put(cloned_taskoption.getTaskId(), taskoptions);
            } else {
                for (Taskoption taskoption_to_check : (Collection)taskoptions) {
                    if (!taskoption_to_check.getName().equals(cloned_taskoption.getName())) continue;
                    throw new DuplicateTaskoptionException(cloned_taskoption.getTaskId(), cloned_taskoption.getName());
                }
            }
            taskoptions.add(cloned_taskoption);
            return true;
        }
    }

    @Override
    public boolean updateTaskoption(Taskoption taskoption) throws TaskoptionManagerException {
        if (taskoption == null) {
            throw new IllegalArgumentException("taskoption can't be null.");
        }
        if (taskoption.getTaskId() < 0) {
            throw new IllegalArgumentException("the task id is required.");
        }
        MemoryTaskoptions memoryTaskoptions = this;
        synchronized (memoryTaskoptions) {
            Taskoption cloned_taskoption = null;
            try {
                cloned_taskoption = taskoption.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AddTaskoptionErrorException(cloned_taskoption, (Throwable)e);
            }
            try {
                if (this.getScheduler().getTaskManager().getTask(cloned_taskoption.getTaskId()) == null) {
                    throw new InexistentTaskIdException(cloned_taskoption.getTaskId());
                }
            }
            catch (TaskManagerException e) {
                throw new UpdateTaskoptionErrorException(cloned_taskoption, (Throwable)e);
            }
            int task_id = cloned_taskoption.getTaskId();
            ArrayList<Taskoption> taskoptions = this.mTaskoptionsMapping.get(task_id);
            if (taskoptions == null) {
                return false;
            }
            Taskoption taskoption_to_remove = null;
            for (Taskoption taskoption_to_check : (Collection)taskoptions) {
                if (!taskoption_to_check.getName().equals(cloned_taskoption.getName())) continue;
                taskoption_to_remove = taskoption_to_check;
                break;
            }
            if (taskoption_to_remove == null) {
                return false;
            }
            taskoptions.remove(taskoption_to_remove);
            taskoptions.add(cloned_taskoption);
            return true;
        }
    }

    @Override
    public Taskoption getTaskoption(int taskid, String name) throws TaskoptionManagerException {
        if (taskid < 0) {
            throw new IllegalArgumentException("taskid can't be negative.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        MemoryTaskoptions memoryTaskoptions = this;
        synchronized (memoryTaskoptions) {
            int task_id = taskid;
            ArrayList<Taskoption> taskoptions = this.mTaskoptionsMapping.get(task_id);
            if (taskoptions == null) {
                return null;
            }
            for (Taskoption taskoption : (Collection)taskoptions) {
                if (!taskoption.getName().equals(name)) continue;
                return taskoption;
            }
        }
        return null;
    }

    @Override
    public Collection<Taskoption> getTaskoptions(int taskid) throws TaskoptionManagerException {
        if (taskid < 0) {
            throw new IllegalArgumentException("taskid can't be negative.");
        }
        return this.mTaskoptionsMapping.get(taskid);
    }

    @Override
    public boolean removeTaskoption(Taskoption taskoption) throws TaskoptionManagerException {
        if (taskoption == null) {
            throw new IllegalArgumentException("taskoption can't be null.");
        }
        return this.removeTaskoption(taskoption.getTaskId(), taskoption.getName());
    }

    @Override
    public boolean removeTaskoption(int taskid, String name) throws TaskoptionManagerException {
        if (taskid < 0) {
            throw new IllegalArgumentException("taskid can't be negative.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        MemoryTaskoptions memoryTaskoptions = this;
        synchronized (memoryTaskoptions) {
            int task_id = taskid;
            ArrayList<Taskoption> taskoptions = this.mTaskoptionsMapping.get(task_id);
            if (taskoptions == null) {
                return false;
            }
            Taskoption taskoption_to_remove = null;
            for (Taskoption taskoption : (Collection)taskoptions) {
                if (!taskoption.getName().equals(name)) continue;
                taskoption_to_remove = taskoption;
                break;
            }
            if (taskoption_to_remove == null) {
                return false;
            }
            taskoptions.remove(taskoption_to_remove);
        }
        return true;
    }
}

