/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler.taskoptionmanagers;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.scheduler.Scheduler;
import com.uwyn.rife.scheduler.Taskoption;
import com.uwyn.rife.scheduler.TaskoptionManager;
import com.uwyn.rife.scheduler.exceptions.TaskoptionManagerException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.AddTaskoptionErrorException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.GetTaskoptionErrorException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.GetTaskoptionsErrorException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.InstallTaskoptionsErrorException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.RemoveTaskoptionErrorException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.RemoveTaskoptionsErrorException;
import com.uwyn.rife.scheduler.taskoptionmanagers.exceptions.UpdateTaskoptionErrorException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseTaskoptions
extends DbQueryManager
implements TaskoptionManager {
    private Scheduler mScheduler = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    protected DatabaseTaskoptions(Datasource datasource) {
        super(datasource);
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.mScheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.mScheduler;
    }

    public abstract boolean install() throws TaskoptionManagerException;

    public abstract boolean remove() throws TaskoptionManagerException;

    protected boolean _install(CreateTable createTableTaskoption) throws TaskoptionManagerException {
        if (!$assertionsDisabled && createTableTaskoption == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(createTableTaskoption);
        }
        catch (DatabaseException e) {
            throw new InstallTaskoptionsErrorException(e);
        }
        return true;
    }

    protected boolean _remove(DropTable dropTableTaskoption) throws TaskoptionManagerException {
        if (!$assertionsDisabled && dropTableTaskoption == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(dropTableTaskoption);
        }
        catch (DatabaseException e) {
            throw new RemoveTaskoptionsErrorException(e);
        }
        return true;
    }

    protected boolean _addTaskoption(Insert addTaskoption, DbPreparedStatementHandler handler, Taskoption taskoption) throws TaskoptionManagerException {
        if (!$assertionsDisabled && addTaskoption == null) {
            throw new AssertionError();
        }
        if (taskoption == null) {
            throw new IllegalArgumentException("taskoption can't be null.");
        }
        boolean result = false;
        try {
            if (0 == this.executeUpdate(addTaskoption, handler)) {
                throw new AddTaskoptionErrorException(taskoption);
            }
            result = true;
        }
        catch (DatabaseException e) {
            throw new AddTaskoptionErrorException(taskoption, (Throwable)e);
        }
        return result;
    }

    protected boolean _updateTaskoption(Update updateTaskoption, DbPreparedStatementHandler handler, Taskoption taskoption) throws TaskoptionManagerException {
        if (!$assertionsDisabled && updateTaskoption == null) {
            throw new AssertionError();
        }
        if (taskoption == null) {
            throw new IllegalArgumentException("taskoption can't be null.");
        }
        boolean result = false;
        try {
            if (0 == this.executeUpdate(updateTaskoption, handler)) {
                throw new UpdateTaskoptionErrorException(taskoption);
            }
            result = true;
        }
        catch (DatabaseException e) {
            throw new UpdateTaskoptionErrorException(taskoption, (Throwable)e);
        }
        return result;
    }

    protected Taskoption _getTaskoption(Select getTaskoption, ProcessTaskoption processTaskoption, int taskId, String name) throws TaskoptionManagerException {
        if (!$assertionsDisabled && getTaskoption == null) {
            throw new AssertionError();
        }
        if (taskId < 0) {
            throw new IllegalArgumentException("taskid can't be negative.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        Taskoption taskoption = null;
        try {
            this.executeFetchFirst(getTaskoption, processTaskoption, new 1(taskId, name));
            taskoption = processTaskoption.getTaskoption();
        }
        catch (DatabaseException e) {
            throw new GetTaskoptionErrorException(taskId, name, e);
        }
        return taskoption;
    }

    protected Collection<Taskoption> _getTaskoptions(Select getTaskoptions, ProcessTaskoption processTaskoption, int taskId) throws TaskoptionManagerException {
        if (!$assertionsDisabled && getTaskoptions == null) {
            throw new AssertionError();
        }
        if (taskId < 0) {
            throw new IllegalArgumentException("taskid can't be negative.");
        }
        ArrayList<Taskoption> taskoptions = new ArrayList<Taskoption>();
        processTaskoption.setCollection(taskoptions);
        try {
            this.executeFetchAll(getTaskoptions, processTaskoption, new 2(taskId));
        }
        catch (DatabaseException e) {
            throw new GetTaskoptionsErrorException(taskId, e);
        }
        if (!$assertionsDisabled && taskoptions == null) {
            throw new AssertionError();
        }
        return taskoptions;
    }

    protected boolean _removeTaskoption(Delete removeTaskoption, Taskoption taskoption) throws TaskoptionManagerException {
        if (taskoption == null) {
            throw new IllegalArgumentException("taskoption can't be null.");
        }
        return this._removeTaskoption(removeTaskoption, taskoption.getTaskId(), taskoption.getName());
    }

    protected boolean _removeTaskoption(Delete removeTaskoption, int taskId, String name) throws TaskoptionManagerException {
        if (!$assertionsDisabled && removeTaskoption == null) {
            throw new AssertionError();
        }
        if (taskId < 0) {
            throw new IllegalArgumentException("taskid can't be negative.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(removeTaskoption, new 3(taskId, name))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new RemoveTaskoptionErrorException(taskId, name, e);
        }
        return result;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.scheduler.taskoptionmanagers.DatabaseTaskoptions");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ProcessTaskoption
    extends DbRowProcessor {
        protected Collection<Taskoption> mCollection = null;
        protected Taskoption mTaskoption = null;
        private static /* synthetic */ boolean $assertionsDisabled;

        public void setCollection(Collection<Taskoption> collection) {
            this.mCollection = collection;
        }

        @Override
        public boolean processRow(ResultSet resultSet) throws SQLException {
            if (!$assertionsDisabled && resultSet == null) {
                throw new AssertionError();
            }
            this.mTaskoption = new Taskoption();
            this.mTaskoption.setTaskId(resultSet.getInt("task_id"));
            this.mTaskoption.setName(resultSet.getString("name"));
            this.mTaskoption.setValue(resultSet.getString("value"));
            if (this.mCollection != null) {
                this.mCollection.add(this.mTaskoption);
            }
            return true;
        }

        public Taskoption getTaskoption() {
            return this.mTaskoption;
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.scheduler.taskoptionmanagers.DatabaseTaskoptions$ProcessTaskoption");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ DatabaseTaskoptions access$0(ProcessTaskoption processTaskoption) {
            return processTaskoption.DatabaseTaskoptions.this;
        }
    }

    class 1
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$taskId;
        private final /* synthetic */ String val$name;

        1(int n, String string) {
            this.val$taskId = n;
            this.val$name = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("task_id", this.val$taskId).setString("name", this.val$name);
        }

        static /* synthetic */ DatabaseTaskoptions access$0(1 var0) {
            return var0.DatabaseTaskoptions.this;
        }
    }

    class 2
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$taskId;

        2(int n) {
            this.val$taskId = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("task_id", this.val$taskId);
        }

        static /* synthetic */ DatabaseTaskoptions access$0(2 var0) {
            return var0.DatabaseTaskoptions.this;
        }
    }

    class 3
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$taskId;
        private final /* synthetic */ String val$name;

        3(int n, String string) {
            this.val$taskId = n;
            this.val$name = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("task_id", this.val$taskId).setString("name", this.val$name);
        }

        static /* synthetic */ DatabaseTaskoptions access$0(3 var0) {
            return var0.DatabaseTaskoptions.this;
        }
    }
}

